/*
    tangent vector bumpmapping shader(concreat)
    (PSv2.0 force PSv1.1)
    coded by kioku@System K
    2005/3/22
*/
float4x4 mWVP;
texture Texture0;
texture Texture1;
//local
float3 LightDir;
float3 LightPos;
float3 EyePos;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1		:	TEXCOORD1;
	float3 E		:	TEXCOORD2;//camera vector
	float3 L		:	COLOR0;//light vector
	float4 Col		:	COLOR1;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	float4 amb = {0.3f,0.3f,0.3f,1.0f};//ambient
	float3 YVec  = {0.01f,1.0f,0.01f};//Y dir vector (little dir)
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	Out.Tex0 = Tex0;
	Out.Tex1 = Tex1;
	
	//calc tangent vector
	float3 B = normalize(cross(Nor,YVec));
	float3 T = normalize(cross(B,Nor));
	B = normalize(cross(Nor,T));
	//translate tangent
	float3 E = (EyePos-Pos).xyz;
	Out.E.x = dot(E,T);
	Out.E.y = dot(E,B);
	Out.E.z = dot(E,Nor);
	float3 L = -normalize(LightDir).xyz;
	Out.L.x = dot(L,T);
	Out.L.y = dot(L,B);
	Out.L.z = dot(L,Nor);
	//calc vertex color
	Out.Col  = max(0,dot(-LightDir,Nor))*0.8f;
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	float4 amb = {0.03125f,0.03125f,0.03125f,1.0f};//ambient
	float4 cbump = {0.5f,0.5f,0.5f,0.0f};//bump
	float3 N = 1.0f*tex2D(Samp1,In.Tex1).rgb-0.5f;// from normal map
	float4 ref = max(0,dot(N, In.L));
	return tex2D(Samp0,In.Tex0)*In.Col+cbump*ref+amb;
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_1 PS();
	}
}