// Effect Shader Coded by kioku@System K
float4x4 mWVP;
texture MatTexture;
float4 Vec;
float t;

sampler Samp = sampler_state
{
	Texture = <MatTexture>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU = Clamp;
	AddressV = Clamp;
};
//-------------------------------------------------------------------
struct GLOW_VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
};

GLOW_VS_OUTPUT GLOW_VS(
	float4 Pos		:	POSITION,
	float2 Tex		:	TEXCOORD
){
	GLOW_VS_OUTPUT Out = (GLOW_VS_OUTPUT) 0;
	Out.Pos = Pos;
	Out.Tex0 = Tex;
	return Out;
}

float4 GLOW_PS( GLOW_VS_OUTPUT In) : COLOR
{
	float4 Out;
	float3 Color = tex2D(Samp, In.Tex0).rgb;
	Out.rgb = Color-0.5f;
	Out.a = 1;
	return Out;
}

technique TGlow
{
	pass P0
	{
		VertexShader = compile vs_1_1 GLOW_VS();
		PixelShader = compile ps_1_1 GLOW_PS();
	}
}
//--------------------------------------------------------------------
//#define TEXTURE_SIZE	128.0f

struct BLUR_VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1		:	TEXCOORD1;
	float2 Tex2		:	TEXCOORD2;
	float2 Tex3		:	TEXCOORD3;
};

BLUR_VS_OUTPUT BLUR_VS(
	float4 Pos		:	POSITION,
	float4 Color	:	COLOR,
	float2 Tex		:	TEXCOORD
){
	BLUR_VS_OUTPUT Out = (BLUR_VS_OUTPUT) 0;
	Out.Pos = Pos;
	Out.Tex0 = Tex+float2( 0.0f/Vec.x, 2.0f/Vec.x);
	Out.Tex1 = Tex+float2( 2.0f/Vec.x, 0.0f/Vec.x);
	Out.Tex2 = Tex+float2( 0.0f/Vec.x, 0.0f/Vec.x);
	Out.Tex3 = Tex+float2( 2.0f/Vec.x, 2.0f/Vec.x);
	return Out;
}

//float4 BLUR_PS( BLUR_VS_OUTPUT In) : COLOR
PixelShader BLUR_PS = asm
{
	ps_1_1
	def c0, 0.5f,0.5f,0.5f,0.5f
	tex t0
	tex t1
	tex t2
	tex t3
	lrp r0, c0, t0, t1       ; r0 = 0.5*t0
	lrp r1, c0, t2, t3       ; r1 = 0.5*t1
	lrp r0, c0, r0, r1		 ; r0 = 0.5*0.5*(t0+t2+t1+t3)=(t0+t2+t1+t3)/4
	
	//float4 colA = (tex2D(Samp,In.Tex0)+tex2D(Samp,In.Tex1))*0.5f;
	//float4 colB = (tex2D(Samp,In.Tex2)+tex2D(Samp,In.Tex3))*0.5f;
	//return (colA+colB)*0.5f;
};

technique TBlur
{
	pass P0
	{
		VertexShader = compile vs_1_1 BLUR_VS();
		//PixelShader = compile ps_1_1 BLUR_PS();
		Sampler[0] = (Samp);
		Sampler[1] = (Samp);
		Sampler[2] = (Samp);
		Sampler[3] = (Samp);
		PixelShader = <BLUR_PS>;//compile ps_1_1 BLUR_PS();
	}
}

