float4x4 transform;
float4x4 viewWorldTransform;
float4x4 projTransform;

struct output_t
{
  float4 pos : POSITION;
  float2 texCoord : TEXCOORD0;
  float4 color : TEXCOORD1;
};

output_t main(float4 pos : POSITION, float2 texCoord : TEXCOORD0, float4 color : COLOR0, float particleSize : BLENDWEIGHT0, float rotation : BLENDINDICES0)
{
  output_t vsOut;
	    
  float2 tPos;

  if (texCoord.x<0.5)
    tPos.x = -particleSize;
  else
	tPos.x = particleSize;

  if (texCoord.y<0.5)
    tPos.y = particleSize;
  else
    tPos.y = -particleSize;
 
  float4 rPos = mul(viewWorldTransform, pos);  

  float sinVal = sin(rotation);
  float cosVal = cos(rotation);
  rPos.xy += float2(cosVal * tPos.x - sinVal * tPos.y, sinVal * tPos.x + cosVal * tPos.y);

  vsOut.pos = mul(projTransform, rPos);
  vsOut.texCoord = texCoord;
  vsOut.color = color;
  return vsOut;
}
