float4x4 transform;
float4x4 transform2;
float4x4 worldTransform;
float4x4 projViewTransform;
float4x4 viewWorldTransform;
float4x4 viewTransform;
float4 osViewPosition;
float4 osLightPosition;
float3 lightPosition;
float4 bumpTexMatrixS;
float4 bumpTexMatrixT;
float4 diffuseTexMatrixS;
float4 diffuseTexMatrixT;
float4 specularTexMatrixS;
float4 specularTexMatrixT;

struct VSOut
{
  float4 position : POSITION;
  half2 bumpTexCoord : TEXCOORD0;
  half2 diffuseTexCoord : TEXCOORD1;
  half2 specularTexCoord : TEXCOORD2;
  half2 envTexCoord : TEXCOORD3;
  float3 lightVector : TEXCOORD4;
  //float3 halfAngle : TEXCOORD5;
  float3 viewVector : TEXCOORD5;
  float3 lightPosition : TEXCOORD6;
  float distSquared : TEXCOORD7;
};

VSOut main(float4 position : POSITION, 
		      half3 normal : NORMAL, half3 tangent : TANGENT, 
		      half2 texCoord : TEXCOORD0)
{
  VSOut output;

  // Compute vector to the light sources in object space
  float3 lightVector = osLightPosition - position;
  // Compute vector to the viewer in object space
  float3 viewVector = osViewPosition - position;

  // Construct the tangent space matrix
  float3 binormal = cross(tangent, normal);
  float3x3 tsMatrix = float3x3(tangent, binormal, normal);

  float4 viewNormal = mul(viewWorldTransform, normal);
  normalize(viewNormal);

  float4 transformedPosition = mul(transform, position);
  float4 worldPosition = mul(worldTransform, position);
  half4 tc = half4(texCoord, 0.0f, 0.0f);
  
  output.bumpTexCoord.x = dot(tc, bumpTexMatrixS);
  output.bumpTexCoord.y = dot(tc, bumpTexMatrixT);
  output.diffuseTexCoord.x = dot(tc, diffuseTexMatrixS);
  output.diffuseTexCoord.y = dot(tc, diffuseTexMatrixT);
  output.specularTexCoord.x = dot(tc, specularTexMatrixS);
  output.specularTexCoord.y = dot(tc, specularTexMatrixT);
  output.envTexCoord = 0.5 * viewNormal + float2(0.5f, 0.5f);
  output.position = transformedPosition;
  output.lightVector = mul(tsMatrix, lightVector);
  output.viewVector = mul(tsMatrix, viewVector);
  //output.halfAngle = mul(tsMatrix, normalize(viewVector + lightVector));
  output.lightPosition = lightPosition.xyz - worldPosition.xyz;
  output.distSquared = length(output.lightPosition);

  return output;
}
