// =================================================================================================
// Skin shader
// 4-bones
// =================================================================================================

float4x4 bones[50];
float4x4 worldTransform;
float4x4 projViewTransform;
float4x4 viewWorldTransform;
float4x4 blendMatrix1;
float4x4 blendMatrix2;
float4 osViewPosition;
float4 osLightPosition;
float4 bumpTexMatrixS;
float4 bumpTexMatrixT;
float4 diffuseTexMatrixS;
float4 diffuseTexMatrixT;
float4 specularTexMatrixS;
float4 specularTexMatrixT;

struct output_t
{
  float4 position : POSITION;
  half2 bumpTexCoord : TEXCOORD0;
  half2 diffuseTexCoord : TEXCOORD1;
  half2 specularTexCoord : TEXCOORD2;
  half2 envTexCoord : TEXCOORD3;
  float3 lightVector : TEXCOORD4;
  float3 halfAngle : TEXCOORD5;
};

float4x4 skin(float4 boneWeights, float4 boneIndices)
{
  float4x4 result = boneWeights.x * bones[boneIndices.x];
  result = result + boneWeights.y * bones[boneIndices.y];  
  result = result + boneWeights.z * bones[boneIndices.z];
  result = result + boneWeights.w * bones[boneIndices.w];
  return result;
}

output_t main(float4 position : POSITION, 
		      float3 normal : NORMAL, float3 tangent : TANGENT, half2 texCoord : TEXCOORD0, 
			  float4 boneWeights : BLENDWEIGHT0, float4 boneIndices : BLENDINDICES0)
{
  output_t output;

  float4x4 skinMatrix = skin(boneWeights, boneIndices);
  float4 skinnedPosition = mul(skinMatrix, position);
  float3 skinnedNormal = mul(skinMatrix, normal);
  float3 skinnedTangent = mul(skinMatrix, tangent);
  float3 skinnedBinormal = cross(skinnedTangent, skinnedNormal);

  // Compute vector to the light sources in object space
  float3 lightVector = osLightPosition - skinnedPosition;
  // Compute vector to the viewer in object space
  float3 eyeVector = osViewPosition - skinnedPosition;

  // Construct the tangent space matrix
  float3x3 tsMatrix = float3x3(skinnedTangent, skinnedBinormal, skinnedNormal);
  
  float4 viewNormal = mul(viewWorldTransform, normal);
  normalize(viewNormal);

  // Fill the output structure
  half4 tc = half4(texCoord, 0.0f, 0.0f);
  output.bumpTexCoord = dot(tc, bumpTexMatrixS);
  output.bumpTexCoord.y = dot(tc, bumpTexMatrixT);
  output.diffuseTexCoord.x = dot(tc, diffuseTexMatrixS);
  output.diffuseTexCoord.y = dot(tc, diffuseTexMatrixT);
  output.specularTexCoord.x = dot(tc, specularTexMatrixS);
  output.specularTexCoord.y = dot(tc, specularTexMatrixT);
  output.envTexCoord = 0.5 * viewNormal + float2(0.5, 0.5f);
  output.position = mul(projViewTransform, skinnedPosition);
  output.lightVector = mul(tsMatrix, lightVector);
  output.halfAngle = mul(tsMatrix, normalize(eyeVector + lightVector));

  return output;
}
