float4x4 transform;
float4 ambientTexMatrixS;
float4 ambientTexMatrixT;  

struct output_t
{
  float4 position : POSITION;
  float2 texCoord : TEXCOORD0;
};

output_t main(float4 position : POSITION, float2 texCoord : TEXCOORD0)
{
  output_t vsOut;
  vsOut.position = mul(transform, position);
  
  half4 tex4 = half4(texCoord, 0.0f, 0.0f);  
  vsOut.texCoord.x = dot(texCoord, ambientTexMatrixS);
  vsOut.texCoord.y = dot(texCoord, ambientTexMatrixT);
  return vsOut;
}

