struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_InvScreenW : INVSCREENW;
float V_InvScreenH : INVSCREENH;
float V_Alpha : ALPHA;

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 color;
  float2 xya;
  float2 xyb;
  xya.x = In.Tex0.x - V_InvScreenW;
  xya.y = In.Tex0.y - V_InvScreenH;
  xyb.x = In.Tex0.x + V_InvScreenW;
  xyb.y = In.Tex0.y + V_InvScreenH;
  color.rgba= 0.3;
  color    -= tex2D(Sampler, xya)*2.0;
  color    += tex2D(Sampler, xyb)*2.0;
  color     = (color.r+color.g+color.b)/4.0;
  color.a   = V_Alpha * color.a;
  return color;
}

technique Emboss
{
  pass PassEmboss
  {
    PixelShader = compile ps_2_0 PS();
  }
}
