#version 3.5;    
#include "colors.inc"   
#include "logo.inc"
#include "textures.inc"

#declare CoolLight=1;     // 1 = Flchenlicht    / 0 = Spotlicht
#declare UseRadiosity=1;  // 1 = Radiosity ein   / 0 = Radiosity aus     
#declare SceneType=1;     // 0 = Stifte um Logo zentriert
                          // 1 = wahllos angeordnete Stifte 

camera {
  #if (SceneType)
    location  <0,20,0>
  #else
    location  <0,10,0>
  #end
  look_at   <0,0,0>
  up        z
  right     x*image_width/image_height
}

#if (UseRadiosity)
  global_settings {
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.04
      count 35
      nearest_count 5
      error_bound 1.8
      recursion_limit 3
      low_error_factor .5
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 1
      adc_bailout 0.01/2
    }
  }
#end        

#if (CoolLight)
  #declare LightSpread = 10;      
  light_source {
    0*y color rgb 1.25
    area_light <LightSpread, 0, 0> <0, 0, LightSpread> 4,4
    adaptive 2
    jitter  // you may want to turn this off
    circular orient      
    translate <0,10,0>
  }
#else
  light_source {
    <0,5,0>
    color rgb <1,1,1>
    parallel point_at <0,0,0>
  }
#end
                      
#declare sin60 = sin(pi/3)*0.4;
#declare PenBodyColor = color rgb <1.00,0.67,0.25>;             
#declare PenColor = color rgb <0.0,0.0,0.7>;

#declare PenBody = object {             
  union {
    // Stiftkrper
    prism {
      linear_sweep linear_spline
      0,-13,7
      <0,-0.4> <sin60,-0.2> <sin60,0.2> <0,0.4> <-sin60,0.2> <-sin60,-0.2> <0,-0.4>
      rotate -90*z  
      pigment { 
        function { y*y+z*z }
        color_map {
          [0.0000 color PenBodyColor]
          [0.1369 color PenBodyColor]
          [0.1482 color White]
          [1.0000 color White]
        }
      }
      finish { phong 0.2 phong_size 50 }
    }      
    // Spitze (Plastik) 
    union {
      cylinder { <-0.1,0,0>, <0.1,0,0>, 0.345 }     
      cylinder { <0,0,0> <0.4,0,0>, 0.3 }
      cone { <0.4,0,0>, 0.3, <1.25,0,0>, 0.2 }  
      cylinder { <1.2,0,0>, <1.5,0,0>, 0.2 }
      pigment { color rgb <1,1,1>*0.2 }
      finish { phong 0.2 phong_size 10 }
    }
    // Spitze (Metall)
    union {
      cone { <1.45,0,0>, 0.105, <1.65,0,0>, 0.05 } 
      cylinder { <1.5,0,0>, <1.88,0,0>, 0.05 }
      pigment { color rgb <1,1,1>*0.9 }
      finish { phong .3 phong_size 1 }
    }
  }
}

#declare PenTip = union {
  // Rckseite
  cylinder { <-12.9,0,0>, <-13.1,0,0>, 0.345 }
  cylinder { <-13,0,0>, <-13.5,0,0>, 0.3 }
  sphere { <0,0,0>, 0.3 scale 0.2*x translate -13.5*x }
  // Farbspitze
  cylinder { <1.8,0,0>, <1.95,0,0>, 0.04 }
  sphere { <1.95,0,0>, 0.04 }
}
            
#macro Pen(Color)
  union {
    object { PenBody }
    object { PenTip pigment { color rgb Color } }
  }
#end      

#declare frac = function(x) { x-floor(x) }
#declare PaperWhite = color rgb <1,1,1>*0.9;
#declare PaperBlue = color rgb <0.7,0.7,0.9>;

plane {
  y, -sin60
  pigment {
    function { max(frac(x),frac(z)) }
    color_map {
      [0.00 color PaperWhite]
      [0.93 color PaperWhite]
      [0.96 color PaperBlue]
      [0.97 color PaperBlue]
      [1.00 color PaperWhite]
    }         
    rotate -7*y
    scale .5
  }
  normal {
    bumps .1 scale .001
  }
  finish {       
    diffuse .7
    phong 0 specular 0
  }
}

#declare LogoThing = object {
  difference {     
    merge {
      cylinder { <0,-1,0>, <0,0,0>, 1.2 }
      sphere { <0,0,0>, 1.2 scale 0.25*y }
    }
    object { Povray_Logo_Prism rotate <90,0,180> scale 3*y }
  }
  scale 1.5       
  texture {
    pigment { rgbf <0.98, 1.0, 0.99, 0.95> }
    finish {
      ambient 0.1
      diffuse 0.1
      reflection .25      
      specular 0.7
      roughness .0001 
      conserve_energy
    }
  }
  interior { ior 1.5 }
}
 
#macro MakePen(R,G,B,Angle)
  object { Pen(<R/255.0,G/255.0,B/255.0,>) translate -4*x rotate (Angle+3)*y }
#end

#macro MakePenEx1(R,G,B,px,py,Angle)
  object { Pen(<R/255.0,G/255.0,B/255.0,>) rotate Angle*y translate <-px,0,py> }
#end

#if (SceneType)
//  object { LogoThing translate <-11,0,-4> }
  object { LogoThing translate <8.5,0,-6> }
  MakePenEx1( 80, 80, 80, -2.00, +8.00, -20)
  MakePenEx1(133,190,196,-11.00, -2.00,  40)
  MakePenEx1(120,122,200, -3.00,+11.00,-125)
  MakePenEx1(105,133,110, -0.80, +4.60,-110)
  MakePenEx1(252, 96, 89, -7.00,-10.00,  75)
  MakePenEx1( 86, 80,150, -8.00, -3.00, 190)
  MakePenEx1(152,212,130,+12.00, -9.50, 140)
  MakePenEx1(255,243,105, +1.00,-10.00,  95)
  MakePenEx1(127, 89, 84, -1.30, -2.60, 240)
  MakePenEx1(224,125, 83, -2.00, -8.50, -55)
  MakePenEx1(112,140,192, +2.60, -0.20,   5)
  MakePenEx1(254,125, 83,-11.50, +3.00, 110)
  MakePenEx1(124, 83,121, +3.00, -5.50, -30)
  MakePenEx1(254,109,164, +9.00,-20.00, 110)
  MakePenEx1(134,187,246,+20.00, +0.00, 195)
  MakePenEx1(157, 80,111, -8.30,-17.50, 105)
  MakePenEx1(102, 96, 85,+16.00, +9.50, 190)
  MakePenEx1(179,126, 81, +1.70, +4.00, -10)
  MakePenEx1(189,186,190,-10.00, +4.00,  85)
  MakePenEx1(120,104,108,+10.00, -5.00, -15)
#else
  object { LogoThing }
  MakePen( 80, 80, 80,   0)
  MakePen(133,190,196,  18)
  MakePen(120,122,200,  36)
  MakePen(105,133,110,  54)
  MakePen(252, 96, 89,  72)
  MakePen( 86, 80,150,  90)
  MakePen(152,212,130, 108)
  MakePen(255,243,105, 126)
  MakePen(127, 89, 84, 144)
  MakePen(224,125, 83, 162)
  MakePen(112,140,192, 180)
  MakePen(254,125, 83, 198)
  MakePen(124, 83,121, 216)
  MakePen(254,109,164, 234)
  MakePen(134,187,246, 252)
  MakePen(157, 80,111, 270)
  MakePen(102, 96, 85, 288)
  MakePen(179,126, 81, 306)
  MakePen(189,186,190, 324)
  MakePen(120,104,108, 342)
#end
