#
# script fr zyprexa remix
#
# usage: 
# - carefully read docs.html scripting guide
# - all script-functions are case senstive!!!
# - convert with fixtimes.pl or fixtimes.exe into remix.txt
# - in engine press F5 to reload
#
# syntax:
# 
#	"$scene=bla"  			#defines a varible which is replaced later in the script
#	"f345" 					#defines a time in frames (is converted into seconds)
#	"234.0+f25" 			#is converted into 235
#
#	blocknam[10,20] {		#beginning of a 20.0 sec long block starting at 10.0 s 
#	   function($scene)		#-> 10.0 20.0 function(bla)
#		+1.0 1 anim(xxx)	#-> 11.0 1 anim(xxx)
#	}
#	anim($scene2)			#gives WARNING because $scene2 is undefined var
#  
#
#
# Valid functions:
#
#   ISetCurTechnique (int imageContainerNr, int techniqueNr)
#   ISetImageNr (int imageContainerNr, int imageNr)
#   setStartTime (int sceneID, float startTime, float timeScale) time played should be 0.0
#   loadImages (int containerID, String image1, String image2, String image3, ...)
#   loadScene (int sceneID, String sceneName):
#   animateFogColor (float rs, float gs, float bs, float rd, float gd, float bd)
#   animateFogNearFar (float nearS, float nearD, float farS, float farD)
#   animateFov (float startFov, float endFov)
#
#   enableGlow (int type)
#   animateGlow (float startIntensity, float endIntensity)
#
#   disableFogForScene (int sceneID)
#   disableMatrixElement (int matrixID) -> the source matrix should also be active
#   displayScene (int sceneID)
#   enableEffect (int effectNr)
#   enableFog ()
#
#   IAnimatePosition (int imageContainerNr, float xs, float xe, float ys, float ye)
#   IAnimateSize (int imageContainerNr, float ws, float we, float hs, float he)
#   IAnimateTransparency (int imageContainerNr, float startTransparency, float endTransp)
#   ISetEnabled (int imageContainerNr)
#   ISetInFront (int imageContainerNr)
#	animateSphereFadeIn(float scaleStart, float scaleEnd)
#
#   setAddMatrix (int matrixDestID, int matrixSourceID)
#   setCamera (int sceneID, int matrixID)
#   setDisplayMatrix (int sceneID, int matrixID)
#   setEffectCamera (int matrixID)
#   setEffectObjectTransform (int matrixID)
#   setMatrixFromScene (int matrixID, int sceneID, String MeshName)
#   setMatrixFromSceneCamera (int matrixID, int sceneID, String cameraName)
#   setMatrixIdentity (int matrixID)
#   setMatrixZero (int matrixID)
#   setNearFar (float nearPlane, float farPlane)
#   setTimeScale (int sceneID, float timeScale) time played should be 0.0
#   updateScene (int sceneID)
#	setEffectTime(effectNr, time)
#	animateLightIntensity(sceneNr, &lightsName, startIntense, endIntense)
#	setMode2()
#	animateZoomRot(zoomStart, zoomEnd, rotStart, rotEnd)
#	animateBias(biasStart, biasEnd)
#	clearOldScreen()
#	setWaterColor(r,g,b, wr,wg,wb)
#	animateScreenMultiply(sr,sg,sb, er,eg,eb )     // 0 - black ... 2 - double brightness
#	animateCameraFov(sceneNumber, startFov, endFov)
#	deutsch(String english, String deutsch)
#   end()
#	reloadTexture(int sceneNumber, String realTextureName, replaceTextureName)
#   animateOverBlend(int type, float source, float target)

### define transform-matrixes ####
$MTX_0=0
$MTX_1=1
$MTX_2=2
$MTX_3=3
$MTX_4=4


### glow-types ###
$GLOW_FAST=0
$GLOW_SMOOTH=1
$GLOW_RADIAL=2
$GLOW_MOTIONBLUR=3

### define effect-ids ####
$FX_PATTERN=1
$FX_TORUS=3
$FX_POINTERS=4
$FX_LEGOVOXEL=5
$FX_METABALLS=9
$FX_TUNNEL=10
$FX_FADEIN=11
$FX_MIRROROBJECT=12
$FX_LASER=18
$FX_FOGGING=20	#??? DOES THIS WORK?
$FX_DIMENSIONFOG=21
#$FX_SPIKETUNNEL=23	#this is not defined!
$FX_CUBOMAT=24
$FX_FUZZYOBJECT=25
$FX_FLAG=26
$FX_FLAGONOBJECT=27
$FX_PARTICLES=28
$FX_LSYSTEM=29
$FX_FUROBJECT=30
$FX_CALODOXRINGS=31
$FX_SPIRALS=33
$FX_VERTEXFUR=35
$FX_LINESPHERE=36
$FX_WATER=38
$FX_LIGHTRAYS=41
$FX_SCHWARM=42


### required for pixel-coordinate-positions (like "200x40" ###
$SCREEN_WIDTH=800
$SCREEN_HEIGHT=600

$_auto_=0
$ti= 0:29;12	# offet because of music-intro

#----------------------------------
# load scenes
#----------------------------------
#0.0 0.0 loadScene(0, &chrisObj1)
#0.0 0.0 loadScene(0, &cams)

ADD_SCENE(greetings1,greetings)
ADD_SCENE(greetings2,greetings)
ADD_SCENE(greetings3,greetings)

ADD_SCENE(greetings_cam1,greetings_cam)
ADD_SCENE(greetings_cam2,greetings_cam)
ADD_SCENE(greetings_cam3,greetings_cam)

ADD_SCENE(cam_mirror, cam_mirror)


ADD_SCENE(neurons_tom,		neurons_tom)
ADD_SCENE(cubeMap_neuronen_pink,	cubeMap_neuronen_pink)
ADD_SCENE(cubeMap_neuronen_lightblue,	cubeMap_neuronen_lightblue)
ADD_SCENE(breakup,			break)
ADD_SCENE(movingLights,		movinglight)
ADD_SCENE(cam_fx1,			cam_fx1)

ADD_SCENE(reactor_vc,		reactor_vc)
ADD_SCENE(reactor_fog,		reactor_fog)
ADD_SCENE(cam_reactor,		cam_reactor)
ADD_SCENE(displace_fisheye,displace_fisheye)

ADD_SCENE(intro_floor, intro_floor)
ADD_SCENE(intro_cam, intro_cam)
ADD_SCENE(intro_rayAimTarget, intro_rayAimTarget)
ADD_SCENE(intro_lightEdge, intro_lightEdge)
ADD_SCENE(intro_sky,skysphere_intro)

ADD_SCENE(rockneedle, rockneedle)
ADD_SCENE(cubeMap_blood_grey, cubeMap_blood_grey)
ADD_SCENE(shaft_main,	shaft_main)
ADD_SCENE(shaft_lightforms,	shaft_lightforms)
ADD_SCENE(skysphere_green,	skysphere_green)

ADD_SCENE(rockneedle_cam, rockneedle_cam)
ADD_SCENE(neuronen_nero1, neronen)
ADD_SCENE(neuronen_nero2, neronen)

ADD_SCENE(outro,outro)
ADD_SCENE(outro_lightbox,outro_lightbox)
ADD_SCENE(outro_aimtarget,outro_aimtarget)
ADD_SCENE(outro_sky,outro_sky)
ADD_SCENE(reactor2,reactor2)
ADD_SCENE(reactor2_cam,reactor2_cam)
ADD_SCENE(reactor_sky, reactor_sky)
ADD_SCENE(sphere_neuronen_blend1, sphere_neuronen_blend)
ADD_SCENE(sphere_neuronen_blend2, sphere_neuronen_blend)
ADD_SCENE(neronen_sphere, neronen_sphere)
ADD_SCENE(shaft,shaft)
ADD_SCENE(shaft_aimtarget,shaft_aimtarget)



#---------------------------
# define and load images
#---------------------------
ADD_IMAGE(img_fg_some, 			solid_white+fg_some_alpha)
ADD_IMAGE(img_end_bk, 			img_end)   				
ADD_IMAGE(img_end_credits, 		solid_white+img_end_credits_alpha)   				
ADD_IMAGE(img_solid_white, 		solid_white)   				
ADD_IMAGE(img_solid_black1, 	solid_black)   				
ADD_IMAGE(img_solid_black2, 	solid_black)   				

ADD_IMAGE(img_bg_cubomat, 	img_bg_cubomat)


ADD_IMAGE(img_nero_stimmen, 	img_nero_stimmen)
ADD_IMAGE(img_typo_zyprexahaelt, 	img_typo_zyprexahaelt+img_typo_zyprexahaelt_alpha)
ADD_IMAGE(img_typo_stimmen, 	img_typo_stimmen+img_typo_stimmen_alpha)
ADD_IMAGE(img_typo_fern, 		img_typo_fern+img_typo_fern_alpha)

ADD_IMAGE(img_nero_geisterohr, 	img_nero_geisterohr)
ADD_IMAGE(img_typo_geisterohr, 	img_typo_geisterohr+img_typo_geisterohr_alpha)
ADD_IMAGE(img_typo_schwerhoerig, 	img_typo_schwerhoerig+img_typo_schwerhoerig_alpha)

ADD_IMAGE(img_nero_daemonen, 	img_nero_daemonen)
#ADD_IMAGE(img_typo_unddie, 		img_typo_unddie+img_typo_unddie_alpha)
#ADD_IMAGE(img_typo_daemonen, 	img_typo_daemonen+img_typo_daemonen_alpha)
#ADD_IMAGE(img_typo_sindgezaehmt,img_typo_sindgezaehmt+img_typo_sindgezaehmt_alpha)

ADD_IMAGE(img_machine1, 		img_machine1+img_machine1_alpha)	#318x480
ADD_IMAGE(img_nero_zerrspiegel,	img_nero_zerrspiegel)

#ADD_IMAGE(img_strukturen_multiply,	img_strukturen_multiply)
ADD_IMAGE(img_strukturen, 			img_strukturen)

ADD_IMAGE(img_fuzzy_bg, 		img_fuzzy_bg)
ADD_IMAGE(img_fuzzy_whitestuff_alpha, 		solid_black+img_fuzzy_whitestuff_alpha)
ADD_IMAGE(img_fuzzy_erker, 		img_fuzzy_erker+img_fuzzy_erker_alpha)

ADD_IMAGE(img_centerglow_alpha,		solid_white+img_centerglow_alpha)


### typo ###
ADD_IMAGE(img_typo_0a_bauknecht              ,solid_white+img_typo_0a_bauknecht)        
ADD_IMAGE(img_typo_0a_trocken                ,solid_white+img_typo_0a_trocken)          

ADD_IMAGE(img_typo_30_credits               ,solid_white+img_typo_30_credits)          
ADD_IMAGE(img_typo_30_heaven                ,solid_white+img_typo_30_heaven)          
ADD_IMAGE(img_typo_30_breakpoint             ,solid_white+img_typo_30_breakpoint)          

#--- typo german ----
ADD_IMAGE(img_typo_0c_es_ger,         solid_black+img_typo_0c_es)
ADD_IMAGE(img_typo_0c_dreut_ger,      solid_black+img_typo_0c_dreut)
ADD_IMAGE(img_typo_0c_nicht_ger,      solid_black+img_typo_0c_nicht)
ADD_IMAGE(img_typo_0c_mehr_ger,       solid_black+img_typo_0c_mehr)
ADD_IMAGE(img_typo_0c_des_ger,        solid_black+img_typo_0c_des)
ADD_IMAGE(img_typo_0c_himmels_ger,    solid_black+img_typo_0c_himmels)
ADD_IMAGE(img_typo_0c_leere_ger,      solid_black+img_typo_0c_leere)

ADD_IMAGE(img_typo_2_dasbluetenmeer_alpha_ger,	solid_white+img_typo_2_dasbluetenmeer_alpha)
ADD_IMAGE(img_typo_2_streut_alpha_ger,			solid_white+img_typo_2_streut_alpha)
ADD_IMAGE(img_typo_2_keuschen_alpha_ger,		solid_white+img_typo_2_keuschen_alpha)
ADD_IMAGE(img_typo_2_duft_alpha_ger,			solid_white+img_typo_2_duft_alpha)

ADD_IMAGE(img_typo_3_diesonne_alpha_ger,		solid_brown+img_typo_3_diesonne_alpha)
ADD_IMAGE(img_typo_3_brennt_alpha_ger,			solid_orange+img_typo_3_brennt_alpha)
ADD_IMAGE(img_typo_3_nichtlaenger_alpha_ger,	solid_brown+img_typo_3_nichtlaenger_alpha)


ADD_IMAGE(img_typo_3b_dieerde_ger,				solid_lila_dark+img_typo_3b_dieerde_alpha)
ADD_IMAGE(img_typo_3b_gruendet_ger,				solid_lila_dark+img_typo_3b_gruendet_alpha)
ADD_IMAGE(img_typo_3b_wankt_ger,				solid_lila_dark+img_typo_3b_wankt_alpha)
ADD_IMAGE(img_typo_3b_nicht_ger,				solid_black+img_typo_3b_nicht_alpha)
ADD_IMAGE(img_typo_3b_mehr_ger,					solid_lila_dark+img_typo_3b_mehr_alpha)


ADD_IMAGE(img_typo_4_reiche_alpha_ger,			solid_white+img_typo_4_reiche_alpha)
ADD_IMAGE(img_typo_4_demut_alpha_ger,			solid_white+img_typo_4_demut_alpha)
ADD_IMAGE(img_typo_4_schneitherab_alpha_ger,	solid_white+img_typo_4_schneitherab_alpha)

ADD_IMAGE(img_typo_5_bedecktbefrieden_alpha_ger,solid_white+img_typo_5_bedecktbefrieden_alpha)
ADD_IMAGE(img_typo_5_dimensionen_alpha_ger,		solid_white+img_typo_5_dimensionen_alpha)

ADD_IMAGE(img_typo_6_des_alpha_ger,				solid_white+img_typo_6_des_alpha)
ADD_IMAGE(img_typo_6_zerrbildspiegel_alpha_ger,	solid_orange+img_typo_6_zerrbildspiegel_alpha)
ADD_IMAGE(img_typo_8_zyprexa_alpha_ger,			img_typo_8_zyprexa+img_typo_8_zyprexa_alpha)
ADD_IMAGE(img_typo_8_stimmen_alpha_ger,			img_typo_8_stimmen+img_typo_8_stimmen_alpha)
ADD_IMAGE(img_typo_9_geisterohr_alpha_ger,		img_typo_9_geisterohr+img_typo_9_geisterohr_alpha)
ADD_IMAGE(img_typo_9_schwerhoerig_alpha_ger,	img_typo_9_schwerhoerig+img_typo_9_schwerhoerig_alpha)

ADD_IMAGE(img_typo_10_unddie_alpha_ger,			solid_white+img_typo_10_unddie_alpha)
ADD_IMAGE(img_typo_10_daemonen_alpha_ger,		solid_lila_dark+img_typo_10_daemonen_alpha)
ADD_IMAGE(img_typo_14_strukturen_alpha_ger,		solid_white+img_typo_14_strukturen_alpha)
ADD_IMAGE(img_typo_14_gaenzlichneuera_alpha_ger,solid_white+img_typo_14_gaenzlichneuera_alpha)
ADD_IMAGE(img_typo_15_wachsenhervor_alpha_ger,	solid_white+img_typo_15_wachsenhervor_alpha)
ADD_IMAGE(img_typo_15_an_alpha_ger,		img_typo_15_an+img_typo_15_an_alpha)
ADD_IMAGE(img_typo_18_diewirklichkei_alpha_ger,	solid_white+img_typo_18_diewirklichkei_alpha)
ADD_IMAGE(img_typo_18_siefuegtsich_alpha_ger,	solid_white+img_typo_18_siefuegtsich_alpha)

ADD_IMAGE(img_typo_19_begraben_ger                  ,solid_orange+img_typo_19_begraben)
ADD_IMAGE(img_typo_19_wilden_ger                    ,solid_orange+img_typo_19_wilden)
ADD_IMAGE(img_typo_19_zweifel_ger                   ,solid_white+img_typo_19_zweifel)

ADD_IMAGE(img_typo_20_hirn_ger                      ,solid_white+img_typo_20_hirn)
ADD_IMAGE(img_typo_20_muskel_ger                    ,solid_white+img_typo_20_muskel)
ADD_IMAGE(img_typo_20_spasmen_ger                   ,solid_white+img_typo_20_spasmen)
ADD_IMAGE(img_typo_20_kontrolliert_ger              ,solid_white+img_typo_20_kontrolliert)

ADD_IMAGE(img_typo_21_aus_ger                       ,solid_white+img_typo_21_aus)
ADD_IMAGE(img_typo_21_erloschen_ger                 ,solid_white+img_typo_21_erloschen)
ADD_IMAGE(img_typo_21_geblasen_ger                  ,solid_white+img_typo_21_geblasen)
ADD_IMAGE(img_typo_21_irrlichter_ger                ,solid_white+img_typo_21_irrlichter)
ADD_IMAGE(img_typo_21_und_ger                       ,solid_white+img_typo_21_und)

ADD_IMAGE(img_typo_22_dersturmgebannt_ger           ,solid_lila_dark+img_typo_22_dersturmgebannt)
ADD_IMAGE(img_typo_22_gewaltenruhen_ger             ,solid_white+img_typo_22_gewaltenruhen)

ADD_IMAGE(img_typo_23_diewirklichkeit_ger           ,solid_white+img_typo_23_diewirklichkeit)
ADD_IMAGE(img_typo_23_fuegtsich_ger                 ,solid_white+img_typo_23_fuegtsich)
ADD_IMAGE(img_typo_24_harmonie_ger                  ,solid_white+img_typo_24_harmonie)
ADD_IMAGE(img_typo_24_stattwirrerlinien_ger       ,solid_white+img_typo_24_stattwirrerlinien)

ADD_IMAGE(img_typo_25_inshiergehoben_ger            ,solid_black+img_typo_25_inshiergehoben)
ADD_IMAGE(img_typo_25_dieseschicht_ger              ,solid_black+img_typo_25_dieseschicht)

ADD_IMAGE(img_typo_26_ein_ger                       ,solid_orange+img_typo_26_ein)
ADD_IMAGE(img_typo_26_inverser_ger                  ,solid_orange+img_typo_26_inverser)
ADD_IMAGE(img_typo_26_drogenrausch_ger              ,solid_orange+img_typo_26_drogenrausch)
ADD_IMAGE(img_typo_26_hilft_ger                     ,solid_white+img_typo_26_hilft)
ADD_IMAGE(img_typo_26_atmen_ger                     ,solid_white+img_typo_26_atmen)
ADD_IMAGE(img_typo_27_krebsdiamanten_ger            ,solid_lila_dark+img_typo_27_krebsdiamanten)
ADD_IMAGE(img_typo_27_und_ger                       ,solid_orange+img_typo_27_und)
ADD_IMAGE(img_typo_28_klarenglanzes_ger             ,solid_orange+img_typo_28_klarenglanzes)
ADD_IMAGE(img_typo_28_weichen_ger                   ,solid_orange+img_typo_28_weichen)

#--- typo english ---- ---------------------------------------------------------------------
ADD_IMAGE(img_typo_0c_es_eng,         solid_black+img_typo_0c_es_eng)
ADD_IMAGE(img_typo_0c_dreut_eng,      solid_black+img_typo_0c_dreut_eng)
ADD_IMAGE(img_typo_0c_nicht_eng,      solid_black+img_typo_0c_nicht_eng)
ADD_IMAGE(img_typo_0c_mehr_eng,       solid_black+img_typo_0c_mehr_eng)
ADD_IMAGE(img_typo_0c_des_eng,        solid_black+img_typo_0c_des_eng)
ADD_IMAGE(img_typo_0c_himmels_eng,    solid_black+img_typo_0c_himmels_eng)
ADD_IMAGE(img_typo_0c_leere_eng,      solid_black+img_typo_0c_leere_eng)

ADD_IMAGE(img_typo_2_dasbluetenmeer_alpha_eng,	solid_white+img_typo_2_dasbluetenmeer_alpha_eng)
ADD_IMAGE(img_typo_2_streut_alpha_eng,			solid_white+img_typo_2_streut_alpha_eng)
ADD_IMAGE(img_typo_2_keuschen_alpha_eng,		solid_white+img_typo_2_keuschen_alpha_eng)
ADD_IMAGE(img_typo_2_duft_alpha_eng,			solid_white+img_typo_2_duft_alpha_eng)

ADD_IMAGE(img_typo_3_diesonne_alpha_eng,		solid_brown+img_typo_3_diesonne_alpha_eng)
ADD_IMAGE(img_typo_3_brennt_alpha_eng,			solid_orange+img_typo_3_brennt_alpha_eng)
ADD_IMAGE(img_typo_3_nichtlaenger_alpha_eng,	solid_brown+img_typo_3_nichtlaenger_alpha_eng)


ADD_IMAGE(img_typo_3b_dieerde_eng,				solid_lila_dark+img_typo_3b_dieerde_alpha_eng)
ADD_IMAGE(img_typo_3b_gruendet_eng,				solid_lila_dark+img_typo_3b_gruendet_alpha_eng)
ADD_IMAGE(img_typo_3b_wankt_eng,				solid_lila_dark+img_typo_3b_wankt_alpha_eng)
ADD_IMAGE(img_typo_3b_nicht_eng,				solid_black+img_typo_3b_nicht_alpha_eng)
ADD_IMAGE(img_typo_3b_mehr_eng,					solid_lila_dark+img_typo_3b_mehr_alpha_eng)


ADD_IMAGE(img_typo_4_reiche_alpha_eng,			solid_white+img_typo_4_reiche_alpha_eng)
ADD_IMAGE(img_typo_4_demut_alpha_eng,			solid_white+img_typo_4_demut_alpha_eng)
ADD_IMAGE(img_typo_4_schneitherab_alpha_eng,	solid_white+img_typo_4_schneitherab_alpha_eng)

ADD_IMAGE(img_typo_5_bedecktbefrieden_alpha_eng,solid_white+img_typo_5_bedecktbefrieden_alpha_eng)
ADD_IMAGE(img_typo_5_dimensionen_alpha_eng,		solid_white+img_typo_5_dimensionen_alpha_eng)

ADD_IMAGE(img_typo_6_des_alpha_eng,				solid_white+img_typo_6_des_alpha_eng)
ADD_IMAGE(img_typo_6_zerrbildspiegel_alpha_eng,	solid_orange+img_typo_6_zerrbildspiegel_alpha_eng)
ADD_IMAGE(img_typo_8_zyprexa_alpha_eng,			img_typo_8_zyprexa_eng+img_typo_8_zyprexa_alpha_eng)
ADD_IMAGE(img_typo_8_stimmen_alpha_eng,			img_typo_8_stimmen_eng+img_typo_8_stimmen_alpha_eng)
ADD_IMAGE(img_typo_9_geisterohr_alpha_eng,		img_typo_9_geisterohr_eng+img_typo_9_geisterohr_alpha_eng)
ADD_IMAGE(img_typo_9_schwerhoerig_alpha_eng,	img_typo_9_schwerhoerig_eng+img_typo_9_schwerhoerig_alpha_eng)

ADD_IMAGE(img_typo_10_unddie_alpha_eng,			solid_white+img_typo_10_unddie_alpha_eng)
ADD_IMAGE(img_typo_10_daemonen_alpha_eng,		solid_lila_dark+img_typo_10_daemonen_alpha_eng)
ADD_IMAGE(img_typo_14_strukturen_alpha_eng,		solid_white+img_typo_14_strukturen_alpha_eng)
ADD_IMAGE(img_typo_14_gaenzlichneuera_alpha_eng,solid_white+img_typo_14_gaenzlichneuera_alpha_eng)
ADD_IMAGE(img_typo_15_wachsenhervor_alpha_eng,	solid_white+img_typo_15_wachsenhervor_alpha_eng)
ADD_IMAGE(img_typo_15_an_alpha_eng,		img_typo_15_an_eng+img_typo_15_an_alpha_eng)
ADD_IMAGE(img_typo_18_diewirklichkei_alpha_eng,	solid_white+img_typo_18_diewirklichkei_alpha_eng)
ADD_IMAGE(img_typo_18_siefuegtsich_alpha_eng,	solid_white+img_typo_18_siefuegtsich_alpha_eng)

ADD_IMAGE(img_typo_19_begraben_eng                  ,solid_orange+img_typo_19_begraben_eng)
ADD_IMAGE(img_typo_19_wilden_eng                    ,solid_orange+img_typo_19_wilden_eng)
ADD_IMAGE(img_typo_19_zweifel_eng                   ,solid_white+img_typo_19_zweifel_eng)

ADD_IMAGE(img_typo_20_hirn_eng                      ,solid_white+img_typo_20_hirn_eng)
ADD_IMAGE(img_typo_20_muskel_eng                    ,solid_white+img_typo_20_muskel_eng)
ADD_IMAGE(img_typo_20_spasmen_eng                   ,solid_white+img_typo_20_spasmen_eng)
ADD_IMAGE(img_typo_20_kontrolliert_eng              ,solid_white+img_typo_20_kontrolliert_eng)

ADD_IMAGE(img_typo_21_aus_eng                       ,solid_white+img_typo_21_aus_eng)
ADD_IMAGE(img_typo_21_erloschen_eng                 ,solid_white+img_typo_21_erloschen_eng)
ADD_IMAGE(img_typo_21_geblasen_eng                  ,solid_white+img_typo_21_geblasen_eng)
ADD_IMAGE(img_typo_21_irrlichter_eng                ,solid_white+img_typo_21_irrlichter_eng)
ADD_IMAGE(img_typo_21_und_eng                       ,solid_white+img_typo_21_und_eng)

ADD_IMAGE(img_typo_22_dersturmgebannt_eng           ,solid_lila_dark+img_typo_22_dersturmgebannt_eng)
ADD_IMAGE(img_typo_22_gewaltenruhen_eng             ,solid_white+img_typo_22_gewaltenruhen_eng)

ADD_IMAGE(img_typo_23_diewirklichkeit_eng           ,solid_white+img_typo_23_diewirklichkeit_eng)
ADD_IMAGE(img_typo_23_fuegtsich_eng                 ,solid_white+img_typo_23_fuegtsich_eng)
ADD_IMAGE(img_typo_24_harmonie_eng                  ,solid_white+img_typo_24_harmonie_eng)
ADD_IMAGE(img_typo_24_stattwirrerlinien_eng       ,solid_white+img_typo_24_stattwirrerlinien_eng)

ADD_IMAGE(img_typo_25_inshiergehoben_eng            ,solid_black+img_typo_25_inshiergehoben_eng)
ADD_IMAGE(img_typo_25_dieseschicht_eng              ,solid_black+img_typo_25_dieseschicht_eng)

ADD_IMAGE(img_typo_26_ein_eng                       ,solid_orange+img_typo_26_ein_eng)
ADD_IMAGE(img_typo_26_inverser_eng                  ,solid_orange+img_typo_26_inverser_eng)
ADD_IMAGE(img_typo_26_drogenrausch_eng              ,solid_orange+img_typo_26_drogenrausch_eng)
ADD_IMAGE(img_typo_26_hilft_eng                     ,solid_white+img_typo_26_hilft_eng)
ADD_IMAGE(img_typo_26_atmen_eng                     ,solid_white+img_typo_26_atmen_eng)
ADD_IMAGE(img_typo_27_krebsdiamanten_eng            ,solid_lila_dark+img_typo_27_krebsdiamanten_eng)
ADD_IMAGE(img_typo_27_und_eng                       ,solid_orange+img_typo_27_und_eng)
ADD_IMAGE(img_typo_28_klarenglanzes_eng             ,solid_orange+img_typo_28_klarenglanzes_eng)
ADD_IMAGE(img_typo_28_weichen_eng                   ,solid_orange+img_typo_28_weichen_eng)

#--------------------------------------------------------















ADD_IMAGE(img_typo_30_esc                   ,solid_white+img_typo_30c_esc)
#ADD_IMAGE(img_loadingscreen                   ,loadingscreen)





### typo dummy ###

ADD_IMAGE(img_solid_white_front, 		solid_white)   				

ADD_IMAGE(preload_einklang,		solid_white+img_typo_greetings_einklang_alpha)
ADD_IMAGE(preload_ephidrena,	solid_white+img_typo_greetings_ephidrena_alpha)
ADD_IMAGE(preload_kewlers,		solid_white+img_typo_greetings_kewlers_alpha)
ADD_IMAGE(preload_mawi,			solid_white+img_typo_greetings_mawi_alpha)
ADD_IMAGE(preload_stravaganza,	solid_white+img_typo_greetings_stravaganza_alpha)
ADD_IMAGE(preload_sunflower,	solid_white+img_typo_greetings_sunflower_alpha)
ADD_IMAGE(preload_tbl,			solid_white+img_typo_greetings_tbl_alpha)
ADD_IMAGE(preload_tpolm,		solid_white+img_typo_greetings_tpolm_alpha)

### switching blocks ###
$timing_v01=ON
$timing_finetune=ON
$rendering=OFF
$timing_end=ON
$off=OFF

#============================================================================================================

#----------------------------------------------------
# Bauknecht: Title
#
# who: ???
#
# todo:
#	- Name festlegen
# - Musik anpassen
# - introduction
#----------------------------------------------------



#----------------------------------------------------
# lightrays (intro-effect) / "Es *dreut* nicht mehr des Himmels Leere"
#
# who: pixtur
#
# todo:
#	- anim distance/scale
#	- sync cam / motion
#	- adjust color?
#	- logo in foreground?
#----------------------------------------------------

timing_intro [0,$_auto_,timing_v01] {

	### intro-camera ###
	setMatrixFromSceneCamera($MTX_0, $scene_intro_cam, &cam2)
	updateScene($scene_intro_cam)


	setEffectCamera($MTX_0)
	animateFov (70, 70)

	### aim rays to this point ###
	setMatrixFromScene($MTX_1, $scene_intro_rayAimTarget, &aimTarget1)
	updateScene($scene_intro_rayAimTarget)
	setLookAtPoint($MTX_1)
	enableEffect($FX_LIGHTRAYS)
	+0 0.0	setStartTime($scene_intro_rayAimTarget, 0, 	1.04)

 	### light up
	+0 7 animateLightIntensity($scene_intro_floor, &Light_0, 0,0)
	+7 1 animateLightIntensity($scene_intro_floor, &Light_0, 0,10)

	displayScene($scene_intro_floor)
	displayScene($scene_intro_lightEdge)
	+0 0.0	setStartTime($scene_intro_lightEdge, 0, 	0.0)

	### effect 41 ####


	+7 0.0	setStartTime($scene_intro_rayAimTarget, 0, 	0.4)

	### schnitt folge ###
	0:00;00 0.0	setStartTime($scene_intro_cam, 0, 	1)
	0:34;23 0.0 setStartTime($scene_intro_cam, 60, 	-0.4)
	0:45;14 0.0	setStartTime($scene_intro_cam, 0:45;15, 	1)

	0:00;00 ..		animateFov (70, 70)
	0:34;23 ..   	animateFov (40, 40)
	0:45;14 $_len_  animateFov (70, 70)

	#+30 0.0	setStartTime($scene_intro_rayAimTarget, 5, 	0.4)
	#+30 0.1  animateScale(1,4)

	0:07;00	..	animateMaxDistance(200,200)
	0:09;00	..	animateMaxDistance(60,60)
	0:24;00 .. animateMaxDistance(90,90)
	1:02;11 .. $_end_  animateMaxDistance(120,120)

	0:00;00 .. 	animateScale(0, 0)
	0:07;00 .. 	animateScale(0, 0.4)
	0:09;00 .. 	animateScale(0.4,3)
	0:17;12 .. 	animateScale(3, 40)
	0:22;00 .. 	animateScale(40,1)
	0:24;00 .. 	animateScale(1, 1)

	0:29;11 ..	animateScale(1, 30) # music: beat setzt ein
	0:29;14 ..	animateScale(30, 1)
#	0:29;19 ..	animateScale(7, 1)
	0:35;18 .. 	animateScale(3, 7)
	0:36;18 .. 	animateScale(7, 7)

	0:37;18 ..	animateScale(7, 3)
	0:40;12 .. 	animateScale(3, 22)
	0:42;15 .. 	animateScale(3, 7)
	0:47;15 .. 	animateScale(3, 3)

	0:57;07 .. 	animateScale(0.3, 7)
	0:58;07 .. 	animateScale(7,0. 3)
	1:02;11 .. 	animateScale(0.3, 2)
	1:04;00 ..	animateScale(2,0.3)
	1:09;18 ..	animateScale(3,10)
	1:09;22 .. $_end_ 	animateScale(10,3)

	### animate glow ###
	enableGlow(1)
	0:00;00 .. animateGlow(0.0, 0.0)
	0:07;00 .. animateGlow(0.0, 0.5)
	0:08;00 .. animateGlow(0.5, 0.3)
	0:29;11 ..  animateGlow(0.3,0.8)
	0:29;11+0.2 .. animateGlow(0.8,0.3)
	0:50;25 .. 	animateGlow(0.3,1)
	0:51;05 ..  animateGlow(1,0.3)
	0:53;03 ..  animateGlow(0.3,0,3)
	0:59;00 .. 	animateGlow(0.3,1)
	0:59;04 ..	animateGlow(1,0.3)
	1:01;04 ..	animateGlow(0.3,0,3)
	1:09;18 .. 	animateGlow(0.3,1)
	1:09;23 $_end_ 	animateGlow(1,0.2)
#	-10 .. $_end_ animateGlow(0.2,0.8)

	### fog ####
	animateFogColor(%243229,  %243229)
	animateFogNearFar(0, 0, 2500, 4500)
	enableFog()		#enable this for white background

	displayScene($scene_intro_sky)
	disableFogForScene($scene_intro_sky)
	setCamera($scene_intro_sky,$MTX_0)
	setNearFar(1,100000)



	### einblenden
	+0 1 animateScreenMultiply(%000000,%DDFAEB*1)
	+1 $_len_-1 animateScreenMultiply(%DDFAEB*1,%DDFAEB*1.4)

	+0 5 animateSphereFadeIn(1, 0.5)
	+5 1.8 animateSphereFadeIn(0.5, 0.05)

	### loading screen faden ###

	### cache ###
	ISetEnabled($img_solid_black1)
	ISetInFront($img_solid_black1)
	IAnimatePosition ($img_solid_black1, 0,0,0,0)
	IAnimateSize ($img_solid_black1, 800 x 100, 800 x 100)

	ISetEnabled($img_solid_black2)
	ISetInFront($img_solid_black2)
	IAnimateSize ($img_solid_black2, 800 x 100, 800 x 100)
	IAnimatePosition ($img_solid_black2, 0 x 500, 0 x 500)

	### typo title ###
	0:09;24 0:10;20 ISetEnabled		($img_typo_0a_bauknecht)
	0:09;24 1.5 	IAnimateTransparency($img_typo_0a_bauknecht,0,1)
	0:09;24+9 1 	IAnimateTransparency($img_typo_0a_bauknecht,1,0)
					ISetInFront		($img_typo_0a_bauknecht)
					IAnimatePosition($img_typo_0a_bauknecht, 20 x 370, 20 x 370)

	0:14;16 .. 0:24;16 ISetEnabled		($img_typo_0a_trocken)
	0:14;16 .. 	IAnimateTransparency($img_typo_0a_trocken,0,0.3)
	0:17;11 .. 		IAnimateTransparency($img_typo_0a_trocken,0.3,1)
    0:22;16 2 		IAnimateTransparency($img_typo_0a_trocken,1,0.0)
					ISetInFront		($img_typo_0a_trocken)
					IAnimatePosition($img_typo_0a_trocken, 350 x 362, 350 x 362)


	#### typo german ####
	$ti+0:00:21;15 0:15;25 ISetEnabled	($img_typo_0c_es_ger)
						ISetInFront		($img_typo_0c_es_ger)
						IAnimatePosition($img_typo_0c_es_ger, 250 x 371, 250 x 371)

	$ti+0:00:22;01 0:16;15 ISetEnabled	($img_typo_0c_dreut_ger)
						ISetInFront		($img_typo_0c_dreut_ger)
						IAnimatePosition($img_typo_0c_dreut_ger, 330 x 371, 330 x 371)

	$ti+0:00:22;21 0:16;02 ISetEnabled		($img_typo_0c_nicht_ger)
						ISetInFront		($img_typo_0c_nicht_ger)
						IAnimatePosition($img_typo_0c_nicht_ger, 487 x 371, 487 x 371)

	$ti+0:00:23;09 0:15;20 ISetEnabled		($img_typo_0c_mehr_ger)
						ISetInFront		($img_typo_0c_mehr_ger)
						IAnimatePosition($img_typo_0c_mehr_ger, 632 x 371, 632 x 371)

	$ti+0:00:25;13 0:13;23 ISetEnabled		($img_typo_0c_des_ger)
						ISetInFront		($img_typo_0c_des_ger)
						IAnimatePosition($img_typo_0c_des_ger, 487 x 402, 487 x 402)

	$ti+0:00:25;23 0:13;17 ISetEnabled		($img_typo_0c_himmels_ger)
						ISetInFront		($img_typo_0c_himmels_ger)
						IAnimatePosition($img_typo_0c_himmels_ger, 575 x 402, 575 x 402)


	$ti+0:00:26;07 0:13;13 ISetEnabled		($img_typo_0c_leere_ger)
				  		ISetInFront		($img_typo_0c_leere_ger)
						IAnimatePosition($img_typo_0c_leere_ger, 487 x 433, 487 x 433)




	#### typo english ####
	$ti+0:00:21;15 0:15;25 ISetEnabled	($img_typo_0c_es_eng)
						ISetInFront		($img_typo_0c_es_eng)
						IAnimatePosition($img_typo_0c_es_eng, 300 x 381, 300 x 381)

	$ti+0:00:22;01 0:16;15 ISetEnabled	($img_typo_0c_dreut_eng)
						ISetInFront		($img_typo_0c_dreut_eng)
						IAnimatePosition($img_typo_0c_dreut_eng, 375 x 381, 375 x 381)

	$ti+0:00:22;21 0:16;02 ISetEnabled		($img_typo_0c_nicht_eng)
						ISetInFront		($img_typo_0c_nicht_eng)
						IAnimatePosition($img_typo_0c_nicht_eng, 413 x 381, 413 x 381)

	$ti+0:00:23;09 0:15;20 ISetEnabled		($img_typo_0c_mehr_eng)
						ISetInFront		($img_typo_0c_mehr_eng)
						IAnimatePosition($img_typo_0c_mehr_eng, 547 x 381, 547 x 381)

	$ti+0:00:25;13 0:13;23 ISetEnabled		($img_typo_0c_des_eng)
						ISetInFront		($img_typo_0c_des_eng)
						IAnimatePosition($img_typo_0c_des_eng, 417 x 401, 417 x 401)

	$ti+0:00:25;23 0:13;17 ISetEnabled		($img_typo_0c_himmels_eng)
						ISetInFront		($img_typo_0c_himmels_eng)
						IAnimatePosition($img_typo_0c_himmels_eng, 560 x 401, 560 x 401)


	$ti+0:00:26;07 0:13;13 ISetEnabled		($img_typo_0c_leere_eng)
				  		ISetInFront		($img_typo_0c_leere_eng)
						IAnimatePosition($img_typo_0c_leere_eng, 420 x 420, 420 x 420)

}

#------------------------------------------------------------
# lsystem / "Das Bltenmeer streut keuschen Duft"
#
# who: nero
#
# todo: colors like in overpaint  0:42;20
#------------------------------------------------------------
timing_lsystem[1:12;07 , $_auto_,timing_v01] {

	#-#-drawText(&Das_Bluetenmeer_streut_keuschen_Duft)
	### initscenes ###
	setNearFar(1, 8000)
	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)

	setEffectCamera($MTX_0)
	setCamera($scene_neurons_tom, $MTX_0)
	updateScene($scene_cam_fx1)

	#displayScene($scene_helper_fxcubes)
	displayScene($scene_cubeMap_neuronen_pink)
	#displayScene($scene_movingLights)
	animateFov (90, 90)

	### timing ###
	+0 		0.0	setStartTime($scene_cam_fx1, 0, 	1)

	### effects ####
	enableEffect($FX_LSYSTEM)
	enableEffect($FX_PARTICLES)

	#	enableEffect($FX_LEGOVOXEL)
	#	enableEffect($FX_FADEIN)
	#	enableEffect($FX_LASER)
	#	enableEffect($FX_DIMENSIONFOG)
	#	enableEffect($FX_SPIKETUNNEL)
	#	enableEffect($FX_CUBOMAT)
	#	enableEffect($FX_FUZZYOBJECT)
	#	enableEffect($FX_FLAG)
	#	enableEffect($FX_FLAGONOBJECT)
	#	enableEffect($FX_CALODOXRINGS)
	#	enableEffect($FX_VERTEXFUR)
	#	enableEffect($FX_SCHWARM)


	### glow ###

	# tom - Werte 1,0.9 - disabled 02.02.2005
	# nero aktuell - 02.02.2005

	+0 2 animateGlow(0.9,0.4)

	### sound-anschlag ###	
	1:17;20 4 	animateGlow(1,0.4)
	1:17;20 4 	animateScreenMultiply(%ffffff*2,%ffffff)

	-6 2 animateGlow(0.4,0.9)
	
	+0.0 $_len_-2 enableGlow($GLOW_RADIAL)

	### FOV - nero - 02.02.2005 ####
	+0 2 animateFov(150, 70)
	+6 2 animateFov(70, 120)
	-2 2 animateFov(120, 70)

	### fog - nero - 02.02.2005 ####
	animateFogColor(%707070*1,  %A0FF20*1)
	animateFogNearFar(800, 0, 1200, 1200)
	enableFog()
	disableFogForScene($scene_cubeMap_neuronen_pink)

	### transition - nero - 02.02.2005 ####
	#-3 1 animateSphereFadeIn(0.05, 0.05)
	-2 1 animateSphereFadeIn(0.5, 0.5)
	-1 1 animateSphereFadeIn(0.9, 0.9)

	### images ##
	#ISetEnabled($img_logo_bk1)   #display container 0 (show image "bla2.jpg")
	#ISetInFront($img_logo_bk1)
	#IAnimatePosition ($img_logo_bk1, -620 x -110, -620 x -110)
	#IAnimateSize ($img_logo_bk1, 600 x 100, 600 x 100)

	#+1.5 2.0 IAnimateTransparency($img_logo_bk1, 1, 0)
	$ti+00:44;07 6	IAnimatePosition($img_typo_2_dasbluetenmeer_alpha_ger,  50 x 40, 50 x 40)
	$ti+00:44;07 6	IAnimateSize($img_typo_2_dasbluetenmeer_alpha_ger,  512 x 64, 512 x 64)
	$ti+00:44;07 6	ISetEnabled($img_typo_2_dasbluetenmeer_alpha_ger )
	$ti+00:44;07 6	ISetInFront($img_typo_2_dasbluetenmeer_alpha_ger )
	$ti+00:45;17 6	IAnimateSize($img_typo_2_streut_alpha_ger,  256 x 64, 256 x 64)
	$ti+00:45;17 6	ISetInFront($img_typo_2_streut_alpha_ger )
	$ti+00:45;17 6	ISetEnabled($img_typo_2_streut_alpha_ger )
	$ti+00:45;17 6	IAnimatePosition($img_typo_2_streut_alpha_ger,  328 x 70, 328 x 70)
	$ti+00:47;03 6	ISetEnabled($img_typo_2_keuschen_alpha_ger )
	$ti+00:47;03 6	ISetInFront($img_typo_2_keuschen_alpha_ger )
	$ti+00:47;03 6	IAnimatePosition($img_typo_2_keuschen_alpha_ger,  328 x 100, 328 x 100)
	$ti+00:47;03 6	IAnimateSize($img_typo_2_keuschen_alpha_ger,  512 x 64, 512 x 64)
	$ti+00:48;08 2	IAnimateSize($img_typo_2_duft_alpha_ger,  256 x 64, 256 x 64)
	$ti+00:48;08 2	ISetEnabled($img_typo_2_duft_alpha_ger )
	$ti+00:48;08 2	ISetInFront($img_typo_2_duft_alpha_ger )
	$ti+00:48;08 2	IAnimatePosition($img_typo_2_duft_alpha_ger,  520 x 463, 520 x 463)
	$ti+00:50;08 1.5	IAnimatePosition($img_typo_2_duft_alpha_ger,  520 x 463, 800 x 463)


	### typo english ####
	$ti+00:44;07 6	IAnimatePosition($img_typo_2_dasbluetenmeer_alpha_eng,  50 x 40, 50 x 40)
	$ti+00:44;07 6	IAnimateSize($img_typo_2_dasbluetenmeer_alpha_eng,  512 x 64, 512 x 64)
	$ti+00:44;07 6	ISetEnabled($img_typo_2_dasbluetenmeer_alpha_eng )
	$ti+00:44;07 6	ISetInFront($img_typo_2_dasbluetenmeer_alpha_eng )

	$ti+00:45;17 6	IAnimateSize($img_typo_2_streut_alpha_eng,  256 x 64, 256 x 64)
	$ti+00:45;17 6	ISetInFront($img_typo_2_streut_alpha_eng )
	$ti+00:45;17 6	ISetEnabled($img_typo_2_streut_alpha_eng )
	$ti+00:45;17 6	IAnimatePosition($img_typo_2_streut_alpha_eng,  314 x 67, 314 x 67)

	$ti+00:47;03 6	ISetEnabled($img_typo_2_keuschen_alpha_eng )
	$ti+00:47;03 6	ISetInFront($img_typo_2_keuschen_alpha_eng )
	$ti+00:47;03 6	IAnimatePosition($img_typo_2_keuschen_alpha_eng,  314 x 100, 314 x 100)
	$ti+00:47;03 6	IAnimateSize($img_typo_2_keuschen_alpha_eng,  512 x 64, 512 x 64)

	$ti+00:48;08 2	IAnimateSize($img_typo_2_duft_alpha_eng,  256 x 64, 256 x 64)
	$ti+00:48;08 2	ISetEnabled($img_typo_2_duft_alpha_eng )
	$ti+00:48;08 2	ISetInFront($img_typo_2_duft_alpha_eng )
	$ti+00:48;08 2	IAnimatePosition($img_typo_2_duft_alpha_eng,  520 x 463, 520 x 463)
	$ti+00:50;08 1.5	IAnimatePosition($img_typo_2_duft_alpha_eng,  520 x 463, 800 x 463)


}

#------------------------------------------------------------
# spirals / "Die Sonne streichelt brennt nicht laenger" ( 00:53;17     01:23;04
#
# who: pixtur/nero
#
# todo: anmerkung tom:vielleicht ohne sphere fader???
#------------------------------------------------------------

timed_spirals[01:23;04, $_auto_,timing_v01] {	#f526 / 343 / 534??

	### temp text ###
	#-#-drawText(&Die_Sonne_streicheltbrennt_nicht_laenger)

	### init scenes ###
	setNearFar(1, 8000)
	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)

	setEffectCamera($MTX_0)
	updateScene($scene_cam_fx1)
	+0 0.0	setStartTime($scene_cam_fx1, 31, 	2)
	#+0 0.0	set($scene_cam_fx1, 2)
	+0 0.0 setEffectTime($FX_SPIRALS, f4090)


	### effects ####
	enableEffect($FX_SPIRALS)

	### glow ###
	enableGlow(2)
	+0 2 animateGlow(1, 0.98)
	+2 $_len_-2 animateGlow(0.95, 0.95)
	+0 1 animateScreenMultiply(%ffffff*2,%ffffff)

	### transition - nero - 02.02.2005 ####
	#+0 1 animateSphereFadeIn(1, 1)
	#+1 1 animateSphereFadeIn(0.5, 0.5)
	#+2 1 animateSphereFadeIn(0.05, 0.05)

	### white-flash ##
 	#+3 1 animateScreenMultiply(%ffffff*2, %ffffff)
	#+3 1 ISetEnabled($img_solid_white)   #display container 0 (show image "bla2.jpg")
	#+3 1 ISetInFront($img_solid_white)
	#+3 1 IAnimateTransparency($img_solid_white, 0.4,0)
	#IAnimateSize($img_solid_white, 800x600, 800x600)


	### anschlag FOV ###
	$_start_	.. 		animateFov(150, 150)          # original 120
	1:25;11 .. 			animateFov(90, 90)
	1:25;18 .. $_end_	animateFov(60,120)  # testen...

	### fog ####

	### white-flash - old ##
	# +0 1 ISetEnabled($img_solid_white)   #display container 0 (show image "bla2.jpg")
	# +0 1 ISetInFront($img_solid_white)
	# +0 1 IAnimateTransparency($img_solid_white, 1,0)

	+0	0.0 setEffectTime($FX_SPIRALS, f4500)

	### centerglow ###
	ISetEnabled		($img_centerglow_alpha )
	ISetInFront		($img_centerglow_alpha )
	IAnimatePosition($img_centerglow_alpha,  0x0,0x0)

	### typo german ###
	$ti+00:53;17 00:04;17		ISetEnabled		($img_typo_3_diesonne_alpha_ger )
						ISetInFront		($img_typo_3_diesonne_alpha_ger )
						IAnimatePosition($img_typo_3_diesonne_alpha_ger,  10 x 255, 10 x 255)

	$ti+00:55;24 $_end_-01:25;11	ISetEnabled		($img_typo_3_brennt_alpha_ger )
					ISetInFront		($img_typo_3_brennt_alpha_ger )
					IAnimatePosition($img_typo_3_brennt_alpha_ger,    10 x 255, 10 x 255)
	$ti+00:55;24+0 1		IAnimateTransparency($img_typo_3_brennt_alpha_ger, 1,0.4)
	$ti+00:55;24+1 1		IAnimateTransparency($img_typo_3_brennt_alpha_ger, 0.4,1)
	$ti+00:55;24+2 1		IAnimateTransparency($img_typo_3_brennt_alpha_ger, 1,0.4)

	$ti+00:56;06 2.5		ISetEnabled		($img_typo_3_nichtlaenger_alpha_ger )
					ISetInFront		($img_typo_3_nichtlaenger_alpha_ger )
					IAnimatePosition($img_typo_3_nichtlaenger_alpha_ger,   10 x 255, 10 x 255)



	### typo english ###
	$ti+00:53;17 00:04;17		ISetEnabled		($img_typo_3_diesonne_alpha_eng )
						ISetInFront		($img_typo_3_diesonne_alpha_eng )
						IAnimatePosition($img_typo_3_diesonne_alpha_eng,  110 x 255, 110 x 255)

	$ti+00:55;24 $_end_-01:25;11	ISetEnabled		($img_typo_3_brennt_alpha_eng )
					ISetInFront		($img_typo_3_brennt_alpha_eng )
					IAnimatePosition($img_typo_3_brennt_alpha_eng,    110 x 255, 110 x 255)
	$ti+00:55;24+0 1		IAnimateTransparency($img_typo_3_brennt_alpha_eng, 1,0.4)
	$ti+00:55;24+1 1		IAnimateTransparency($img_typo_3_brennt_alpha_eng, 0.4,1)
	$ti+00:55;24+2 1		IAnimateTransparency($img_typo_3_brennt_alpha_eng, 1,0.4)

	$ti+00:56;06 2.5		ISetEnabled		($img_typo_3_nichtlaenger_alpha_eng )
					ISetInFront		($img_typo_3_nichtlaenger_alpha_eng )
					IAnimatePosition($img_typo_3_nichtlaenger_alpha_eng,   110 x 255, 110 x 255)



}





#------------------------------------------------------------
#  breakup / "Erde grndet wankt nicht mehr"
#
# who: pixtur
#
# 01:44;20 (r05)
# todo: anmerkung tom:vielleicht ohne sphere fader???
#------------------------------------------------------------
timing_breakup [01:28;13,$_auto_,timing_v01] {
	#-#-drawText(&Die Erde grndet)


	#-#-drawText(&genuegsam_ordnensich_die_Farben)

	### initscenes ###
	#+0 0 setMatrixFromSceneCamera($MTX_0, $scene_breakup, &persp1)
	#+0 0 setStartTime($scene_breakup,0,0.6)
	#+3.5 0 setStartTime($scene_breakup,16.2,0.3)
	#+3.5 0 setStartTime($scene_breakup, 0.2,1)

	setNearFar(1, 80000)

	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)


	updateScene($scene_cam_fx1)
	setEffectCamera($MTX_0)
	
	### white-flash ##
	+0 1 ISetEnabled($img_solid_white)   #display container 0 (show image "bla2.jpg")
	+0 1 ISetInFront($img_solid_white)
	+0 1 IAnimateTransparency($img_solid_white, 1,0)
	+0 1 IAnimateSize($img_solid_white, 800x600, 800x600)

	### scenes ###
	displayScene($scene_reactor_sky)
	displayScene($scene_breakup)
	#setTimeScale($scene_movingLights,0,0)


	### effects ###
	enableEffect($FX_PATTERN)

	+0 1 animateLightIntensity($scene_breakup, &Light_0, 1,3)

	enableGlow(2)
	+0 4 animateGlow(0.78,0.6)
	animateFov(120,80)

	### music - anschlag ####
	1:33;22  1 animateGlow(0.8,0)


	### fish-eye ###
	setMatrixFromSceneCamera($MTX_1, $scene_displace_fisheye, &camera1)
	setCamera($scene_displace_fisheye,$MTX_1)
	updateScene($scene_displace_fisheye)
	1:30;22 .. 1:31;06 enableObjectBlender($scene_displace_fisheye)
	animateCameraFov($scene_displace_fisheye, 50, 50)

	### anschlge: wechsel kamerafahrt #
	+0 0 		setStartTime($scene_cam_fx1,34+13,1)
	1:30;22 0 	setStartTime($scene_cam_fx1,40,-4)
	1:31;06 0 	setStartTime($scene_cam_fx1,34+17,1)

	$_start_ .. animateFov(120,80)
    1:30;22 ..  animateFov(120,140)
	1:31;06 ..   animateFov(100,60)
	-1 .. $_end_  animateFov(60,120)

	-0.5 0.5 animateScreenMultiply(%ffffff, %000000)


	### fog  ####
	animateFogColor(%ff009f*0.1,  %B7D5D9*0.02)
	animateFogNearFar(100, 200, 1000, 4000)

	+3.5 3.5 animateFogNearFar(0, 0, 1500, 200)
	+3.5 3.5 animateFogColor(%B7D5D9*0.02,  %ff009f*1)



	### typo german ###
	$ti+0:01:03;02 00:02;06	ISetEnabled		($img_typo_3b_dieerde_ger )
					ISetInFront		($img_typo_3b_dieerde_ger )
					IAnimatePosition($img_typo_3b_dieerde_ger,  205 x 338, 205 x 338)

	$ti+0:01:03;00 00:02;08	ISetEnabled		($img_typo_3b_gruendet_ger )
					ISetInFront		($img_typo_3b_gruendet_ger )
					IAnimatePosition($img_typo_3b_gruendet_ger,  205 x 338+50, 205 x 338+50)

	$ti+0:01:02;10 00:03;02	ISetEnabled		($img_typo_3b_wankt_ger )
					ISetInFront		($img_typo_3b_wankt_ger )
					IAnimatePosition($img_typo_3b_wankt_ger,  205 x 338+100, 205 x 338+100)

	$ti+0:01:02;00 00:04;02	ISetEnabled		($img_typo_3b_nicht_ger )
					ISetInFront		($img_typo_3b_nicht_ger )
					IAnimatePosition($img_typo_3b_nicht_ger,  205 x 338+150, 205 x 338+150)

	$ti+0:01:01;18 00:04;05	ISetEnabled		($img_typo_3b_mehr_ger )
					ISetInFront		($img_typo_3b_mehr_ger )
					IAnimatePosition($img_typo_3b_mehr_ger,  205 x 338+200, 205 x 338+200)

	### typo english ###
	$ti+0:01:03;02 00:02;06	ISetEnabled		($img_typo_3b_dieerde_eng )
					ISetInFront		($img_typo_3b_dieerde_eng )
					IAnimatePosition($img_typo_3b_dieerde_eng,  205 x 388, 205 x 388)

	$ti+0:01:03;00 00:02;08	ISetEnabled		($img_typo_3b_gruendet_eng )
					ISetInFront		($img_typo_3b_gruendet_eng )
					IAnimatePosition($img_typo_3b_gruendet_eng,  205 x 388+30, 205 x 388+30)

	$ti+0:01:02;10 00:03;02	ISetEnabled		($img_typo_3b_wankt_eng )
					ISetInFront		($img_typo_3b_wankt_eng )
					IAnimatePosition($img_typo_3b_wankt_eng,  205 x 388+60, 205 x 388+60)

	$ti+0:01:02;00 00:04;02	ISetEnabled		($img_typo_3b_nicht_eng )
					ISetInFront		($img_typo_3b_nicht_eng )
					IAnimatePosition($img_typo_3b_nicht_eng,  205 x 388+90, 205 x 388+90)

	$ti+0:01:01;18 00:04;05	ISetEnabled		($img_typo_3b_mehr_eng )
					ISetInFront		($img_typo_3b_mehr_eng )
					IAnimatePosition($img_typo_3b_mehr_eng,  205 x 388+120, 205 x 388+120)






	-2 1 	ISetEnabled		($img_solid_white_front )
	-2 1 	ISetInFront		($img_solid_white_front )
	-2 1 	IAnimatePosition($img_solid_white_front,  205 x 338+200, 205 x 338+200)
	-2 1 	IAnimateTransparency($img_solid_white_front, 1,0)

	-1 1 animateSphereFadeIn(0.2, 1)

	
}


#-------------------------------------------------------------------------------
#  mirrorObject
#	"Gengsam ordnen sich die Farben"  (ab 1:06;17)
#	"Reiche Demut schneit herab"  (1:15;05)
#
# who: Pixtur/Nero
#
# todo:
# - camera(s)
# - lyrics
#-------------------------------------------------------------------------------
timing_mirrorobj [01:36;03,$_auto_,timing_v01] {


	#+0 2 animateOverBlend(0, 1, 0)
	### dummytext ###
 	#-#-drawText(&Reiche_Demutschneit_herab)

	### init scenes ###
	setNearFar(1, 8000)
	#setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)
	setMatrixFromSceneCamera($MTX_0, $scene_cam_mirror, &cam_mirror)
	setEffectCamera($MTX_0)
	+0 0.0 setStartTime($scene_cam_mirror, 0,	0.98)
	updateScene($scene_cam_mirror)

	### display Scenes ###
	displayScene($scene_reactor_vc)
	+0 4 displayScene($scene_shaft_lightforms)
	# displayScene($scene_grid_hex)

	### effects ####
	enableEffect($FX_MIRROROBJECT)
	#+0 0 setEffectTime($FX_MIRROROBJECT, 3)	# ok aber nicht perfekt
	+0 0 setEffectTime($FX_MIRROROBJECT, 120)	# ok aber nicht perfekt  81!!    90!  110
	enableEffect($FX_TUNNEL)
	enableEffect($FX_PATTERN)

 	### FOV ####
#	+0 1 animateFov(56, 70)
#	+1 5 animateFov(70, 140)
#	+1 2 animateFov(140, 70)
#	-3 3 animateFov(70, 120)

	+0 8.3 animateFov(56, 110)

#	-2 2 animateFov(90, 10)

 	### glow ###
	+0 1 animateGlow(1,0.8)
	+1 3 animateGlow(0.8, 0.1)
	-2 2 animateGlow(0.1, 0.3)
	enableGlow(0)
#	animateZoomRot(1, 0, 0, 0)
#  +0 5 animateZoomRot(1, 0.95, 1, 1)

	#+0 8 animateBias(1, 0)
	#-2 2 animateBias(0, 1)
	
	# GLOW_FAST=0
	# GLOW_SMOOTH=1
	# GLOW_RADIAL=2
	# GLOW_MOTIONBLUR=3

	### color multiply ###
#	animateScreenMultiply(%ff009f*0.5,%B0B0B0*0.9)
#	animateScreenMultiply(%ffffff*1,%ff1122*1)
#	+0 8.3 animateScreenMultiply(%ff009f*0.9,%ff009f*0.5)

	#+0 1:12;03 animateScreenMultiply(%FF18B7*1,%ffffff*0.5)
	+0 8.5-1 animateScreenMultiply(%FFFFFF*0.5,%FF18B7*1)
	+8.5-1 1 animateScreenMultiply(%FF18B7*1, %FF18B7*2)


  	### fog ####
#	animateFogColor(%ff009f*0.5,  %B7D5D9*0.02)
#	animateFogNearFar(100, 200, 150, 2000)
#	enableFog()
	+0 8.3 animateFogColor(%ff009f*0.2,  %B7D5D9*0.02)
	-3 1 animateFogColor(%B7D5D9*0.02,  %FF18B7*1)
	+0 8.3 animateFogNearFar(50, 200, 1000, 4000)
	-1 1 animateFogNearFar(200, 50, 4000, 3000)
	enableFog()


	### white-flash ##
	$ti+1:15;03 1 ISetEnabled($img_solid_white)   #display container 0 (show image "bla2.jpg")
	$ti+1:15;03 1 ISetInFront($img_solid_white)
	$ti+1:15;03 1 IAnimateTransparency($img_solid_white, 1,0)
	$ti+1:15;03 1 IAnimateSize($img_solid_white, 800x600, 800x600)


	### anschlag 2 music 2 ###
#	1:18;03 1 animateGlow(0.2,0.1)
	$ti+1:18;03 2 animateScreenMultiply(%FF7CD6*2, %ffffff)


	### typo german ###
	$ti+01:06;22 6	ISetEnabled		($img_typo_4_reiche_alpha_ger )
	$ti+01:06;22 6	ISetInFront		($img_typo_4_reiche_alpha_ger )
	$ti+01:06;22 6	IAnimatePosition($img_typo_4_reiche_alpha_ger,  520 x 484, 520 x 484)
	$ti+01:06;22 1	IAnimateTransparency($img_typo_4_reiche_alpha_ger, 1, 0.8)
	$ti+01:06;22+5 1	IAnimateTransparency($img_typo_4_reiche_alpha_ger, 0.8, 0)


	$ti+01:07;22 16.4	ISetEnabled		($img_typo_4_demut_alpha_ger )
	$ti+01:07;22 16.4	ISetInFront		($img_typo_4_demut_alpha_ger )
	$ti+01:07;22 16.4	IAnimatePosition($img_typo_4_demut_alpha_ger,  650 x 484, 650 x 484)
	$ti+01:07;22 1	IAnimateTransparency($img_typo_4_demut_alpha_ger, 1, 0.8)
	#$ti+01:10;00+0 1	IAnimateTransparency($img_typo_4_demut_alpha, 0.8,0 )
	#$ti+01:10;00+1 1	IAnimateTransparency($img_typo_4_demut_alpha, 0,1 )
	$ti+01:10;00+2 1	IAnimateTransparency($img_typo_4_demut_alpha_ger, 1,0 )
	$ti+01:10;00+3 1	IAnimateTransparency($img_typo_4_demut_alpha_ger, 0,1 )
	$ti+01:10;00+4 1	IAnimateTransparency($img_typo_4_demut_alpha_ger, 1,0 )
	$ti+01:10;00+5 1	IAnimateTransparency($img_typo_4_demut_alpha_ger, 0,1 )
	

	$ti+01:08;22 5	ISetEnabled		($img_typo_4_schneitherab_alpha_ger )
	$ti+01:08;22 5	IAnimatePosition($img_typo_4_schneitherab_alpha_ger,  520 x 499, 520 x 499)
	$ti+01:08;22 5	ISetInFront		($img_typo_4_schneitherab_alpha_ger )
	$ti+01:08;22 1	IAnimateTransparency($img_typo_4_schneitherab_alpha_ger, 1, 0.8)
	$ti+01:08;22+4 1  IAnimateTransparency($img_typo_4_schneitherab_alpha_ger, 0.8, 0)


	### typo english ###
	$ti+01:06;22 6	ISetEnabled		($img_typo_4_reiche_alpha_eng )
	$ti+01:06;22 6	ISetInFront		($img_typo_4_reiche_alpha_eng )
	$ti+01:06;22 6	IAnimatePosition($img_typo_4_reiche_alpha_eng,  480 x 484, 480 x 484)
	$ti+01:06;22 1	IAnimateTransparency($img_typo_4_reiche_alpha_eng, 1, 0.8)
	$ti+01:06;22+5 1	IAnimateTransparency($img_typo_4_reiche_alpha_eng, 0.8, 0)


	$ti+01:07;22 16.4	ISetEnabled		($img_typo_4_demut_alpha_eng )
	$ti+01:07;22 16.4	ISetInFront		($img_typo_4_demut_alpha_eng )
	$ti+01:07;22 16.4	IAnimatePosition($img_typo_4_demut_alpha_eng,  590 x 484, 590 x 484)
	$ti+01:07;22 1	IAnimateTransparency($img_typo_4_demut_alpha_eng, 1, 0.8)
	#$ti+01:10;00+0 1	IAnimateTransparency($img_typo_4_demut_alpha, 0.8,0 )
	#$ti+01:10;00+1 1	IAnimateTransparency($img_typo_4_demut_alpha, 0,1 )
	$ti+01:10;00+2 1	IAnimateTransparency($img_typo_4_demut_alpha_eng, 1,0 )
	$ti+01:10;00+3 1	IAnimateTransparency($img_typo_4_demut_alpha_eng, 0,1 )
	$ti+01:10;00+4 1	IAnimateTransparency($img_typo_4_demut_alpha_eng, 1,0 )
	$ti+01:10;00+5 1	IAnimateTransparency($img_typo_4_demut_alpha_eng, 0,1 )


	$ti+01:08;22 5	ISetEnabled		($img_typo_4_schneitherab_alpha_eng )
	$ti+01:08;22 5	IAnimatePosition($img_typo_4_schneitherab_alpha_eng,  472 x 510, 472 x 510)
	$ti+01:08;22 5	ISetInFront		($img_typo_4_schneitherab_alpha_eng )
	$ti+01:08;22 1	IAnimateTransparency($img_typo_4_schneitherab_alpha_eng, 1, 0.8)
	$ti+01:08;22+4 1  IAnimateTransparency($img_typo_4_schneitherab_alpha_eng, 0.8, 0)



	-1 1 ISetEnabled		($img_solid_white_front )
	-1 1 ISetInFront		($img_solid_white_front )
	-1 1 IAnimateSize($img_solid_white_front,  800x600, 800x600)
	-1 1 IAnimateTransparency($img_solid_white_front,  0,1)



}


#-------------------------------------------------------------------------------
# Dimension-Metaballs / "bedeckt befriedend dimensionen"
#
# who: nero
#
# todo:

# - textur ersetzen
# - Feinschliff
#-------------------------------------------------------------------------------
timing_dimensionen [01:53;10,$_auto_,timing_v01] {

	### setup cam ###
	setNearFar(850, 18000)
	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)
	setEffectCamera($MTX_0)
	+0 0.0 setStartTime($scene_cam_fx1, 20,	0.07)
	updateScene($scene_cam_fx1)

	### scenes ###
	displayScene($scene_cubeMap_blood_grey)
	displayScene($scene_movingLights)

 	animateLightIntensity($scene_movingLights, &Omni01-LIGHT, 20,90)
	
	### effects ###
	enableEffect($FX_METABALLS)
	enableEffect($FX_PARTICLES)

	### glow & blur ###
	disableFogForScene($scene_cubeMap_blood_grey)
	animateZoomRot(1, 0, 0.5, 0)    # org 1, 0 , 0.5 ,0
	animateGlow(0.6, 0.78)          # org 0.6 0.78
	enableGlow($GLOW_MOTIONBLUR)

	+1 1 animateBias(1, 0)

	### anschlag music ###
	#$ti+1:36;15 2 animateScreenMultiply(%ffffff*2,%ffffff)
	#$ti+1:36;15 2 animateFogColor(%ffffff,%FF18B7)
	
	### FOV ###
	#+0 3 animateFov(120, 70)
	#+5 3 animateFov(70, 30)
	#+8 1 animateFov(30, 70)
	#+9 1 animateFov(70, 40)
	#-1 1 animateFov(70, 250)

	$_start_ ..  			animateFov(120, 100)
	0:01:56;17 .. 			animateFov(90, 90)
	0:01:56;21 ..			animateFov(70, 70)
	0:01:57;00 ..			animateFov(60, 60)
	0:01:57;04 .. $_end_	animateFov(50, 70)

#	$ti+1:34;00 20 animateFov(75, 50)
	2:06;02 $_end_-2:06;02  animateScreenMultiply(%FF18B7*1.4,%ff1122*0.7)       # tusch
	#2:06;02 1  animateGlow(1,0.78)
	#$ti+1:39;10 1  animateScreenMultiply(%FF18B7*1.4,%ff1122*0.7)        # plong
	
	### multiply###
	#+0 1 animateScreenMultiply(%FF18B7*1.8,%ff1122*0.7)
	#+1 4 animateScreenMultiply(%FF18B7*0.9,%FF18B7*0.7)
	#-5 5 animateScreenMultiply(%ff1122*0.7,%FFFFFF*0.8)

	### fog ###
	animateFogColor(%FFFFFF*1,  %FF18B7*1)
	animateFogNearFar(150, 150, 3600, 3600)
	enableFog()
	
	### white-flash ###
	2:06;02 1   ISetEnabled($img_solid_white)
    2:06;02 1    IAnimateTransparency($img_solid_white, 1, 0)

	-1 1 ISetEnabled($img_solid_white)   #display container 0 (show image "bla2.jpg")
	ISetInFront($img_solid_white)
	-1 1 IAnimateTransparency($img_solid_white, 0, 1)
	-1 1 IAnimateSize($img_solid_white, 1200x900, 1200x900)

	### transition  ##
#	-1 1 ISetEnabled($img_bg_cubomat)   #display container 0 (show image "bla2.jpg")
#	-1 1 ISetInFront($img_bg_cubomat)
#	-1 1 IAnimateTransparency($img_bg_cubomat, 0, 0.5 )
# -1 1 IAnimateSize($img_bg_cubomat, 1200x900, 800x600)
# -1 1 IAnimatePosition($img_bg_cubomat, -100x-100, 0x0)
  


	$ERRORS_TIMING=off;

	### typo german ###
	$ti+01:32;06 2	IAnimateTransparency($img_typo_5_bedecktbefrieden_alpha_ger , 0, 1)
	$ti+01:32;06 7	ISetEnabled		($img_typo_5_bedecktbefrieden_alpha_ger )
	$ti+01:32;06 7	ISetInFront		($img_typo_5_bedecktbefrieden_alpha_ger )
	$ti+01:32;06 7	IAnimatePosition($img_typo_5_bedecktbefrieden_alpha_ger,  6 x 259, 6 x 259)
	$ti+01:32;06 7	IAnimateSize	($img_typo_5_bedecktbefrieden_alpha_ger,  512 x 64, 512 x 64)
	$ti+01:37;06 2	IAnimateTransparency($img_typo_5_bedecktbefrieden_alpha_ger , 1, 0)

	2:06;02 9	IAnimateSize	($img_typo_5_dimensionen_alpha_ger,  720 x 90, 720 x 90)
	2:06;02 9	ISetInFront		($img_typo_5_dimensionen_alpha_ger )
	2:06;02 9	ISetEnabled		($img_typo_5_dimensionen_alpha_ger )
	2:06;02 9	IAnimatePosition($img_typo_5_dimensionen_alpha_ger,  0 x 280, 0 x 280)

	
	$ti+01:38;13 8	IAnimateSize	($img_typo_6_des_alpha_ger,  160 x 79, 160 x 79)
	$ti+01:38;13 8	ISetEnabled		($img_typo_6_des_alpha_ger )
	$ti+01:38;13 8	ISetInFront		($img_typo_6_des_alpha_ger )
	$ti+01:38;13 8	IAnimatePosition($img_typo_6_des_alpha_ger,  660 x 294, 660 x 294)


	### typo english ###
	$ti+01:32;06 2	IAnimateTransparency($img_typo_5_bedecktbefrieden_alpha_eng , 0, 1)
	$ti+01:32;06 7	ISetEnabled		($img_typo_5_bedecktbefrieden_alpha_eng )
	$ti+01:32;06 7	ISetInFront		($img_typo_5_bedecktbefrieden_alpha_eng )
	$ti+01:32;06 7	IAnimatePosition($img_typo_5_bedecktbefrieden_alpha_eng,  6 x 259, 6 x 259)
	$ti+01:32;06 7	IAnimateSize	($img_typo_5_bedecktbefrieden_alpha_eng,  512 x 64, 512 x 64)
	$ti+01:37;06 2	IAnimateTransparency($img_typo_5_bedecktbefrieden_alpha_eng , 1, 0)

	2:06;02 9	IAnimateSize	($img_typo_5_dimensionen_alpha_eng,  720 x 90, 720 x 90)
	2:06;02 9	ISetInFront		($img_typo_5_dimensionen_alpha_eng )
	2:06;02 9	ISetEnabled		($img_typo_5_dimensionen_alpha_eng )
	2:06;02 9	IAnimatePosition($img_typo_5_dimensionen_alpha_eng,  0 x 280, 0 x 280)


	$ti+01:38;13 8	IAnimateSize	($img_typo_6_des_alpha_eng,  160 x 79, 160 x 79)
	$ti+01:38;13 8	ISetEnabled		($img_typo_6_des_alpha_eng )
	$ti+01:38;13 8	ISetInFront		($img_typo_6_des_alpha_eng )
	$ti+01:38;13 8	IAnimatePosition($img_typo_6_des_alpha_eng,  610 x 293, 610 x 293)





	$ERRORS_TIMING=1;

}



#-------------------------------------------------------------------------------
# Cubomat/ "dimension"-glow
#  "Des Zerrbildspiegel labyrinths"
#
# who: nero
#
# todo:
# - lyrics
# - transition zu greetings (black boxen)
#-------------------------------------------------------------------------------
timing_zerrspiegellabyrinth [2:11;08,$_auto_,timing_v01] {
	### dummytext ###
	#-#-drawText(&des_zerrspiegellabyrinths)
	
	### camera ###
	setNearFar(1, 8000)
	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)
	setEffectCamera($MTX_0)
	+0 0 setStartTime($scene_cam_fx1, 20, 0.6)
	updateScene($scene_cam_fx1)
	
	### effect ###
	enableEffect($FX_CUBOMAT)
	
	### field of view ###
	animateFov(10, 30)
	
	+0 2 animateScreenMultiply(%ffffff*2, %ffffff)

	### centerglow ###
	ISetEnabled		($img_centerglow_alpha )
	ISetInFront		($img_centerglow_alpha )
	IAnimatePosition($img_centerglow_alpha,  0x50,0x50)
	+0 8 IAnimateTransparency($img_centerglow_alpha ,1 ,0)


	### glow ###
	animateZoomRot(1, 0, 1, 0)
	animateGlow(0.6, 0.1)
	enableGlow(3)

	### background ###
	ISetEnabled($img_nero_zerrspiegel)

	$ti+01:41;22 10.75	ISetEnabled($img_nero_zerrspiegel)
	$ti+01:41;22 10.75	IAnimateSize($img_nero_zerrspiegel,  900 x 700, 800 x 600)


	IAnimateSize($img_nero_zerrspiegel, 900x700,800x600)
	IAnimatePosition ($img_nero_zerrspiegel, 0x0,-220x-250)

	### typo german ####
	$ti+01:42;13 1	IAnimateTransparency($img_typo_5_dimensionen_alpha_ger , 0.9,0.15, 0.9,0.15)
	$ti+01:42;20 3		IAnimateTransparency($img_typo_6_zerrbildspiegel_alpha_ger, 1,0)

	ISetEnabled($img_typo_6_zerrbildspiegel_alpha_ger )
	ISetInFront($img_typo_6_zerrbildspiegel_alpha_ger )
	IAnimatePosition($img_typo_6_zerrbildspiegel_alpha_ger,  26 x 310, 26 x 310)
	IAnimateSize($img_typo_6_zerrbildspiegel_alpha_ger,  800 x 100, 800 x 100)


	### typo english ####
	$ti+01:42;13 1	IAnimateTransparency($img_typo_5_dimensionen_alpha_eng , 0.9,0.15, 0.9,0.15)
	$ti+01:42;20 3		IAnimateTransparency($img_typo_6_zerrbildspiegel_alpha_eng, 1,1)

	ISetEnabled($img_typo_6_zerrbildspiegel_alpha_eng )
	ISetInFront($img_typo_6_zerrbildspiegel_alpha_eng )
	IAnimatePosition($img_typo_6_zerrbildspiegel_alpha_eng,  20 x 310, 20 x 310)
	IAnimateSize($img_typo_6_zerrbildspiegel_alpha_eng,  800 x 110, 800 x 110)




}

#-------------------------------------------------------------------------------
# light shaft / Greetingspart
#
# who: pixtur/nero
#
# todo:
# - gruppen festlegen
# - typo / design
#-------------------------------------------------------------------------------
timing_greetings [02:22;04,$_auto_,timing_v01] {
	#-#-drawText(&greetings)


	### initbackground scenes ###
	setMatrixFromSceneCamera($MTX_1, $scene_shaft_main, &cam1)
	+0 0.0	setStartTime($scene_shaft_main, 0, 	0.3)
	updateScene($scene_shaft_main)
	displayScene($scene_shaft_main)
	setCamera($scene_shaft_main,$MTX_1)		# already default
	displayScene($scene_shaft_lightforms)
	updateScene($scene_intro_cam)			# already default
	setEffectCamera($MTX_1)
	animateFov (80, 80)
	setNearFar(1, 8000)
	animateCameraFov($scene_shaft_main, 60,100)
	animateCameraFov($scene_shaft_lightforms, 60,100)		

	### anschlag hihat ###
	$ti+0:01:58;02 2 animateScreenMultiply(%ffffff*2, %ffffff)
	$ti+0:01:58;02 2 animateScreenMultiply(%ffffff*2, %ffffff)

	02:30;16 1 animateScreenMultiply(%FF18B7*1.5, %ffffff)

	### init greetings0 ###
	setMatrixFromSceneCamera($MTX_0, $scene_greetings_cam1, &cam1)
	updateScene($scene_greetings_cam1)
	+0 0 setStartTime($scene_greetings1,0,0)
	+0 0 setStartTime($scene_greetings_cam1,0,0)
	setCamera($scene_greetings1,$MTX_0)
	displayScene($scene_greetings1)

	### init greetings2 ###
	setMatrixFromSceneCamera($MTX_2, $scene_greetings_cam2, &cam1)
	updateScene($scene_greetings_cam2)
	+0 0 setStartTime($scene_greetings2,0,0)
	+0 0 setStartTime($scene_greetings_cam2,0,0)
	setCamera($scene_greetings2,$MTX_2)
	displayScene($scene_greetings2)

	### init greetings3 ###
	setMatrixFromSceneCamera($MTX_2, $scene_greetings_cam2, &cam1)
	updateScene($scene_greetings_cam2)
	+0 0 setStartTime($scene_greetings2,0,0)
	+0 0 setStartTime($scene_greetings_cam2,0,0)
	setCamera($scene_greetings2,$MTX_2)
	displayScene($scene_greetings2)



	#--- 1:sunflower	1:58;05
	$ti+1:58;05 0 setStartTime($scene_greetings_cam1,f10,0)
	$ti+1:58;05 0 setStartTime($scene_greetings1,0,2.5)
	$ti+1:58;05 0 reloadTexture($scene_greetings1, &typo_alpha, &img_typo_greetings_sunflower_alpha)

	#--- 2:tbl			2:00;18  (f30)
	$ti+2:00;18 0 setStartTime($scene_greetings_cam2,f150,0)
	$ti+2:00;18 0 setStartTime($scene_greetings2,0,2.5)
	$ti+2:00;18 0 reloadTexture($scene_greetings2, &typo_alpha, &img_typo_greetings_tbl_alpha)

	#--- 3:tpolm		2:03;09
	$ti+2:03;09 0 setStartTime($scene_greetings_cam3,f50,0)
	$ti+2:03;09 0 setStartTime($scene_greetings3,0,2.5)
	$ti+2:03;09 0 reloadTexture($scene_greetings3, &typo_alpha, &img_typo_greetings_tpolm_alpha)

	#--- 1:ephidrena	2:05;15
	$ti+2:05;15 0 setStartTime($scene_greetings_cam1,f80,0)
	$ti+2:05;15 0 setStartTime($scene_greetings1,0,2.5)
	$ti+2:05;15 0 reloadTexture($scene_greetings1, &typo_alpha, &img_typo_greetings_ephidrena_alpha)

	#--- 2:einklang		2:07;03
	$ti+2:07;03 0 setStartTime($scene_greetings_cam2,f90,0)
	$ti+2:07;03 0 setStartTime($scene_greetings2,0,2.5)
	$ti+2:07;03 0 reloadTexture($scene_greetings2, &typo_alpha, &img_typo_greetings_einklang_alpha)
 	
	#--- 3:kewlers		2:08;15
	$ti+2:08;15 0 setStartTime($scene_greetings_cam2,f110,0)
	$ti+2:08;15 0 setStartTime($scene_greetings2,0,2.5)
	$ti+2:08;15 0 reloadTexture($scene_greetings2, &typo_alpha, &img_typo_greetings_kewlers_alpha)

	#--- 1:mawi			2:11;21
	$ti+2:11;21 0 setStartTime($scene_greetings_cam1,f150,0)
	$ti+2:11;21 0 setStartTime($scene_greetings1,0,2.5)
	$ti+2:11;21 0 reloadTexture($scene_greetings1, &typo_alpha, &img_typo_greetings_mawi_alpha)
	
	#--- 2:stravaganza	2:14;19
	#2:14;19 0 setStartTime($scene_greetings_cam2,f50,0)
	#2:14;19 0 setStartTime($scene_greetings2,0,2.5)
	#2:14;19 0 reloadTexture($scene_greetings2, &typo_alpha, &img_typo_greetings_stravaganza_alpha)


	## fog ###
	animateFogColor(%D79EA7*1,  %D79EA7*1)
	animateFogNearFar(0, 0, 6600, 1600)
	enableFog()

	disableFogForScene($scene_shaft_lightforms)

	-6 6 animateFogNearFar(0, 0, 1600, 0)
	-6 6 animateFogColor(%D79EA7*1,  %ffffff*1)

	### more light! ###
	+0 3 animateLightIntensity($scene_shaft_main, &Light_0, 100,2)
	+0 3 animateLightIntensity($scene_shaft_main, &Light_1, 100,50)
	-2 2 animateLightIntensity($scene_shaft_main, &Light_0, 5,1000)

	### glow ###
	+0 $_len_-2 animateGlow(0.8, 0.9)
	enableGlow(1)
	-2 2 animateGlow(0.8, 1)
	-5 2 animateLightIntensity($scene_shaft_main, &Light_0, 3,0)


	### image machine ###
	ISetEnabled($img_machine1)
	ISetInFront($img_machine1)
	IAnimateTransparency($img_machine1, 1, 1)

    IAnimatePosition ($img_machine1, 10x-150, 90x-30)
	IAnimateSize ($img_machine1, 318x480, 159x240)

	### cache ###
	ISetEnabled($img_solid_black1)   #display container 0 (show image "bla2.jpg")
	ISetInFront($img_solid_black1)
    IAnimatePosition ($img_solid_black1, 0,0,0,0)
	IAnimateSize ($img_solid_black1, 800 x 100, 800 x 100)

	ISetEnabled($img_solid_black2)   #display container 0 (show image "bla2.jpg")
	ISetInFront($img_solid_black2)
	IAnimateSize ($img_solid_black2, 800 x 100, 800 x 100)
    IAnimatePosition ($img_solid_black2, 0 x 500, 0 x 500)

	### weissblitz ###
	-2 2 ISetEnabled($img_solid_white_front)   #display container 0 (show image "bla2.jpg")
	-2 2 ISetInFront($img_solid_white_front)
    -2 2 IAnimatePosition ($img_solid_white_front, 0,0,0,0)
	-2 2 IAnimateSize ($img_solid_white_front, 800 x 600, 800 x 600)
	-2 2 IAnimateTransparency ($img_solid_white_front, 0,1)


}



#-------------------------------------------------------------------------------
# Bitmap "netdancer" / "Zyprexa hlt die Stimmen fern"
#
# who: nero
#
# todo:
# - finetuning
# - lyrics
#-------------------------------------------------------------------------------
timing_stimmen [2:49;05,$_auto_,timing_v01] {


	+0 2 animateScreenMultiply(%DDFAEB*2, %ffffff)

	### main image ###

	### fade image ###
	ISetEnabled($img_nero_stimmen)
	IAnimateSize($img_nero_stimmen, 1000 x 750, 800 x 600)
	IAnimateTransparency ($img_nero_stimmen,1,0.6)
	IAnimatePosition ($img_nero_stimmen,-200 x -100, 0 x 0)

	### typo german
	$ti+02:20;04 4.5	ISetEnabled($img_typo_8_zyprexa_alpha_ger )
	$ti+02:20;04 4.5	ISetInFront($img_typo_8_zyprexa_alpha_ger )
	$ti+02:20;04 4.5	IAnimatePosition($img_typo_8_zyprexa_alpha_ger,  220 x 480, 290 x 480)
	$ti+02:20;04 4.5	IAnimateSize($img_typo_8_zyprexa_alpha_ger,  512 x 64, 512 x 64)
	$ti+02:20;04 4.5		ISetEnabled($img_typo_8_stimmen_alpha_ger )
	$ti+02:20;04 4.5		ISetInFront($img_typo_8_stimmen_alpha_ger )
	$ti+02:20;04 4.5		IAnimatePosition($img_typo_8_stimmen_alpha_ger,  290 x 499, 220 x 499)
	$ti+02:20;04 4.5		IAnimateSize($img_typo_8_stimmen_alpha_ger,  512 x 64, 512 x 64)
	$ti+02:24;00 0.8	IAnimateTransparency($img_typo_8_zyprexa_alpha_ger , 1, 0)
	$ti+02:24;04 0.5		IAnimateTransparency($img_typo_8_stimmen_alpha_ger , 1, 0)

	### typo english
	$ti+02:20;04 4.5	ISetEnabled($img_typo_8_zyprexa_alpha_eng )
	$ti+02:20;04 4.5	ISetInFront($img_typo_8_zyprexa_alpha_eng )
	$ti+02:20;04 4.5	IAnimatePosition($img_typo_8_zyprexa_alpha_eng,  220 x 480, 290 x 480)
	$ti+02:20;04 4.5	IAnimateSize($img_typo_8_zyprexa_alpha_eng,  512 x 64, 512 x 64)
	$ti+02:20;04 4.5		ISetEnabled($img_typo_8_stimmen_alpha_eng )
	$ti+02:20;04 4.5		ISetInFront($img_typo_8_stimmen_alpha_eng )
	$ti+02:20;04 4.5		IAnimatePosition($img_typo_8_stimmen_alpha_eng,  290 x 499, 220 x 499)
	$ti+02:20;04 4.5		IAnimateSize($img_typo_8_stimmen_alpha_eng,  512 x 64, 512 x 64)
	$ti+02:24;00 0.8	IAnimateTransparency($img_typo_8_zyprexa_alpha_eng , 1, 0)
	$ti+02:24;04 0.5		IAnimateTransparency($img_typo_8_stimmen_alpha_eng , 1, 0)

}



#-------------------------------------------------------------------------------
# bitmap "urban demon"  / "Das Geisterohr macht es schwerhrig"
#
# who: nero
#
# todo:
# - finetuning
# - lyrics
#-------------------------------------------------------------------------------
timing_geisterohr [2:54;12,$_auto_,timing_v01] {
	#-drawText(&Das_Geisterohr_macht_es_schwerhoerig)
	
	### main image ###
	ISetEnabled($img_nero_geisterohr )
	#ISetInFront($img_nero_geisterohr )
	IAnimateTransparency($img_nero_geisterohr ,1,0.5)
	IAnimateSize($img_nero_geisterohr,  800 x 600, 1000 x 750)
	IAnimatePosition($img_nero_geisterohr,  0 x 00, -20 x -40)
	

	### typo GERMAN ###
	$ti+02:25;10 4.9		ISetEnabled($img_typo_9_geisterohr_alpha_ger )
	$ti+02:25;10 4.9		ISetInFront($img_typo_9_geisterohr_alpha_ger )
	$ti+02:25;10 4.9		IAnimatePosition($img_typo_9_geisterohr_alpha_ger,  140 x 463, 220 x 463)
	$ti+02:25;10 4.9		IAnimateSize($img_typo_9_geisterohr_alpha_ger,  512 x 64, 512 x 64)
	$ti+02:25;10 4.9		IAnimateSize($img_typo_9_schwerhoerig_alpha_ger,  512 x 64, 512 x 64)
	$ti+02:25;10 4.9		ISetEnabled($img_typo_9_schwerhoerig_alpha_ger )
	$ti+02:25;10 4.9		ISetInFront($img_typo_9_schwerhoerig_alpha_ger )
	$ti+02:25;10 4.9		IAnimatePosition($img_typo_9_schwerhoerig_alpha_ger,  220 x 550, 220 x 499)
	$ti+02:28;22 0.8	IAnimateTransparency($img_typo_9_schwerhoerig_alpha_ger , 1, 0)
	$ti+02:29;04 1		IAnimateTransparency($img_typo_9_geisterohr_alpha_ger , 1, 0)

	### typo english ###
	$ti+02:25;10 4.9		ISetEnabled($img_typo_9_geisterohr_alpha_eng )
	$ti+02:25;10 4.9		ISetInFront($img_typo_9_geisterohr_alpha_eng )
	$ti+02:25;10 4.9		IAnimatePosition($img_typo_9_geisterohr_alpha_eng,  140 x 463, 220 x 463)
	$ti+02:25;10 4.9		IAnimateSize($img_typo_9_geisterohr_alpha_eng,  512 x 64, 512 x 64)
	$ti+02:25;10 4.9		IAnimateSize($img_typo_9_schwerhoerig_alpha_eng,  512 x 64, 512 x 64)
	$ti+02:25;10 4.9		ISetEnabled($img_typo_9_schwerhoerig_alpha_eng )
	$ti+02:25;10 4.9		ISetInFront($img_typo_9_schwerhoerig_alpha_eng )
	$ti+02:25;10 4.9		IAnimatePosition($img_typo_9_schwerhoerig_alpha_eng,  220 x 550, 220 x 499)
	$ti+02:28;22 0.8	IAnimateTransparency($img_typo_9_schwerhoerig_alpha_eng , 1, 0)
	$ti+02:29;04 1		IAnimateTransparency($img_typo_9_geisterohr_alpha_eng , 1, 0)

}



#-------------------------------------------------------------------------------
# bitmap "mad clown"/ "Und die Demonen sind gezhmt"
#
# who: nero
#
# todo:
# - finetuning
# - lyrics
# - tom: dieses Bild sollte weich in die Reaktorszene bergehen...
#-------------------------------------------------------------------------------
timing_daemonen [2:59;21,$_auto_,timing_v01] {
	
	### main image ###
	+0 $_len_+6 ISetEnabled($img_nero_daemonen )
	+0 $_len_+6 ISetInFront($img_nero_daemonen )
	+0+$_len_  6 IAnimateTransparency($img_nero_daemonen ,1,0)
	
	+0 $_len_+6 IAnimateSize($img_nero_daemonen,  800 x 600, 1000 x 750)
	+0 $_len_+6 IAnimatePosition($img_nero_daemonen,  0 x 0, -70 x -71)
	
	### typo german ###
	$ti+02:30;09 5		ISetEnabled($img_typo_10_unddie_alpha_ger )
	$ti+02:30;09 5		ISetInFront($img_typo_10_unddie_alpha_ger )
	$ti+02:30;09 5		IAnimatePosition($img_typo_10_unddie_alpha_ger,  80 x 268, 80 x 268)
	$ti+02:30;09 5		IAnimateSize($img_typo_10_unddie_alpha_ger,  256 x 64, 256 x 64)
	$ti+02:30;09 5		ISetEnabled($img_typo_10_daemonen_alpha_ger )
	$ti+02:30;09 5		ISetInFront($img_typo_10_daemonen_alpha_ger ,)
	$ti+02:30;09 5		IAnimatePosition($img_typo_10_daemonen_alpha_ger,  220 x 268, 220 x 268)
	$ti+02:30;09 5		IAnimateSize($img_typo_10_daemonen_alpha_ger,  512 x 127, 512 x 127)
	$ti+02:34;09 1		IAnimateTransparency($img_typo_10_unddie_alpha_ger , 1, 0)
	$ti+02:34;09 1		IAnimateTransparency($img_typo_10_daemonen_alpha_ger , 1, 0)

	### typo english ###
	$ti+02:30;09 5		ISetEnabled($img_typo_10_unddie_alpha_eng )
	$ti+02:30;09 5		ISetInFront($img_typo_10_unddie_alpha_eng )
	$ti+02:30;09 5		IAnimatePosition($img_typo_10_unddie_alpha_eng,  40 x 268, 40 x 268)
	$ti+02:30;09 5		IAnimateSize($img_typo_10_unddie_alpha_eng,  256 x 64, 256 x 64)

	$ti+02:30;09 5		ISetEnabled($img_typo_10_daemonen_alpha_eng )
	$ti+02:30;09 5		ISetInFront($img_typo_10_daemonen_alpha_eng ,)
	$ti+02:30;09 5		IAnimatePosition($img_typo_10_daemonen_alpha_eng,  220 x 268, 220 x 268)
	$ti+02:30;09 5		IAnimateSize($img_typo_10_daemonen_alpha_eng,  512 x 127, 512 x 127)
	$ti+02:34;09 1		IAnimateTransparency($img_typo_10_unddie_alpha_eng , 1, 0)
	$ti+02:34;09 1		IAnimateTransparency($img_typo_10_daemonen_alpha_eng , 1, 0)
}




#-------------------------------------------------------------------------------
# reactorscene + flag / "Begraben sind die wilden Zweifel"
#
# who: pixtur
#
# todo:
# - camera + finetuning
#-------------------------------------------------------------------------------
timing_reactor [3:05;22,$_auto_,timing_v01] {

	### initscenes ###
#	+31 1 setNearFar(1, 800)
	setNearFar(1, 12000)
	setMatrixFromSceneCamera($MTX_0, $scene_reactor2, &cam_reactor)
	+0 0.0	setStartTime($scene_reactor2, 0, 	1)

	setEffectCamera($MTX_0)
	updateScene($scene_reactor2_cam)

	#setWaterColor(%9BC7BE, %101010)
	setWaterColor(%ffffff, %000000)

	animateLightIntensity($scene_reactor2, &Light_0, 1,0)
	animateLightIntensity($scene_reactor2, &Light_1, 1,1)

	#+0 1 animateLightIntensity($scene_reactor_vc, &Light_1, 10,2)
	#+65 2 animateLightIntensity($scene_reactor_vc, &Light_1, 0,2)
	#+72 6 animateLightIntensity($scene_reactor_vc, &Light_1, 2,10)

	displayScene($scene_reactor2)
	#+0 30 displayScene($scene_reactor_fog)

    +0 6 animateFov (100, 100)

	### sky ###
	#displayScene($scene_reactor_sky)
	+0 0 setStartTime($scene_reactor_sky,0,0 )
	#disableFogForScene($scene_outro_sky)
	setCamera($scene_outro_sky,$MTX_0)


	### effects ####
	enableEffect($FX_FLAG)
	enableEffect($FX_WATER)
	#enableEffect($FX_PATTERN)



	### glow ###
	#+0 $_len_-2 animateGlow(0.6, 0.1)
	#-2 2 animateGlow(0.6, 1)
	+0 13 animateGlow(0.3, 0.3)
	+13 4 animateGlow(0.3, 0.9)
	+18 4 animateGlow(0.9, 0.4)
	enableGlow(1)

	### fog ###
	+0 $_len_-2 animateFogColor(%ffffff*0.8,%808080)
	+0 $_len_-2 animateFogNearFar(0, 0, 3800, 3800)
	#-2 2 animateFogNearFar(100, 100, 8000, 0)
	animateFogColor(%ffffff*0.8,%ffffff*1)
	animateFogNearFar(0, 0, 4200, 4200)
	enableFog()


	### fog ####
	#animateFogColor(0.1, 0.1, 0.1,  0.1, 0.1, 0.1)
	#+87 20 animateFogColor(1, 1, 1,  0.3, 0.9, 0.3)
	#animateFogColor(0.3, 0.1, 0.2,  0.3, 0.1, 0.2)
    #animateFogNearFar(200, 200, 60000, 60000)
	#+0 40 animateFogNearFar(200, 200, 2000, 2000)
	#+40 10 animateFogNearFar(200, 200, 2000, 8000)
	#+56 4 animateFogNearFar(200, 200, 2500, 8000)
	#+65 15  animateFogNearFar(200, 100, 8000, 100)
	#+87 10  animateFogNearFar(200, 000, 2000, 1900)
	#+87 20 enableEffect($FX_PATTERN)

	enableFog()
	#disableFogForScene($scene_cubeMap_neuronen_pink)


	### fish-eye ###
	#setMatrixFromSceneCamera($MTX_1, $scene_displace_fisheye, &camera1)
	#setCamera($scene_displace_fisheye,$MTX_1)
	#updateScene($scene_displace_fisheye)
	#enableObjectBlender($scene_displace_fisheye)
	#animateCameraFov($scene_displace_fisheye, 50, 50)

	### typo german ###
	$ti+2:40;11 0:12;10	ISetEnabled			($img_typo_19_begraben_ger)
	$ti+2:40;11 2		IAnimateTransparency($img_typo_19_begraben_ger, 0, 1)
	$ti+2:50;11 2	IAnimateTransparency($img_typo_19_begraben_ger, 1, 0)
						ISetInFront			($img_typo_19_begraben_ger)
	$ti+2:40;11 0:12;10	 IAnimatePosition	($img_typo_19_begraben_ger, 0 x 337,50 x 337)

	$ti+2:45;10 0:10;19	ISetEnabled			($img_typo_19_wilden_ger)
	$ti+2:45;10 2		 IAnimateTransparency($img_typo_19_wilden_ger, 0, 1)
	$ti+2:53;10 2		 IAnimateTransparency($img_typo_19_wilden_ger, 1, 0)
	$ti+2:45;10 0:10;19	ISetInFront			($img_typo_19_wilden_ger)
	$ti+2:45;10 0:10;19	IAnimatePosition	($img_typo_19_wilden_ger, 540 x 337,520 x 337)

	$ti+2:45;10 0:23;10	ISetEnabled			($img_typo_19_zweifel_ger)
	$ti+2:45;10 2		IAnimateTransparency($img_typo_19_zweifel_ger, 0, 1)
	$ti+2:45;10 0:23;10	ISetInFront			($img_typo_19_zweifel_ger)
	$ti+2:45;10 0:23;10	IAnimatePosition	($img_typo_19_zweifel_ger,540 x 357,520 x 357)
#	$ti+2:45;10 0:23;10	IAnimateTransparency($img_typo_19_zweifel, 0, 1)
	   3:23;19+0 1 IAnimateTransparency($img_typo_19_zweifel_ger, 1, 0)
	   3:23;19+1 1 IAnimateTransparency($img_typo_19_zweifel_ger, 0, 1)
	   3:23;19+2 1 IAnimateTransparency($img_typo_19_zweifel_ger, 1, 0)
	   3:23;19+3 1 IAnimateTransparency($img_typo_19_zweifel_ger, 0, 1)
	   3:23;19+4 1 IAnimateTransparency($img_typo_19_zweifel_ger, 1, 0)
	   3:23;19+5 1 IAnimateTransparency($img_typo_19_zweifel_ger, 0, 1)
	   3:23;19+7 1 IAnimateTransparency($img_typo_19_zweifel_ger, 1, 0)

	### typo english ###
	$ti+2:40;11 0:12;10	ISetEnabled			($img_typo_19_begraben_eng)
	$ti+2:40;11 2		IAnimateTransparency($img_typo_19_begraben_eng, 0, 1)
	$ti+2:50;11 2	IAnimateTransparency($img_typo_19_begraben_eng, 1, 0)
						ISetInFront			($img_typo_19_begraben_eng)
	$ti+2:40;11 0:12;10	 IAnimatePosition	($img_typo_19_begraben_eng, 0 x 337,50 x 337)

	$ti+2:45;10 0:10;19	ISetEnabled			($img_typo_19_wilden_eng)
	$ti+2:45;10 2		 IAnimateTransparency($img_typo_19_wilden_eng, 0, 1)
	$ti+2:53;10 2		 IAnimateTransparency($img_typo_19_wilden_eng, 1, 0)
	$ti+2:45;10 0:10;19	ISetInFront			($img_typo_19_wilden_eng)
	$ti+2:45;10 0:10;19	IAnimatePosition	($img_typo_19_wilden_eng, 540 x 337,520 x 337)

	$ti+2:45;10 0:23;10	ISetEnabled			($img_typo_19_zweifel_eng)
	$ti+2:45;10 2		IAnimateTransparency($img_typo_19_zweifel_eng, 0, 1)
	$ti+2:45;10 0:23;10	ISetInFront			($img_typo_19_zweifel_eng)
	$ti+2:45;10 0:23;10	IAnimatePosition	($img_typo_19_zweifel_eng,540 x 357,520 x 357)
#	$ti+2:45;10 0:23;10	IAnimateTransparency($img_typo_19_zweifel, 0, 1)
	   3:23;19+0 1 IAnimateTransparency($img_typo_19_zweifel_eng, 1, 0)
	   3:23;19+1 1 IAnimateTransparency($img_typo_19_zweifel_eng, 0, 1)
	   3:23;19+2 1 IAnimateTransparency($img_typo_19_zweifel_eng, 1, 0)
	   3:23;19+3 1 IAnimateTransparency($img_typo_19_zweifel_eng, 0, 1)
	   3:23;19+4 1 IAnimateTransparency($img_typo_19_zweifel_eng, 1, 0)
	   3:23;19+5 1 IAnimateTransparency($img_typo_19_zweifel_eng, 0, 1)
	   3:23;19+7 1 IAnimateTransparency($img_typo_19_zweifel_eng, 1, 0)
}

 
 
#-------------------------------------------------------------------------------
# Zoomtorus / "Hirnmuskelspasmen kontrolliert"
#
# who: nero
#
# todo:
# - finetuning
#-------------------------------------------------------------------------------
timing_hirnmuskelspasmen [3:42;12,$_auto_,timing_v01] {
	#-drawText(&Hirnmuskelspasmen_kontrolliert)

	setNearFar(1, 80000)

	###  camera ###
	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)
	+0 0.0	setStartTime($scene_cam_fx1, 50, 	-1)	
	setEffectCamera($MTX_0)
	updateScene($scene_cam_fx1)
	animateFov(80,120)

	### particles front ###
	setMatrixFromSceneCamera($MTX_1, $scene_reactor2, &cam_reactor)
	+0 0.0	setStartTime($scene_reactor2, 10, 	1)
	updateScene($scene_reactor2   )

	setCamera($scene_sphere_neuronen_blend1, $MTX_1)
	displayScene($scene_sphere_neuronen_blend1)
	+0 0 setStartTime($scene_sphere_neuronen_blend1,0, 1)
	animateFov($scene_sphere_neuronen_blend2, 100,100)

	setCamera($scene_sphere_neuronen_blend2, $MTX_1)
	displayScene($scene_sphere_neuronen_blend2)
	+0 0 setStartTime($scene_sphere_neuronen_blend1,0, 1)
	animateFov($scene_sphere_neuronen_blend2, 102,102)


	animateLightIntensity($scene_movingLights, &Omni01-LIGHT, 260,260)
	displayScene($scene_movingLights)

	### scenes & effects ###
	enableEffect($FX_TORUS)
	enableEffect($FX_PARTICLES)
	displayScene($scene_movingLights)
	+0 0 setStartTime($scene_movingLights,0,0)
	displayScene($scene_cubeMap_neuronen_pink)


	#enableGlow(2)
	#animateGlow(0.98,0.9)

	enableGlow(3)
	#animateBias(0.9,1.0)
	#animateGlow(0.8,0.95)
	animateGlow(0.80,0.9)
	animateZoomRot(1, 1.01,   0, 0.8)

	+1 1  animateFogColor(1,1,1,  0,0,0)
	animateFogColor(0,0,0,  0,0,0)
    #animateFogNearFar(0, 0, 55000, 55000)
	#enableFog()
	#-1 1 animateFogColor(0,0,0,  1,1,1)
	#+0 ..  animateScreenMultiply(%A59103*2,%91A5A1*2)
	animateScreenMultiply(%91A5f1*2,%ffffff*2)




	### typo german
	$ti+03:13;02 0:05;06	ISetEnabled		($img_typo_20_hirn_ger)
	$ti+03:13;02 0:05;06	IAnimatePosition($img_typo_20_hirn_ger, 90 x 500,90 x 500)
	$ti+03:13;02 1			IAnimateTransparency($img_typo_20_hirn_ger, 1, 0.3)
							ISetInFront			($img_typo_20_hirn_ger)

	$ti+03:13;17 0:05;07	ISetEnabled		($img_typo_20_muskel_ger)
	$ti+03:13;17 0:05;07	IAnimatePosition($img_typo_20_muskel_ger, 90 x 500,90 x 500)
	$ti+03:13;17 1			IAnimateTransparency($img_typo_20_muskel_ger, 1, 0.3)
							ISetInFront			($img_typo_20_muskel_ger)

	$ti+03:13;23 0:05;06	ISetEnabled		($img_typo_20_spasmen_ger)
	$ti+03:13;23 0:05;06	IAnimatePosition($img_typo_20_spasmen_ger, 90 x 500,90 x 500)
	$ti+03:13;23 1			IAnimateTransparency($img_typo_20_spasmen_ger, 1, 0.3)
							ISetInFront			($img_typo_20_spasmen_ger)

	$ti+03:16;23 0:05;06	ISetEnabled		($img_typo_20_kontrolliert_ger)
	$ti+03:16;23 0:05;06	IAnimatePosition($img_typo_20_kontrolliert_ger, 490 x 500,490 x 500)
	$ti+03:16;23 2			IAnimateTransparency($img_typo_20_kontrolliert_ger, 0, 1)
	$ti+03:19;10 3		IAnimateTransparency($img_typo_20_kontrolliert_ger, 1, 0)
							ISetInFront			($img_typo_20_kontrolliert_ger)

	### typo english
	$ti+03:13;02 0:05;06	ISetEnabled		($img_typo_20_hirn_eng)
	$ti+03:13;02 0:05;06	IAnimatePosition($img_typo_20_hirn_eng, 90 x 500,90 x 500)
	$ti+03:13;02 1			IAnimateTransparency($img_typo_20_hirn_eng, 1, 0.3)
							ISetInFront			($img_typo_20_hirn_eng)

	$ti+03:13;17 0:05;07	ISetEnabled		($img_typo_20_muskel_eng)
	$ti+03:13;17 0:05;07	IAnimatePosition($img_typo_20_muskel_eng, 90 x 500,90 x 500)
	$ti+03:13;17 1			IAnimateTransparency($img_typo_20_muskel_eng, 1, 0.3)
							ISetInFront			($img_typo_20_muskel_eng)

	$ti+03:13;23 0:05;06	ISetEnabled		($img_typo_20_spasmen_eng)
	$ti+03:13;23 0:05;06	IAnimatePosition($img_typo_20_spasmen_eng, 90 x 500,90 x 500)
	$ti+03:13;23 1			IAnimateTransparency($img_typo_20_spasmen_eng, 1, 0.3)
							ISetInFront			($img_typo_20_spasmen_eng)

	$ti+03:16;23 0:05;06	ISetEnabled		($img_typo_20_kontrolliert_eng)
	$ti+03:16;23 0:05;06	IAnimatePosition($img_typo_20_kontrolliert_eng, 490 x 500,490 x 500)
	$ti+03:16;23 2			IAnimateTransparency($img_typo_20_kontrolliert_eng, 0, 1)
	$ti+03:19;10 3		IAnimateTransparency($img_typo_20_kontrolliert_eng, 1, 0)
							ISetInFront			($img_typo_20_kontrolliert_eng)

}




#-------------------------------------------------------------------------------
# ? fuzzy object / "Irrlichter ausgeblasen und erloschen"
#
# who: tom
#
# todo:
# - rough design
# - lyrics
#-------------------------------------------------------------------------------
timing_fuzzyobject[3:53;09,$_auto_, timing_v01] {
	#-drawText(&Irrlichter_ausgeblasen)




	### effect ###
	+0 0 clearOldScreen()

	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)
	+0 0.0	setStartTime($scene_cam_fx1, 1, 	0.5)	
	setEffectCamera($MTX_0)
	updateScene($scene_cam_fx1)

	enableEffect($FX_FUZZYOBJECT)

	enableGlow(1)
	+0 1 animateGlow(1,0.6)

  	setEffectObjectTransform ($MTX_0)

	### overlay ###
	ISetEnabled($img_fuzzy_erker)
	ISetInFront($img_fuzzy_erker)
	IAnimatePosition ($img_fuzzy_erker, 0 x 380, -140 x 380)


	### overlay ###
	ISetEnabled($img_fuzzy_whitestuff_alpha)
	ISetInFront($img_fuzzy_whitestuff_alpha)
	IAnimatePosition ($img_fuzzy_whitestuff_alpha, 0x0, -60 x 0)


	### background ###
	ISetEnabled($img_fuzzy_bg)
	IAnimatePosition ($img_fuzzy_bg, -170 x 0, -200 x 0)


	### typo german ###
		3:53;09 0:05;08	ISetEnabled		($img_typo_21_irrlichter_ger)
		3:53;09 0:05;08	IAnimatePosition($img_typo_21_irrlichter_ger, 50 x 200,50 x 200)
		3:53;09 2			IAnimateTransparency($img_typo_21_irrlichter_ger, 1, 0.7)
							ISetInFront		($img_typo_21_irrlichter_ger)

	$ti+03:26;03 0:03;00	ISetEnabled		($img_typo_21_aus_ger)
	$ti+03:26;03 0:03;00	IAnimatePosition($img_typo_21_aus_ger, 50 x 200,50 x 200)
	$ti+03:26;03 2			IAnimateTransparency($img_typo_21_aus_ger, 1, 0.7)
							ISetInFront		($img_typo_21_aus_ger)

	$ti+03:26;10 0:02;18	ISetEnabled		($img_typo_21_geblasen_ger)
	$ti+03:26;10 0:02;18	IAnimatePosition($img_typo_21_geblasen_ger, 50 x 200,50 x 200)
	$ti+03:26;10 2			IAnimateTransparency($img_typo_21_geblasen_ger, 1, 0.7)
							ISetInFront		($img_typo_21_geblasen_ger)

	$ti+03:27;11 0:01;17	ISetEnabled		($img_typo_21_und_ger)
	$ti+03:27;11 0:01;17	IAnimatePosition($img_typo_21_und_ger, 50 x 200,50 x 200)
	$ti+03:27;11 2			IAnimateTransparency($img_typo_21_und_ger, 1, 0.7)
							ISetInFront		($img_typo_21_und_ger)

	$ti+03:27;18 0:01;10	ISetEnabled		($img_typo_21_erloschen_ger)
	$ti+03:27;18 0:01;10	IAnimatePosition($img_typo_21_erloschen_ger, 50 x 200,50 x 200)
	$ti+03:27;18 2			IAnimateTransparency($img_typo_21_erloschen_ger, 1, 0.7)
							ISetInFront		($img_typo_21_erloschen_ger)

	### typo english ###
		3:53;09 0:05;08	ISetEnabled		($img_typo_21_irrlichter_eng)
		3:53;09 0:05;08	IAnimatePosition($img_typo_21_irrlichter_eng, 50 x 200,50 x 200)
		3:53;09 2			IAnimateTransparency($img_typo_21_irrlichter_eng, 1, 0.7)
							ISetInFront		($img_typo_21_irrlichter_eng)

	$ti+03:26;03 0:03;00	ISetEnabled		($img_typo_21_aus_eng)
	$ti+03:26;03 0:03;00	IAnimatePosition($img_typo_21_aus_eng, 50 x 200,50 x 200)
	$ti+03:26;03 2			IAnimateTransparency($img_typo_21_aus_eng, 1, 0.7)
							ISetInFront		($img_typo_21_aus_eng)

	$ti+03:26;10 0:02;18	ISetEnabled		($img_typo_21_geblasen_eng)
	$ti+03:26;10 0:02;18	IAnimatePosition($img_typo_21_geblasen_eng, 50 x 200,50 x 200)
	$ti+03:26;10 2			IAnimateTransparency($img_typo_21_geblasen_eng, 1, 0.7)
							ISetInFront		($img_typo_21_geblasen_eng)

	$ti+03:27;11 0:01;17	ISetEnabled		($img_typo_21_und_eng)
	$ti+03:27;11 0:01;17	IAnimatePosition($img_typo_21_und_eng, 50 x 200,50 x 200)
	$ti+03:27;11 2			IAnimateTransparency($img_typo_21_und_eng, 1, 0.7)
							ISetInFront		($img_typo_21_und_eng)

	$ti+03:27;18 0:01;10	ISetEnabled		($img_typo_21_erloschen_eng)
	$ti+03:27;18 0:01;10	IAnimatePosition($img_typo_21_erloschen_eng, 50 x 200,50 x 200)
	$ti+03:27;18 2			IAnimateTransparency($img_typo_21_erloschen_eng, 1, 0.7)
							ISetInFront		($img_typo_21_erloschen_eng)




}

#-------------------------------------------------------------------------------
# fur object / "Strukturen gnzlich neuer Art" 
# "wachsen hervor und treiben an" (3:30;15)
#                                            
# who: nero
#
# todo:
# - finetuning
#-------------------------------------------------------------------------------
timing_strukturen1[3:58;17,$_auto_,timing_v01] {
	#-drawText(&Strukturen)


	setNearFar(1, 8000)
	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)

	+0 	0.0	setStartTime($scene_cam_fx1, 32, 	0.1)

	updateScene($scene_cam_fx1)
	setEffectCamera($MTX_0)
	enableEffect($FX_FUROBJECT)

	### background ###
	ISetEnabled($img_strukturen)
	IAnimatePosition ($img_strukturen, 0,0, -0.125,-0.666666666666667)
	IAnimateSize ($img_strukturen, 1.28,1.28, 2.5,2.5)

	#animateFov(30,70)
	#animateFov(70,40)
	$_start_ .. animateFov(45,45)
	$ti+3:30;00 f12 animateFov(58,45)
	$ti+3:30;12 f12 animateFov(58,45)
	$ti+3:31;07 f12 animateFov(58,45)
	$ti+3:31;20 f12 animateFov(58,45)

	$ti+3:32;17 .. animateFov(100,100)
	$ti+3:33;03 .. animateFov(90,90)
	$ti+3:33;12 .. animateFov(80,80)
	$ti+3:33;19 .. animateFov(70,70)
 	$ti+3:34;01 .. animateFov(60,60)
	$ti+3:34;05 .. animateFov(50,50)
	$ti+3:34;10 .. $_end_ animateFov(30,30)

	enableGlow(3)
	animateZoomRot(0, 0,   0, 0)
	animateBias(0.0,0.4)
	animateGlow(0.6,0,3)
		
	animateFogColor(0.7,0.56,0.52, 0.21,0.22,0.08)
	animateFogNearFar(100, 50, 200, 150)
	enableFog()

	### typo german ###
	ISetEnabled($img_typo_14_strukturen_alpha_ger )
	+0 0.001	IAnimateTransparency($img_typo_14_strukturen_alpha_ger,  0,0)
	$ti+03:29;05 5	ISetInFront($img_typo_14_strukturen_alpha_ger )
	$ti+03:29;05 5	IAnimatePosition($img_typo_14_strukturen_alpha_ger,  20 x 163, 20 x 163)
	$ti+03:29;05 5	IAnimateTransparency($img_typo_14_strukturen_alpha_ger,  1,0.2)

	ISetEnabled($img_typo_14_gaenzlichneuera_alpha_ger )
	+0 0.0001	IAnimateTransparency($img_typo_14_gaenzlichneuera_alpha_ger,  0,0)
	$ti+03:30;05 5	ISetInFront($img_typo_14_gaenzlichneuera_alpha_ger )
	$ti+03:30;05 5	IAnimatePosition($img_typo_14_gaenzlichneuera_alpha_ger,  20 x 163, 20 x 163)
	$ti+03:29;05 5	IAnimateTransparency($img_typo_14_gaenzlichneuera_alpha_ger,  1,0.2)

	ISetEnabled($img_typo_15_wachsenhervor_alpha_ger )
	+0 0.001	IAnimateTransparency($img_typo_15_wachsenhervor_alpha_ger,  0,0)
	$ti+03:32;05 5	ISetInFront($img_typo_15_wachsenhervor_alpha_ger )
	$ti+03:32;05 5	IAnimatePosition($img_typo_15_wachsenhervor_alpha_ger,  310 x 423, 310 x 423)
	$ti+03:29;05 5	IAnimateTransparency($img_typo_15_wachsenhervor_alpha_ger,  1,0.2)


	### typo english ###
	ISetEnabled($img_typo_14_strukturen_alpha_eng )
	+0 0.001	IAnimateTransparency($img_typo_14_strukturen_alpha_eng,  0,0)
	$ti+03:29;05 5	ISetInFront($img_typo_14_strukturen_alpha_eng )
	$ti+03:29;05 5	IAnimatePosition($img_typo_14_strukturen_alpha_eng,  20 x 163, 20 x 163)
	$ti+03:29;05 5	IAnimateTransparency($img_typo_14_strukturen_alpha_eng,  1,0.2)

	ISetEnabled($img_typo_14_gaenzlichneuera_alpha_eng )
	+0 0.0001	IAnimateTransparency($img_typo_14_gaenzlichneuera_alpha_eng,  0,0)
	$ti+03:30;05 5	ISetInFront($img_typo_14_gaenzlichneuera_alpha_eng )
	$ti+03:30;05 5	IAnimatePosition($img_typo_14_gaenzlichneuera_alpha_eng,  20 x 163, 20 x 163)
	$ti+03:29;05 5	IAnimateTransparency($img_typo_14_gaenzlichneuera_alpha_eng,  1,0.2)

	ISetEnabled($img_typo_15_wachsenhervor_alpha_eng )
	+0 0.001	IAnimateTransparency($img_typo_15_wachsenhervor_alpha_eng,  0,0)
	$ti+03:32;05 5	ISetInFront($img_typo_15_wachsenhervor_alpha_eng )
	$ti+03:32;05 5	IAnimatePosition($img_typo_15_wachsenhervor_alpha_eng,  310 x 423, 310 x 423)
	$ti+03:29;05 5	IAnimateTransparency($img_typo_15_wachsenhervor_alpha_eng,  1,0.2)

}



#--- strophenende ---------------------------------------------------------------



#--------------------------------------------
# Rockneedle / "Statt Strudeln aufgewhlter See"
#  (zwischenschnitt bei 3:39;22)
#
# who: tom
#
# todo:
# - rough design
# - finetuning
#--------------------------------------------
timing_rockneedle[4:03;25,$_auto_,timing_v01] {
	#-drawText(&Der_Sturm_gebannt_Gewalten_ruhn)

	### camera animation ###
	setMatrixFromSceneCamera($MTX_0, $scene_rockneedle, &cam1)
	+0 0.0	setStartTime($scene_rockneedle, 0, 	1)
	#updateScene($scene_rockneedle_cam)


	### geometry ###
	displayScene($scene_rockneedle)
	#+0 0.0	setStartTime($scene_rock, 0, 	0)
	#setCamera($scene_rockneedle, $MTX_0)

	#displayScene($scene_cubeMap_blood_grey)
	displayScene($scene_skysphere_green)
	disableFogForScene($scene_skysphere_green)

	setEffectCamera($MTX_0)
    animateFov (90, 90)
 	setNearFar(1, 80000)

	## fog ###
	animateFogColor(%202020*1,  %202020*1)
	animateFogNearFar(0, 0, 1600, 1600)
	enableFog()

	### more light! ###
	+0 1 animateLightIntensity($scene_rockneedle, &Light_0, 100,3)
	#f5363 1 animateLightIntensity($scene_rock, &Light_0, 100,3)
	$ti+f5431 1 animateLightIntensity($scene_rockneedle, &Light_0, 1000,3)
	$ti+f5431 1 animateGlow(0.6, 0.4)

	$ti+f5496 1 animateLightIntensity($scene_rockneedle, &Light_0, 1000,3)
	$ti+f5496 1 animateGlow(0.8, 0.4)

    $ti+f5563 2 animateLightIntensity($scene_rockneedle, &Light_0, 1000,3)
	$ti+f5563 2 animateGlow(1, 0.4)

	### glow ###
	animateGlow(0.3, 0.4)
	enableGlow(1)

	enableEffect($FX_WATER)
	setWaterColor(%9BC7BE, %000410)

	### cache ###
	ISetEnabled($img_solid_black1)   #display container 0 (show image "bla2.jpg")
	ISetInFront($img_solid_black1)
    IAnimatePosition ($img_solid_black1, 0,0,0,0)
	IAnimateSize ($img_solid_black1, 800 x 100, 800 x 100)

	ISetEnabled($img_solid_black2)   #display container 0 (show image "bla2.jpg")
	ISetInFront($img_solid_black2)
	IAnimateSize ($img_solid_black2, 800 x 100, 800 x 100)
    IAnimatePosition ($img_solid_black2, 0 x 500, 0 x 500)


	### typo german ###
	$ti+03:37;24 0:07;05	ISetEnabled		($img_typo_22_dersturmgebannt_ger)
	$ti+03:37;24 0:07;05	IAnimatePosition($img_typo_22_dersturmgebannt_ger, 70 x 200,70 x 200)
	$ti+03:37;24 2			IAnimateTransparency($img_typo_22_dersturmgebannt_ger, 0, 1)
	$ti+03:37;24+6 1		IAnimateTransparency($img_typo_22_dersturmgebannt_ger, 1, 0)
							ISetInFront			($img_typo_22_dersturmgebannt_ger)

	$ti+03:42;14 0:02;15	ISetEnabled		($img_typo_22_gewaltenruhen_ger)
	$ti+03:42;14 0:02;15	IAnimatePosition($img_typo_22_gewaltenruhen_ger, 280 x 400,280 x 400)
	$ti+03:42;14 0.5			IAnimateTransparency($img_typo_22_gewaltenruhen_ger, 0, 1)
	$ti+03:42;14+2 0.5		IAnimateTransparency($img_typo_22_gewaltenruhen_ger, 1, 0)
							ISetInFront			($img_typo_22_gewaltenruhen_ger)
	### typo english ###
	$ti+03:37;24 0:07;05	ISetEnabled		($img_typo_22_dersturmgebannt_eng)
	$ti+03:37;24 0:07;05	IAnimatePosition($img_typo_22_dersturmgebannt_eng, 20 x 50,20 x 350)
	$ti+03:37;24 2			IAnimateTransparency($img_typo_22_dersturmgebannt_eng, 0, 1)
	$ti+03:37;24+6 1		IAnimateTransparency($img_typo_22_dersturmgebannt_eng, 1, 0)
							ISetInFront			($img_typo_22_dersturmgebannt_eng)

	$ti+03:42;14 0:02;15	ISetEnabled		($img_typo_22_gewaltenruhen_eng)
	$ti+03:42;14 0:02;15	IAnimatePosition($img_typo_22_gewaltenruhen_eng, 30 x 400,30 x 400)
	$ti+03:42;14 0.5			IAnimateTransparency($img_typo_22_gewaltenruhen_eng, 0, 1)
	$ti+03:42;14+2 0.5		IAnimateTransparency($img_typo_22_gewaltenruhen_eng, 1, 0)
							ISetInFront			($img_typo_22_gewaltenruhen_eng)
}




#-------------------------------------------------------------------------------
# neuronen / "Die Wirklichkeit, sie fuegt sich"
#  zwischenschnitt bei 3:50;17 und 3:56;02
#
# who: nero
#
# todo:
# - camera, finetuning
#-------------------------------------------------------------------------------
timing_neuronen[4:14;19, $_auto_,timing_v01] {
  ### dummytext ##
	#-drawText(&die_wirklichkeit)

	### set camera ##
	setNearFar(1, 80000)

	### scene neuronen1 ####
	setMatrixFromSceneCamera($MTX_0, $scene_neuronen_nero1, &cam1)
	 +0 0.0	setStartTime($scene_neuronen_nero1, 0, 	0.2)
	updateScene($scene_neuronen_nero1)

	animateCameraFov($scene_neuronen_nero1, 120, 70)
	setCamera($scene_neuronen_nero1, $MTX_0)
 	setEffectCamera($MTX_0)

	### scene neuronen1 ####
	setMatrixFromSceneCamera($MTX_2, $scene_neuronen_nero2, &cam1)
	 +0 0.0	setStartTime($scene_neuronen_nero2, 4, 	0.3)
	updateScene($scene_neuronen_nero2)

	animateCameraFov($scene_neuronen_nero2, 70, 150)
	setCamera($scene_neuronen_nero2, $MTX_2)

	### scene neuronen1 ####
	setMatrixFromSceneCamera($MTX_3, $scene_neuronen_nero1, &cam1)
	 +0 0.0	setStartTime($scene_neronen_sphere, 0, 	0.1)
	updateScene($scene_neronen_sphere)
	setCamera($scene_neronen_sphere, $MTX_3)
	displayScene($scene_neronen_sphere)


	animateLightIntensity($scene_neuronen_nero2,&Light_0,100,10)

	### display scene ##
	displayScene($scene_neuronen_nero1)
	displayScene($scene_neuronen_nero2)
	displayScene($scene_reactor_vc)

	### overlay sphere ###
	setMatrixFromSceneCamera($MTX_1, $scene_reactor2, &cam_reactor)
	+0 0.0	setStartTime($scene_reactor2, 10, 	1)
	+0 0.0 setStartTime($scene_sphere_neuronen_blend1, 0,1)
	updateScene($scene_reactor2   )
	setCamera($scene_sphere_neuronen_blend1, $MTX_1)
	displayScene($scene_sphere_neuronen_blend1)


	### fov ##
  	animateFov(40, 150)



	### musik:tusch ###
	$_start_    ..  animateScreenMultiply(%F62300, %F62300*1)
	4:20;02	..		animateScreenMultiply(%ffffff*2, %F62300*1)
	4:22;23 .. $_end_		animateScreenMultiply(%ffffff*2, %F62300*1)

	$_start_ .. 	animateFogColor(%B7D5D9*0.02,  %FF18B7*0.5)        # rot anlaufen
	4:20;02 .. 		animateFogColor(%B7D5D9*0.02,  %FF18B7*0.5)        # rot anlaufen
	4:22;23 $_end_ 		animateFogColor(%B7D5D9*0.02,  %FF18B7*0.5)        # rot anlaufen


	$_start_ .. 	animateGlow(0.8,0.8)
	4:20;02 ..   	animateGlow(0.9,0.8)
	4:21;02 ..   	animateGlow(0.8,0.8)
	4:22;23 $_end_  animateGlow(0.85,0.8)


	### transition ###
# 	-4 4 animateBias(0,0)
	#-6 6 animateGlow(0,0)
	-0.7 0.7 animateOverBlend(0, 0, 1)


	### set glow ##
	+0 $_len_ animateGlow(0.8,0.8)
	+0 $_len_ enableGlow(2)

	#+0 $_len_-2 animateGlow(0.95, 0.8)
	#-2 1 animateGlow(0.8, 0.1)

	#+0 $_len_-2 animateBias(0.4,0.5)

	#animateBias(1,1)
	#animateGlow(0.9,0.8)
	#animateZoomRot(0.3, 0.5, 0, 0) #nero
 	#animateZoomRot(0.99, 1.05, 1, 0)
	animateZoomRot(0.1, 0.1, 0, 0) #nero

	### anschlag musik ###
	#$ti+3:18;17 2 animateGlow(0.6,1)
	#$ti+3:50;17 2 animateGlow(1,0.6)
	#+0 $_len_-6 animateScreenMultiply(%ffffff*0.5,%F62300)
	#-6 6 animateScreenMultiply(%F62300*2,%F62300)

	### fog ###
	disableFogForScene($scene_cubeMap_neuronen_lightblue)  +10 5 animateFogColor(%ff009f*0.2,  %B7D5D9*0.02)
	animateFogNearFar(0, 100, 500, 150)
	enableFog()		#enable this for white background
	





	### typo german ###
	4:14;19 0:10;05		ISetEnabled		($img_typo_18_diewirklichkei_alpha_ger)
	4:14;19 0:10;05		IAnimatePosition($img_typo_18_diewirklichkei_alpha_ger, 10 x 439, 10 x 439)
	4:14;19 1			IAnimateTransparency($img_typo_18_diewirklichkei_alpha_ger, 0, 1)
	4:14;19+8 1			IAnimateTransparency($img_typo_18_diewirklichkei_alpha_ger, 1, 0)
						ISetInFront			($img_typo_18_diewirklichkei_alpha_ger)

	$ti+03:50;16 0:10;05	ISetEnabled		($img_typo_18_siefuegtsich_alpha_ger)
	$ti+03:50;16 0:10;05	IAnimatePosition($img_typo_18_siefuegtsich_alpha_ger, -20 x 439, -20 x 439)
	$ti+03:50;16 0.5	IAnimateTransparency($img_typo_18_siefuegtsich_alpha_ger, 0, 1)
	$ti+03:50;16 0:10;05	IAnimateTransparency($img_typo_18_siefuegtsich_alpha_ger, 1, 0.0)
							ISetInFront			($img_typo_18_siefuegtsich_alpha_ger)
	### typo english ###
	4:14;19 0:10;05		ISetEnabled		($img_typo_18_diewirklichkei_alpha_eng)
	4:14;19 0:10;05		IAnimatePosition($img_typo_18_diewirklichkei_alpha_eng, 10 x 439, 10 x 439)
	4:14;19 1			IAnimateTransparency($img_typo_18_diewirklichkei_alpha_eng, 0, 1)
	4:14;19+8 1			IAnimateTransparency($img_typo_18_diewirklichkei_alpha_eng, 1, 0)
						ISetInFront			($img_typo_18_diewirklichkei_alpha_eng)

	$ti+03:50;16 0:10;05	ISetEnabled		($img_typo_18_siefuegtsich_alpha_eng)
	$ti+03:50;16 0:10;05	IAnimatePosition($img_typo_18_siefuegtsich_alpha_eng, -25 x 439, -25 x 439)
	$ti+03:50;16 0.5	IAnimateTransparency($img_typo_18_siefuegtsich_alpha_eng, 0, 1)
	$ti+03:50;16 0:10;05	IAnimateTransparency($img_typo_18_siefuegtsich_alpha_eng, 1, 0.0)
							ISetInFront			($img_typo_18_siefuegtsich_alpha_eng)



}



#--------------------------------------------
# line sphere
# "Statt wirrer Linien Harmonie"
#
# who: nero
#
# todo:
# - camera, finetuning
#--------------------------------------------
timing_harmonie [4:30;17,$_auto_,timing_v01] {
	#-drawText(&Statt_wirrer_LinienHarmonie)

	animateBias(0,0)


   	#seltsam - dieses Licht sollte eigentlich garnicht zu sehen sein....
	animateLightIntensity($scene_reactor_vc, &Light_1, 2,10)


	+0 0 clearOldScreen()

	setNearFar(1, 8000)
	setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)
	+0 0.0 setStartTime($scene_cam_fx1, 5,	0.8)
	#+0 0.0	setTimeScale($scene_cam_fx1, 0.8)
	updateScene($scene_cam_fx1)
	setEffectCamera($MTX_0)

	### anschlag ###
#	4:14;23 1 animateBias(1,0.3)

	animateScreenMultiply(2,2,1, 2,1,2 )

	enableEffect($FX_LINESPHERE)
	#enableEffect($FX_CUBOMAT)
	#enableGlow(1)
	#+0 40 animateBias(0.1,0.1)
	#animateGlow(0.90, 0.90)

	#animateFogColor(1,1,1,  1,1,1)
    #animateFogNearFar(100, 100, 800, 800)
	#enableFog()

	displayScene($scene_cubeMap_neuronen_lightblue)
	disableFogForScene($scene_cubeMap_neuronen_lightblue)


	$_start_ .. 4:41;17 enableGlow(3)
	4:41;17 .. $_end_ enableGlow(2)

	4:41;17 .. $_end_ animateBias(0.0,1.0)
	4:41;17 .. $_end_ animateScreenMultiply(%ffffff*2,%ffffff)

	$_start_ .. 4:41;17 animateFov(90,160)
	4:41;17 .. $_end_ animateFov(160,160)

	$_start_ ..  animateGlow(0.8,0.99)
	4:41;12 .. $_end_ animateGlow(0.5,1)


	-1 1 ISetEnabled($img_solid_white)   #display container 0 (show image "bla2.jpg")
	-1 1 ISetInFront($img_solid_white)
	-1 1 IAnimateTransparency($img_solid_white, 0.0,0.5)
	IAnimateSize($img_solid_white, 800x600, 800x600)


	$_start_ .. 4:41;12 animateZoomRot(0.99,  1.05, 1, 0)
	#4:41;12 .. $_end_ animateZoomRot(0.99,  1.05, 1, 0)

	#-4 4 animateZoomRot(0.99, 1.05, 1, 0)

	### typo german ###
	$ti+4:01;03 0:08;12	ISetEnabled		($img_typo_24_stattwirrerlinien_ger)
	$ti+4:01;03 0:08;12	IAnimatePosition($img_typo_24_stattwirrerlinien_ger, 20 x 410, 20 x 410)
	$ti+4:01;03+4 4		IAnimateTransparency($img_typo_24_stattwirrerlinien_ger, 1, 0)
							ISetInFront			($img_typo_24_stattwirrerlinien_ger)

	$ti+4:02;13 0:08;13	ISetEnabled		($img_typo_24_harmonie_ger)
	$ti+4:02;13 0:08;13	IAnimatePosition($img_typo_24_harmonie_ger, 120 x 423, 120 x 423)
	$ti+4:02;13 1		IAnimateTransparency($img_typo_24_harmonie_ger, 0, 1)
	$ti+4:02;13+6 2		IAnimateTransparency($img_typo_24_harmonie_ger, 1, 0)
							ISetInFront			($img_typo_24_harmonie_ger)
	### typo english ###
	$ti+4:01;03 0:08;12	ISetEnabled		($img_typo_24_stattwirrerlinien_eng)
	$ti+4:01;03 0:08;12	IAnimatePosition($img_typo_24_stattwirrerlinien_eng, 20 x 410, 20 x 410)
	$ti+4:01;03+4 4		IAnimateTransparency($img_typo_24_stattwirrerlinien_eng, 1, 0)
							ISetInFront			($img_typo_24_stattwirrerlinien_eng)

	$ti+4:02;13 0:08;13	ISetEnabled		($img_typo_24_harmonie_eng)
	$ti+4:02;13 0:08;13	IAnimatePosition($img_typo_24_harmonie_eng, 277 x 426, 277 x 426)
	$ti+4:02;13 1		IAnimateTransparency($img_typo_24_harmonie_eng, 0, 1)
	$ti+4:02;13+6 2		IAnimateTransparency($img_typo_24_harmonie_eng, 1, 0)
							ISetInFront			($img_typo_24_harmonie_eng)

}


#-----------------------------------------------
# Schwarmeffekt / "Ins hier gehoben diese Schicht der Welt"
#
# who: pixtur
#
# todo:
# - camera, finetuning
# - mglichst weicher bergang in anschlieende Szene
# - start orig. 4:41;19
#------------------------------------------------
timing_schwarmeffekt[4:42;19, $_auto_, timing_finetune] {
	#-drawText(&Ins_hier_gehoben)

	+0 0 clearOldScreen()

	setNearFar(1, 8000)
	#setMatrixFromSceneCamera($MTX_0, $scene_cam_fx1, &cam_fx1)
	+0 0.0 setStartTime($scene_cam_fx1, 3,	0.8)    # orig: 3, 0.8

	animateFov(60,120)


	### set up schwarm-effect ###

	setMatrixFromScene($MTX_1, $scene_shaft_aimtarget, &aimTarget1)
	+0 0.0	setStartTime($scene_shaft_aimtarget, 0, 	1)
	updateScene($scene_shaft_aimtarget)

	setLookAtPoint($MTX_1)
	#enableEffect($FX_LIGHTRAYS)

	animateMaxDistance(700,7800)
	+0 1 animateScale(1,8)
	+2 $_len_-2 animateScale(6,18)

	updateScene($scene_cam_fx1)
	enableEffect($FX_SCHWARM)
	setEffectCamera($MTX_0)

	#displayScene($scene_cubeMap_neuronen_lightblue)
	#disableFogForScene($scene_cubeMap_neuronen_lightblue)
	#displayScene($scene_movingLights)

	setMatrixFromSceneCamera($MTX_0, $scene_shaft, &cam3)
	setCamera($scene_shaft,$MTX_0)
	displayScene($scene_shaft)
	+0 0 setStartTime($scene_shaft, 1,1)

	animateLightIntensity($scene_shaft, &Light_0, 0.2,2)

	enableGlow(2)
	#animateBias(0.0,1.0)
	animateGlow(0.6, 0.6)
	+0 1 animateGlow(1, 0.6)
	-2 2 animateGlow(0.6, 0.9)
	#+0 2 animateGlow(1,0.7)
	#-3 3 animateGlow(0.7,1)

	#animateZoomRot(0.99,  1.05, 1, 0)

	#animateScreenMultiply(%DDFAEB*1.4,%DDFAEB*1.4)

	animateFogColor(%ffffff,  %ffffff)
	animateFogNearFar(0, 0, 20000, 1000)
	enableFog()		#enable this for white background

 	### typo german
	$ti+4:12;04 0:05;14	ISetEnabled		($img_typo_25_inshiergehoben_ger)
	$ti+4:12;04 3		IAnimatePosition($img_typo_25_inshiergehoben_ger, 50 x 400, 70 x 400)
	$ti+4:12;04+4 1		IAnimateTransparency($img_typo_25_inshiergehoben_ger, 1, 0)
						ISetInFront			($img_typo_25_inshiergehoben_ger)

	$ti+4:15;02 0:03;04	ISetEnabled		($img_typo_25_dieseschicht_ger)
	$ti+4:15;02 0:03;04	IAnimatePosition($img_typo_25_dieseschicht_ger, 500 x 400, 500 x 400)
	$ti+4:15;02 0.5		IAnimateTransparency($img_typo_25_dieseschicht_ger, 0, 1)
	$ti+4:15;02+2.5 0.5	IAnimateTransparency($img_typo_25_dieseschicht_ger, 1, 0)
						ISetInFront			($img_typo_25_dieseschicht_ger)

 	### typo english
	$ti+4:12;04 0:07;14	ISetEnabled		($img_typo_25_inshiergehoben_eng)
	$ti+4:12;04 5		IAnimatePosition($img_typo_25_inshiergehoben_eng, 20 x 275, 70 x 275)
	$ti+4:12;04+6 1		IAnimateTransparency($img_typo_25_inshiergehoben_eng, 1, 0)
						ISetInFront			($img_typo_25_inshiergehoben_eng)

	$ti+4:15;02 0:07;04	ISetEnabled		($img_typo_25_dieseschicht_eng)
	$ti+4:15;02 0:07;04	IAnimatePosition($img_typo_25_dieseschicht_eng, 500 x 275, 500 x 275)
	$ti+4:15;02 0.5		IAnimateTransparency($img_typo_25_dieseschicht_eng, 0, 1)
	$ti+4:15;03+6.5 0.5	IAnimateTransparency($img_typo_25_dieseschicht_eng, 1, 0)
						ISetInFront			($img_typo_25_dieseschicht_eng)

}

#--------------------------------------------
# Pieces into light 
# "Ein inverser Drogenrausch hilft atmen"
# "Und einst verletzende Krebsdiamanten""
# "Weichen Kristallen klaren Glanzes"
#
# who: pixtur )4:22;02
#
# todo:
# - rough design
# - camera, finetuning
# - lyrics
#--------------------------------------------
timing_pieces [4:52;05,$_auto_,timing_finetune] {
	##-drawText(&Ein_inverser_Drogenrauschhilft_atmen)
	#04:11;24	6	#-drawText(&Und_einst_verletzende_Krebsdiamanten)
	#04:22:18	6	#-drawText(&Weichen_Kristenklaren_Glanzes)


	#+0 4 #-drawText(&introParttodo:-camerafahrt-colors-typo)
	#+5 4 #-drawText(&es_dreut_nicht_mehrdes_himmels_leere)

	### initscenes ###
	#setMatrixFromSceneCamera($MTX_0, $scene_intro_cam, &cam1)
	#+0 0.0	setStartTime($scene_intro_cam, 0, 	0.2)
	#updateScene($scene_intro_cam)
	#updateScene($scene_scattered_floor_cam)
	#setEffectCamera($MTX_0)
    #animateFov (100, 100)

	### aim rays to this point ###
	setMatrixFromScene($MTX_1, $scene_outro_aimtarget, &aimTarget1)
	+0 0.0	setStartTime($scene_outro_aimtarget, 0, 	1)
	updateScene($scene_outro_aimtarget)

	setLookAtPoint($MTX_1)
	enableEffect($FX_LIGHTRAYS)

	+0 1 animateLightIntensity($scene_outro, &Light_0, 100,2)
	+1 $_len_-3 animateLightIntensity($scene_outro, &Light_0, 2,6)
	-2 2 animateLightIntensity($scene_outro, &Light_0, 6,0)

	+0 4 animateMaxDistance(600,600)
	+0 4 animateScale(15,20)

	+4 3 animateMaxDistance(600,700)
	+4 3 animateScale(20,20)

	+7 3 animateMaxDistance(700,800)
	+7 4 animateScale(20,0)

	#displayScene($scene_outro_lightbox)
	#displayScene($scene_intro_lightEdge)
	#+0 0	setStartTime($scene_intro_lightEdge, 0, 	0.1)

	displayScene($scene_outro)
	setMatrixFromSceneCamera($MTX_0, $scene_outro, &cam2_outro)
	setCamera($scene_outro,$MTX_0)
	+0 $_len_ animateFov(140,61)
	+0 0 setStartTime($scene_outro,0,1)


	displayScene($scene_outro_sky)
	#disableFogForScene($scene_outro_sky)
	setCamera($scene_outro_sky,$MTX_0)

	#displayScene($scene_outro_lightbox)
	disableFogForScene($scene_outro_lightbox)

	#+30 6 animateMaxDistance(400,300)
	#+30 6 animateScale(3,22)

	### glow ###
	#animateGlow(0.9, 0.9)
	#enableGlow(3)

	#enableGlow(1)
	#+0 3 animateGlow(1, 0.3)
	#+52 1 animateGlow(0.3, 1)

	enableGlow(1)
	animateGlow(0.4, 0.4)
	+0 3 animateGlow(0.7, 0.4)
	-2 2 animateGlow(0.3, 0.6)

	### fog ####
	#animateFogColor(1, 1, 1,  1, 1, 1)
	animateFogColor(0, 0, 0,  1, 1, 1)
	animateFogColor(%a0a0a0,  %ffffff)
	+0 3 animateFogNearFar(300, 300, 1200, 16200)
	+3 $_len_-8 animateFogNearFar(300, 300, 16200, 1200)
	-5 5 animateFogNearFar(300, 2200, 1200, 3000)

	enableFog()		#enable this for white background


 	### typo german ###
	$ERRORS_TIMING=off
	$ti+4:18;20 0:11;03	ISetEnabled			($img_typo_26_ein_ger)
	$ti+4:18;20 0:11;03	IAnimatePosition	($img_typo_26_ein_ger, 0 x 400, 0 x 400)
	$ti+4:18;20 1		IAnimateTransparency($img_typo_26_ein_ger, 0, 1)
	$ti+4:18;20+2.5 0.5	IAnimateTransparency($img_typo_26_ein_ger, 1,0)
						ISetInFront			($img_typo_26_ein_ger)

	$ti+4:22;06 0:07;03	ISetEnabled			($img_typo_26_inverser_ger)
	$ti+4:22;06 0:07;03	IAnimatePosition	($img_typo_26_inverser_ger, 0 x 400, 0 x 400)
	$ti+4:22;06 0.5		IAnimateTransparency($img_typo_26_inverser_ger, 0, 1)
	$ti+4:22;06+2 0.5	IAnimateTransparency($img_typo_26_inverser_ger, 1,0)
						ISetInFront			($img_typo_26_inverser_ger)

	$ti+4:15;22 0:13;12	ISetEnabled			($img_typo_26_drogenrausch_ger)
	$ti+4:15;22 0:13;12	IAnimatePosition	($img_typo_26_drogenrausch_ger, 0 x 400, 0 x 400)
	$ti+4:15;22 3		IAnimateTransparency($img_typo_26_drogenrausch_ger, 0, 1)
	$ti+4:21;22 10		IAnimateTransparency($img_typo_26_drogenrausch_ger, 1,0)
						ISetInFront			($img_typo_26_drogenrausch_ger)

	$ti+4:22;16 0:06;18	ISetEnabled			($img_typo_26_hilft_ger)
	$ti+4:22;16 0:06;18	IAnimatePosition	($img_typo_26_hilft_ger, 0 x 400, 0 x 400)
	$ti+4:22;16 0.5		IAnimateTransparency($img_typo_26_hilft_ger, 0, 1)
	$ti+4:22;16+2 0.5	IAnimateTransparency($img_typo_26_hilft_ger, 1,0)
						ISetInFront			($img_typo_26_hilft_ger)
        
	$ti+4:22;16 0:14;16	ISetEnabled			($img_typo_26_atmen_ger)
	$ti+4:22;16 0:14;16	IAnimatePosition	($img_typo_26_atmen_ger, 0 x 400, 0 x 400)
	$ti+4:22;16 0.5		IAnimateTransparency($img_typo_26_atmen_ger, 0, 1)
	$ti+4:22;16+2 1		IAnimateTransparency($img_typo_26_atmen_ger, 1,0)
	$ti+4:22;16+3 1		IAnimateTransparency($img_typo_26_atmen_ger, 0,1)
	$ti+4:22;16+4 1		IAnimateTransparency($img_typo_26_atmen_ger, 1,0)
	$ti+4:22;16+5 1		IAnimateTransparency($img_typo_26_atmen_ger, 0,1)
	$ti+4:22;16+6 1		IAnimateTransparency($img_typo_26_atmen_ger, 1,0)
	$ti+4:22;16+7 1		IAnimateTransparency($img_typo_26_atmen_ger, 0,1)
	$ti+4:22;16+8 1		IAnimateTransparency($img_typo_26_atmen_ger, 1,0)
						ISetInFront			($img_typo_26_atmen_ger)

	$ti+4:33;14 0:06;04	ISetEnabled			($img_typo_27_und_ger)
	$ti+4:33;14 0:06;04	IAnimatePosition	($img_typo_27_und_ger, 0 x 500, 0 x 500)
	$ti+4:33;14 1.5		IAnimateTransparency($img_typo_27_und_ger, 0, 1)
	$ti+4:33;14+5 0.5	IAnimateTransparency($img_typo_27_und_ger, 1,0)
						ISetInFront			($img_typo_27_und_ger)

	$ti+4:35;15 0:06;06	ISetEnabled			($img_typo_27_krebsdiamanten_ger)
	$ti+4:35;15 0:06;06	IAnimatePosition	($img_typo_27_krebsdiamanten_ger, 30 x 520, 0 x 520)
	$ti+4:35;15 0.7		IAnimateTransparency($img_typo_27_krebsdiamanten_ger, 0, 1)
	$ti+4:35;15+4 2		IAnimateTransparency($img_typo_27_krebsdiamanten_ger, 1,0)
						ISetInFront			($img_typo_27_krebsdiamanten_ger)

#	$ti+4:39;04 0:05;08	ISetEnabled			($img_typo_27_krebsdiamanten)
#	$ti+4:39;04 0:05;08	IAnimatePosition	($img_typo_27_krebsdiamanten, 0 x 500, 0 x 500)
#	$ti+4:39;04 1		IAnimateTransparency($img_typo_27_krebsdiamanten, 0, 1)
#						ISetInFront			($img_typo_27_krebsdiamanten)

	$ti+4:39;04 0:05;08	ISetEnabled			($img_typo_28_weichen_ger)
	$ti+4:39;04 0:05;08	IAnimatePosition	($img_typo_28_weichen_ger, 0 x 400, 0 x 400)
	$ti+4:39;04 1		IAnimateTransparency($img_typo_28_weichen_ger, 0, 1)
	-2 2		IAnimateTransparency($img_typo_28_weichen_ger, 1, 0)

						ISetInFront			($img_typo_28_weichen_ger)

	$ti+4:41;11 0:03;01	ISetEnabled			($img_typo_28_klarenglanzes_ger)
	$ti+4:41;11 0:03;01	IAnimatePosition	($img_typo_28_klarenglanzes_ger, 40 x 450, 40 x 450)
	$ti+4:41;11 1		IAnimateTransparency($img_typo_28_klarenglanzes_ger, 0, 1)
	-2.5 2		IAnimateTransparency($img_typo_28_klarenglanzes_ger, 1, 0)

						ISetInFront			($img_typo_28_klarenglanzes_ger)



 	### typo english ###
	$ti+4:18;20 0:11;03	ISetEnabled			($img_typo_26_ein_eng)
	$ti+4:18;20 0:11;03	IAnimatePosition	($img_typo_26_ein_eng, 0 x 400, 0 x 400)
	$ti+4:18;20 1		IAnimateTransparency($img_typo_26_ein_eng, 0, 1)
	$ti+4:18;20+5.5 0.5	IAnimateTransparency($img_typo_26_ein_eng, 1,0)
	$ti+4:18;20 0:11;03	ISetInFront			($img_typo_26_ein_eng)

	$ti+4:22;06 0:07;03	ISetEnabled			($img_typo_26_inverser_eng)
	$ti+4:22;06 0:07;03	IAnimatePosition	($img_typo_26_inverser_eng, 0 x 400, 0 x 400)
	$ti+4:22;06 0.5		IAnimateTransparency($img_typo_26_inverser_eng, 0, 1)
	$ti+4:22;06+2 0.5	IAnimateTransparency($img_typo_26_inverser_eng, 1,0)
	$ti+4:22;06 0:07;03	ISetInFront			($img_typo_26_inverser_eng)

	$ti+4:17;22 0:23;12	ISetEnabled			($img_typo_26_drogenrausch_eng)
	$ti+4:17;22 0:23;12	IAnimatePosition	($img_typo_26_drogenrausch_eng, 0 x 400, 0 x 400)
	$ti+4:17;22 3		IAnimateTransparency($img_typo_26_drogenrausch_eng, 0, 1)
	$ti+4:21;22 5		IAnimateTransparency($img_typo_26_drogenrausch_eng, 1,0)
	$ti+4:17;22 0:23;12		ISetInFront			($img_typo_26_drogenrausch_eng)

	$ti+4:22;16 0:06;18	ISetEnabled			($img_typo_26_hilft_eng)
	$ti+4:22;16 0:06;18	IAnimatePosition	($img_typo_26_hilft_eng, 0 x 400, 0 x 400)
	$ti+4:22;16 0.5		IAnimateTransparency($img_typo_26_hilft_eng, 0, 1)
	$ti+4:22;16+2 0.5	IAnimateTransparency($img_typo_26_hilft_eng, 1,0)
	$ti+4:22;16 0:06;18		ISetInFront			($img_typo_26_hilft_eng)

	$ti+4:22;16 0:14;16	ISetEnabled			($img_typo_26_atmen_eng)
	$ti+4:22;16 0:14;16	IAnimatePosition	($img_typo_26_atmen_eng, 0 x 400, 0 x 400)
	$ti+4:22;16 0.5		IAnimateTransparency($img_typo_26_atmen_eng, 0, 1)
	$ti+4:22;16+2 1		IAnimateTransparency($img_typo_26_atmen_eng, 1,0)
	$ti+4:22;16+3 1		IAnimateTransparency($img_typo_26_atmen_eng, 0,1)
	$ti+4:22;16+4 1		IAnimateTransparency($img_typo_26_atmen_eng, 1,0)
	$ti+4:22;16+5 1		IAnimateTransparency($img_typo_26_atmen_eng, 0,1)
	$ti+4:22;16+6 1		IAnimateTransparency($img_typo_26_atmen_eng, 1,0)
	#$ti+4:22;16+7 1		IAnimateTransparency($img_typo_26_atmen_eng, 0,1)
	#$ti+4:22;16+8 1		IAnimateTransparency($img_typo_26_atmen_eng, 1,0)
	$ti+4:22;16 0:14;16	ISetInFront			($img_typo_26_atmen_eng)

	$ti+4:33;14 0:06;04	ISetEnabled			($img_typo_27_und_eng)
	$ti+4:33;14 0:06;04	IAnimatePosition	($img_typo_27_und_eng, 0 x 500, 0 x 500)
	$ti+4:33;14 1.5		IAnimateTransparency($img_typo_27_und_eng, 0, 1)
	$ti+4:33;14+5 0.5	IAnimateTransparency($img_typo_27_und_eng, 1,0)
						ISetInFront			($img_typo_27_und_eng)

	$ti+4:35;15 0:06;06	ISetEnabled			($img_typo_27_krebsdiamanten_eng)
	$ti+4:35;15 0:06;06	IAnimatePosition	($img_typo_27_krebsdiamanten_eng, 30 x 520, 0 x 520)
	$ti+4:35;15 0.7		IAnimateTransparency($img_typo_27_krebsdiamanten_eng, 0, 1)
	$ti+4:35;15+4 2		IAnimateTransparency($img_typo_27_krebsdiamanten_eng, 1,0)
						ISetInFront			($img_typo_27_krebsdiamanten_eng)

#	$ti+4:39;04 0:05;08	ISetEnabled			($img_typo_27_krebsdiamanten)
#	$ti+4:39;04 0:05;08	IAnimatePosition	($img_typo_27_krebsdiamanten, 0 x 500, 0 x 500)
#	$ti+4:39;04 1		IAnimateTransparency($img_typo_27_krebsdiamanten, 0, 1)
#						ISetInFront			($img_typo_27_krebsdiamanten)

	$ti+4:39;04 0:05;08	ISetEnabled			($img_typo_28_weichen_eng)
	$ti+4:39;04 0:05;08	IAnimatePosition	($img_typo_28_weichen_eng, 0 x 400, 0 x 400)
	$ti+4:39;04 1		IAnimateTransparency($img_typo_28_weichen_eng, 0, 1)
	-2 2		IAnimateTransparency($img_typo_28_weichen_eng, 1, 0)

						ISetInFront			($img_typo_28_weichen_eng)

	$ti+4:41;11 0:03;01	ISetEnabled			($img_typo_28_klarenglanzes_eng)
	$ti+4:41;11 0:03;01	IAnimatePosition	($img_typo_28_klarenglanzes_eng, 40 x 450, 40 x 450)
	$ti+4:41;11 1		IAnimateTransparency($img_typo_28_klarenglanzes_eng, 0, 1)
	-2.5 2		IAnimateTransparency($img_typo_28_klarenglanzes_eng, 1, 0)

						ISetInFront			($img_typo_28_klarenglanzes_eng)





	$ERRORS_TIMING=ON
}

#--------------------------------------------
# Credits
# - logos und credits werden nach und nach eingeblendet
# - camera fhrt langsam zurck
# toDo
# - logos
# - Wolken?
# who: pixtur / typo von Rainer
#--------------------------------------------
timing_credits [5:13;15,$_auto_,timing_finetune] {

	enableFog()

	### bk ##
	$ti+4:44;03 1 animateFogColor(0.1,0.1,0.1, 0,0,0)
	#4:44;03 3 #-drawText(&BK)

	ISetEnabled($img_end_bk)   #display container 0 (show image "bla2.jpg")
    IAnimatePosition ($img_end_bk, 0 x 0, 200 x 150)
	IAnimateSize ($img_end_bk, 800x600,400x300)
	+0 1 IAnimateTransparency ($img_end_bk,1,0.7)
	+1 6 IAnimateTransparency ($img_end_bk,0.7,0.2)
	+20 4 IAnimateTransparency ($img_end_bk,0.2,0.0)

	enableGlow(1)
	+0 1 animateGlow(1,0.1)

	#enableEffect($FX_PATTERN)

	### credits ###
	$ti+4:49;19 15	ISetEnabled			($img_typo_30_credits)
	#$ti+4:49;19 6	IAnimatePosition	($img_typo_30_credits, 0 x 280, 0 x 280)
	$ti+4:49;19 12	IAnimateTransparency($img_typo_30_credits, 1, 0)
	$ti+4:49;19 15	IAnimatePosition	($img_typo_30_credits, -100 x 390, 200 x 420)
	$ti+4:49;19 15 IAnimateSize	($img_typo_30_credits, 1000 x 64, 400 x 16)


					ISetInFront			($img_typo_30_credits)

	$ti+4:49;19-1 1 animateScreenMultiply(%ffffff*1,%ffffff*2)
	$ti+4:49;19 1 animateScreenMultiply(%ffffff*2,%ffffff)
	$ti+4:49;19 1 animateGlow(0.9,0.1)

	### back in heaven ###
	$ti+4:55;05 15	ISetEnabled			($img_typo_30_heaven)
	$ti+4:55;05 15	IAnimatePosition	($img_typo_30_heaven,  -200 x 390, 200 x 420)
	$ti+4:55;05 15 IAnimateSize	($img_typo_30_heaven, 1200 x 80, 400 x 16)


	$ti+4:55;05 12	IAnimateTransparency($img_typo_30_heaven, 1, 0)
					ISetInFront			($img_typo_30_heaven)

	$ti+4:55;05-1 1 animateScreenMultiply(%ffffff*1,%ffffff*2)
	$ti+4:55;05 1 animateScreenMultiply(%ffffff*2,%ffffff)
	$ti+4:55;05 1 animateGlow(0.9,0.1)

	### breakpoint ###
	$ti+5:00;12 15	ISetEnabled			($img_typo_30_breakpoint)
	$ti+5:00;12 15	IAnimateTransparency($img_typo_30_breakpoint, 1, 0)
					ISetInFront			($img_typo_30_breakpoint)
	$ti+5:00;12 15	IAnimatePosition	($img_typo_30_breakpoint,  -100 x 415, 200 x 445)
	$ti+5:00;12 15 IAnimateSize	($img_typo_30_breakpoint, 1000 x 63, 400 x 22)

	$ti+5:00;12-1 1 animateScreenMultiply(%ffffff*1,%ffffff*2)
	$ti+5:00;12 1 animateScreenMultiply(%ffffff*2,%ffffff)
	$ti+5:00;12 1 animateGlow(0.9,0.1)


6:00;00 60  ISetEnabled			($img_typo_30_esc)
6:00;00 2  	IAnimateTransparency($img_typo_30_esc,0, 1)
			ISetInFront			($img_typo_30_esc)
IAnimatePosition	($img_typo_30_esc,  0 x 550, 0 x 550)

#IAnimateSize	($img_typo_30_esc, 1000 x 83, 400 x 22)
-1 1 IAnimateTransparency($img_typo_30_esc,1, 0)


}


timing_quit [6:30;12, 1,timing_finetune] {



	+0 0 end()
}























