#include "main.h"

uint l_uiPlaneListID = 0;
uint l_uiGridListID = 0;
uint l_uiGridImage = 0;

float fDGYPos[1024];
float fDGSpd[1024];

void InitDisplayGrid(void)
{
    l_uiGridImage = LoadTGAFile("media/alpha.tga"); 
     
    l_uiPlaneListID = glGenLists(1);
    glNewList(l_uiPlaneListID, GL_COMPILE);
        glBegin(GL_QUADS);
            glNormal3f(0.0f, 1.0f, 0.0f);
            glTexCoord2f(0.0f, 0.0f);
            glVertex3f(0.0f, 0.0f, 0.0f);
            glTexCoord2f(1.0f, 0.0f);
            glVertex3f(80.0f, 0.0f, 0.0f);
            glTexCoord2f(1.0f, 1.0f);
            glVertex3f(80.0f, 0.0f, -80.0f);
            glTexCoord2f(0.0f, 1.0f);
            glVertex3f(0.0f, 0.0f, -80.0f);
        glEnd();
    glEndList(); 
     
    l_uiGridListID = glGenLists(1);
    glNewList(l_uiGridListID, GL_COMPILE);	            
        glBegin(GL_QUADS);       
            //Frontface
            glNormal3f(0.0f, 0.0f, 1.0f);
            glTexCoord2f(0.1f, 0.1f);
            glVertex3f(-1.0f, -1.0f, 0.25f);
            glTexCoord2f(0.9f, 0.1f);
            glVertex3f(1.0f, -1.0f, 0.25f);
            glTexCoord2f(0.9f, 0.9f);
            glVertex3f(1.0f, 1.0f, 0.25f);
            glTexCoord2f(0.1f, 0.9f);
            glVertex3f(-1.0f, 1.0f, 0.25f);
            
            //Leftface
            glNormal3f(-1.0f, 0.0f, 0.0f);
            glTexCoord2f(0.0f, 0.0f);
            glVertex3f(-1.25f, -1.25f, 0.0f);
            glTexCoord2f(0.1f, 0.1f);
            glVertex3f(-1.0f, -1.0f, 0.25f);
            glTexCoord2f(0.1f, 0.9f);
            glVertex3f(-1.0f, 1.0f, 0.25f);
            glTexCoord2f(0.0f, 1.0f);
            glVertex3f(-1.25f, 1.25f, 0.0f);
        
            //Rightface
            glNormal3f(1.0f, 0.0f, 0.0f);
            glTexCoord2f(0.9f, 0.1f);
            glVertex3f(1.0f, -1.0f, 0.25f);
            glTexCoord2f(1.0f, 0.0f);
            glVertex3f(1.25f, -1.25f, 0.0f);
            glTexCoord2f(1.0f, 1.0f);
            glVertex3f(1.25f, 1.25f, 0.0f);
            glTexCoord2f(0.9f, 0.9f);
            glVertex3f(1.0f, 1.0f, 0.25f);
    
            //Topface
            glNormal3f(0.0f, 1.0f, 0.0f);
            glTexCoord2f(0.1f, 0.9f);
            glVertex3f(-1.0f, 1.0f, 0.25f);
            glTexCoord2f(0.9f, 0.9f);
            glVertex3f(1.0f, 1.0f, 0.25f);
            glTexCoord2f(1.0f, 1.0f);
            glVertex3f(1.25f, 1.25f, 0.0f);
            glTexCoord2f(0.0f, 1.0f);
            glVertex3f(-1.25f, 1.25f, 0.0f);
    
            //Bottomface
            glNormal3f(0.0f, -1.0f, 0.0f);
            glTexCoord2f(0.0f, 0.0f);
            glVertex3f(-1.25f, -1.25f, 0.0f);
            glTexCoord2f(1.0f, 0.0f);
            glVertex3f(1.25f, -1.25f, 0.0f);
            glTexCoord2f(0.9f, 0.1f);
            glVertex3f(1.0f, -1.0f, 0.25f);
            glTexCoord2f(0.1f, 0.1f);
            glVertex3f(-1.0f, -1.0f, 0.25f);
        glEnd();
    glEndList();
    
    for(int t = 0; t < 1024; ++t)
    {
        fDGYPos[t] = 0.0f;
        fDGSpd[t] = 0.0f;
    }
}

void DrawDisplayGrid(void)
{
    glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);

    glBindTexture(GL_TEXTURE_2D, l_uiGridImage);

    glCallList(l_uiPlaneListID);

    int iNum = 0;
    for(int z = 0; z < 32; ++z)
    {
        for(int x = 0; x < 32; ++x)
        {                          
            glPushMatrix();
            
            if(fDGSpd[iNum] != 0.0f) fDGSpd[iNum] -= 4.0f * g_fTimeMod;
            fDGYPos[iNum] += fDGSpd[iNum] * g_fTimeMod;            
            if(fDGYPos[iNum] < 0.0f && fDGSpd[iNum] > -0.1)
            {
                fDGYPos[iNum] = 0.0f;
                fDGSpd[iNum] = 0.0f;
            }
            else if(fDGYPos[iNum] < 0.0f && fDGSpd[iNum] < 0.0f)
                fDGSpd[iNum] = -fDGSpd[iNum] / 2.0f;
            else if(fDGSpd[iNum] == 0.0f)
                fDGSpd[iNum] = -0.01f;
            
            glTranslatef(x * 2.55f, fDGYPos[iNum], -z * 2.55f);

            glRotatef(90.0f, -1.0f, 0.0f, 0.0f);
            glCallList(l_uiGridListID);
        
            glPopMatrix();
            ++iNum;
        } 
    }

    glBindTexture(GL_TEXTURE_2D, 0);

	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
    glDisable(GL_LIGHTING);
}

void DisplayGridOnSound(void)
{
    for(int t = 0; t < 4; ++t)
    { 
        int iNum = rand() % 1023; 
        while(fDGYPos[iNum] > 0.0f)
        {
            iNum = rand() % 1023; 
        } 
        fDGSpd[iNum] = 4.0f;
    }
}
