varying vec3 normal;
//varying vec4 color;

#vertexshader

const int NUMBONES = 8;
uniform mat4 Bones[NUMBONES];
uniform mat4 JointNormals[NUMBONES];

attribute vec4 PosWeight0;
attribute vec4 PosWeight1;
attribute vec4 PosWeight2;
attribute vec4 PosWeight3;

attribute vec4 Joints;
attribute vec4 Normal;

void main()
{
	vec4 Pos0 = vec4(PosWeight0.xyz, 1.0);
	vec4 Pos1 = vec4(PosWeight1.xyz, 1.0);
	vec4 Pos2 = vec4(PosWeight2.xyz, 1.0);
	vec4 Pos3 = vec4(PosWeight3.xyz, 1.0);

	int i0 = int(Joints.x);
	int i1 = int(Joints.y);
	int i2 = int(Joints.z);
	int i3 = int(Joints.w);

	vec4 Pos = (Bones[i0] * Pos0) * PosWeight0.w;
	Pos += (Bones[i1] * Pos1) * PosWeight1.w;
	Pos += (Bones[i2] * Pos2) * PosWeight2.w;
	Pos += (Bones[i3] * Pos3) * PosWeight3.w;

	vec4 Norm = (JointNormals[i0] * Normal) * PosWeight0.w;
	Norm += (JointNormals[i1] * Normal) * PosWeight1.w;
	Norm += (JointNormals[i2] * Normal) * PosWeight2.w;
	Norm += (JointNormals[i3] * Normal) * PosWeight3.w;

	gl_Position = gl_ModelViewProjectionMatrix * Pos;
	normal = normalize(Norm.xyz);
}

#fragmentshader

uniform samplerCube Texture0;


void main()
{

	vec3 lightdir = normalize(vec3(-1.0,-1.0, 0.0));
//	vec3 color = vec3(0.15, 0.25, 0.4);
	vec4 color = textureCube(Texture0, normal); //vec3(0.15, 0.25, 0.4);
	vec3 c = dot(lightdir, normal) * color.xyz;
	gl_FragColor = vec4(c*0.95+vec3(0.05,0.05,0.05),1);

//	vec3 lightdir = normalize(vec3(1.0,1.0,1.0));
//	gl_FragColor = vec4((normal.xyz+vec3(1.0,1.0,1.0))*vec3(0.5,0.5,0.5),1.0);
}
