/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.Util3D;
import com.mascotcapsule.micro3d.v3.Vector3D;

public class Light {
    private Vector3D myDirVector;
    private int myDirIntensity;
    private int myAmbIntensity;

    private static native void initializeClass0();

    public Light() {
        this.myDirVector = new Vector3D(0, 0, 4096);
        this.myDirIntensity = 4096;
        this.myAmbIntensity = 0;
    }

    public Light(Vector3D dir, int dirIntensity, int ambIntensity) {
        if (dir == null) {
            throw Util3D.npe;
        }
        this.myDirVector = dir;
        this.myDirIntensity = dirIntensity;
        this.myAmbIntensity = ambIntensity;
    }

    public final int getDirIntensity() {
        return this.getParallelLightIntensity();
    }

    public final int getParallelLightIntensity() {
        return this.myDirIntensity;
    }

    public final void setDirIntensity(int p) {
        this.setParallelLightIntensity(p);
    }

    public final void setParallelLightIntensity(int p) {
        this.myDirIntensity = p;
    }

    public final int getAmbIntensity() {
        return this.getAmbientIntensity();
    }

    public final int getAmbientIntensity() {
        return this.myAmbIntensity;
    }

    public final void setAmbIntensity(int p) {
        this.setAmbientIntensity(p);
    }

    public final void setAmbientIntensity(int p) {
        this.myAmbIntensity = p;
    }

    public final Vector3D getDirection() {
        return this.getParallelLightDirection();
    }

    public final Vector3D getParallelLightDirection() {
        return this.myDirVector;
    }

    public final void setDirection(Vector3D v) {
        this.setParallelLightDirection(v);
    }

    public final void setParallelLightDirection(Vector3D v) {
        if (v == null) {
            throw Util3D.npe;
        }
        this.myDirVector = v;
    }

    static {
        Light.initializeClass0();
    }
}

