--
-- Gameplay modes; different things to do in the field
--

-- Sets the current play mode
function set_playmode( mode )
	if mode == nil then mode = mode_normal end
	if mode == cur_mode then return end

	if cur_mode ~= nil then cur_mode:deinit() end
	cur_mode = mode
	if cur_mode ~= nil then cur_mode:init() end
end

-------------------------------

-- Template empty mode
empty_mode =
{
	new_player = function( this ) end;
	init = function( this ) end;
	deinit = function( this ) end;
	update = function( this, time_step ) end;

	bouncer_hit = function( this ) end;
	switch_hit = function( this ) end;
	crate_hit = function( this ) end;
	red_button_hit = function( this ) end;
	wheel_click = function( this ) end;
	hazard_hit = function( this ) end;
	factory_hit = function( this ) end;
	rollpad_hit = function( this ) end;

	flame_done = function( this ) end;
	rollpad_done = function( this ) end;
	switch_lights_done = function( this ) end;
	hazard_done = function( this ) end;
	factory_done = function( this ) end;
	accident_done = function( this ) end;
}

-- Normal play mode
mode_normal = table.join( empty_mode,
	{
	new_player =
		function( this )
			-- If inherited, do not run this
			if this ~= mode_normal then return end

			this.red_left = 10
		end;

	crate_hit =
		function( this )
			HudScrollText( "Crate shot!!", 200 )
		end;

	red_button_hit =
		function( this )
			-- If inherited, run the normal modes button hit
			if this ~= mode_normal then
				mode_normal:red_button_hit()
				return
			end

			this.red_left = this.red_left - 1
			if this.red_left <= 0 then
				this.red_left = 10
				plr.score = plr.score + 200000

				if table.size(balls) < 2 then
					SoundPlay( "11_puhe_multiball.wav" )
					HudScrollText( "Multiball!", 50 )
					plr.multiballs = 1
					plr.multiball_time = 4
				end
			else
				HudScrollText( this.red_left .. " more..", 200 )
			end
		end;

	flame_done =
		function( this )
			if cur_mode == mode_normal then
				HudShowText( "Crate bonus active", 2, 0.08 )
				set_playmode( mode_cratebonus )
			end
		end;

	rollpad_done =
		function( this )
			HudShowText( "Rolling bonus", 1, 0.08 )
		end;

	switch_lights_done =
		function( this )
			if cur_mode == mode_normal then
				scene_wheel_accel = 0.0
				set_playmode( mode_rotatewheels )
			end
		end;

	hazard_done =
		function( this )
			SoundPlay( "10_puhe_hazard.wav" )
			HudScrollText( "** HAZARD **", 40, 0.35 )

			-- Give a new accident letter
			update_accident_letters( 1 )
		end;

	factory_done =
		function( this )
			SoundPlay( "08_puhe_factory.wav" )
			HudScrollText( "** FACTORY **", 40, 0.35 )

			-- Give a new accident letter
			update_accident_letters( 1 )
		end;

	accident_done =
		function( this )
			SoundPlay( "09_puhe_accident.wav" )
			set_playmode( mode_collect_triggers )
		end;
	} )

-- Crate bonus mode
mode_cratebonus = table.join( mode_normal,
	{
	init =
		function( this )
			this.crate_left = 15
			this.time_left = 120
			this.blink = 0
		end;

	deinit =
		function( this )
			objs_set_lit( arrow_objs, false )
		end;

	update =
		function( this, time_step )
			HudShowText( "Hit " .. this.crate_left .. " crates (" .. int(this.time_left) .. ")", 1 )
			this.time_left = this.time_left - time_step
			if this.time_left <= 0 then
				HudScrollText( "Too bad..", 75 )
				set_playmode( mode_normal )
				return
			end

			-- Arrow blinking
			this.blink = this.blink + time_step
			if this.blink > 0.4 then this.blink = this.blink - 0.4 end
			objs_set_lit( arrow_objs, this.blink >= 0.2 )
		end;

	crate_hit =
		function( this )
			this.crate_left = this.crate_left - 1
			if this.crate_left <= 0 then
				local bonus = int( 200000 + this.time_left * 5000 )
				HudScrollText( "!!JACKPOT!! Bonus: " .. bonus, 55, 0.33 )
				plr.score = plr.score + bonus
				set_playmode( mode_normal )
			end
		end;

	flame_done = function( this ) end;
	} )

-- Rotate wheels game mode
mode_rotatewheels = table.join( mode_normal,
	{
	init =
		function( this )
			this.clicks_left = 225
			this.time_left = 120
		end;

	deinit =
		function( this )
			objs_set_lit( arrow_objs, false )
		end;

	update =
		function( this, time_step )
			HudShowText( "Rotate " .. this.clicks_left .. " clicks (" .. int(this.time_left) .. ")", 1 )
			this.time_left = this.time_left - time_step
			if this.time_left <= 0 then
				HudScrollText( "Too bad..", 75 )
				set_playmode( mode_normal )
				return
			end
		end;

	switch_hit =
		function( this )
			scene_wheel_accel = 0.0
		end;

	wheel_click =
		function( this )
			this.clicks_left = this.clicks_left - 1
			if this.clicks_left <= 0 then
				plr.score = plr.score + 100000
				plr.extra_balls = plr.extra_balls + 1
				HudShowText( "EXTRA BALL!!", 2, 0.234 )
				set_playmode( mode_normal )
			end
		end;

	switch_lights_done = function( this ) end;
	} )

-- Collect the trigger -mode
mode_collect_triggers = table.join( mode_normal,
	{
	init =
		function( this )
			this.triggers = 0
			this.time_left = 120
		end;

	update =
		function( this, time_step )
			HudShowText( "Hit triggers: " .. this.triggers .. " (" .. int(this.time_left) .. ")", 1 )
			this.time_left = this.time_left - time_step
			if this.time_left <= 0 then
				local bonus = this.triggers * 1500
				HudScrollText( "Accident bonus: " .. bonus, 150 )
				plr.score = plr.score + bonus
				set_playmode( mode_normal )
			end
		end;

	bouncer_hit =
		function( this )
			this.triggers = this.triggers + 1
			mode_normal:bouncer_hit( mode_normal )
		end;

	switch_hit =
		function( this )
			this.triggers = this.triggers + 1
			mode_normal:switch_hit( mode_normal )
		end;

	crate_hit =
		function( this )
			this.triggers = this.triggers + 1
			mode_normal:crate_hit( mode_normal )
		end;

	red_button_hit =
		function( this )
			this.triggers = this.triggers + 1
			mode_normal:red_button_hit( mode_normal )
		end;

	wheel_click =
		function( this )
			this.triggers = this.triggers + 1
			mode_normal:wheel_click( mode_normal )
		end;

	hazard_hit =
		function( this )
			this.triggers = this.triggers + 1
			mode_normal:hazard_hit( mode_normal )
		end;

	factory_hit =
		function( this )
			this.triggers = this.triggers + 1
			mode_normal:factory_hit( mode_normal )
		end;

	rollpad_hit =
		function( this )
			this.triggers = this.triggers + 1
			mode_normal:rollpad_hit( mode_normal )
		end;
	} )

-- All the playmodes
all_modes =
{
	mode_normal,
	mode_cratebonus,
	mode_rotatewheels,
	mode_collect_triggers,
}

-- Set the current default mode
set_playmode( mode_normal )
