

//#include <windows.h>


//3d engine 

#include "defines.h"
#include "samples.h"
#include "general.h"
#include "camera.h"

#include "timer.h"
#include "texture.h"

#include "PlayBoard.h"
#include "PlayBrick.h"
#include "baseGraphObj.h"
#include "menuSystem.h"
#include "CPlayBrick_0.h"
#include "globals.h"
#include "CTileFile.h"
#include "CText.h"
#include "hud_base.h"
#include "CHudTetris.h"
#include <iostream>
#include "mp3Song.h"
#include <math.h>
#include <gl/glut.h> //3d basic includes..

unsigned short int heightOfBoard = 21;
unsigned short int widthOfBoard = 14;
const unsigned short int rotationCenter = 1;
const unsigned short int wallBlock = 7;
const unsigned short int deadBlock1 = 1;
const unsigned short int deadBlock2 = 2;
const unsigned short int deadBlock3 = 3;
const unsigned short int block0Color = 4;
const unsigned short int block1Color = 5;
const unsigned short int block2Color = 6;
const unsigned short int block3Color = 4;
const unsigned short int block4Color = 5;
const unsigned short int block5Color = 6;
const unsigned short int block6Color = 4;

unsigned int currentState=mainMenu_Run;
int gPoints=0;

CMainMenu mainMenu;
CPlayBoard playBoard;
CLockFps fpsLocker(60);
CText OText(14,14);
CText BText(30,30);
CHudBase *tetrisHud;



void init();
void gameLoop();
void reshape(int w,int h);
void endGame();
void enterScore(int i);
void showHighScore();
void credits();


int main(int argc,char **argv)
{
//initialze glut.. :)
	glutInit(&argc,argv);
	glutInitDisplayMode(GLUT_DOUBLE|GLUT_RGB|GLUT_DEPTH);
	glutInitWindowSize(xRes,yRes);
	glutInitWindowPosition(0,0);
	glutCreateWindow("Super unsexy tetris");
	glutFullScreen();
	glutSetCursor(GLUT_CURSOR_NONE);
	init(); //init function....
	glutDisplayFunc(gameLoop);
	glutReshapeFunc(reshape);
	glutIdleFunc(gameLoop);
	glutMainLoop();
   return 0;
}
void init()
{
	genSinCosTanTable();
	/*glClearColor(0.0,0.0,0.0,0.0);
	glShadeModel(GL_SMOOTH);
	glEnable(GL_NORMALIZE);
	glEnable(GL_DEPTH_TEST);*/
	GLfloat mat_diff[]={1.0,1.0,1.0,1.0};
	GLfloat mat_spec[]={1.0,1.0,1.0,1.0};
	GLfloat light_position[] = {0.0,1.0,1.0,1.0};
	GLfloat white_light[] = {1.0,1.0,1.0,0.0};
	GLfloat lmodel_ambient[] ={0.0,0.0,0.0,1.0};
	glShadeModel(GL_SMOOTH);
	glEnable(GL_NORMALIZE);
	glMaterialfv(GL_FRONT,GL_SPECULAR,mat_spec);
	glMaterialf(GL_FRONT,GL_SHININESS,50);
	glMaterialfv(GL_FRONT,GL_DIFFUSE,mat_diff);
	glLightfv(GL_LIGHT0,GL_POSITION,light_position);
	glLightfv(GL_LIGHT0,GL_DIFFUSE,white_light);
	glLightfv(GL_LIGHT0,GL_SPECULAR,white_light);
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT,lmodel_ambient);
	

	glEnable(GL_LIGHTING);
glEnable(GL_LIGHT0);
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_CULL_FACE);
	
	
	
		glEnable(GL_CULL_FACE);
		currentState=5; //just in case.. :p
		mainMenu.graphRep.setTexture("menu3.jpg",JPG);
		mainMenu.graphRep.setTexture2("chrome.jpg",JPG);
		
Cmp3Song mp3("sundowner.mp3",255);		
	//	mp3.playMp3();
		//mp3.fadeMp3(30,255);
		OText.init();
		BText.init();
		tetrisHud = new CHudTetris;
		tetrisHud->init();
		tetrisHud->setTga("hud.tga");

		fHighScore.open("data.dat",ios::in|ios::binary|ios::nocreate);
		if(fHighScore.fail())
		{//creating default table entry..
			fHighScore.close();
			ofstream oFile;
			oFile.open("data.dat",ios::binary);
			if(oFile.fail())
			{
				std::cout<<"Error making new data file..!!\n";
				exit(0);
			}
			strcpy(highScore[0].name,"Code By vamecum");
			highScore[0].point=500;

			strcpy(highScore[1].name,"gfx by mckack  ");
			highScore[1].point=500;

			strcpy(highScore[2].name,"snds by intact");
			highScore[2].point=500;

			strcpy(highScore[3].name,"cherrox, vamecum");
			highScore[3].point=500;

			strcpy(highScore[4].name,"this game beats");
			highScore[4].point=400;

			strcpy(highScore[5].name,"your saturday  ");
			highScore[5].point=400;

			strcpy(highScore[6].name,"moviestar by a ");
			highScore[6].point=400;

			strcpy(highScore[7].name,"   longshoot   ");
			highScore[7].point=400;

			strcpy(highScore[8].name,"aaaaaaaaaaaaaaa");
			highScore[8].point=400;

			strcpy(highScore[9].name,"yeah           ");
			highScore[9].point=100; 

			oFile.write((unsigned char*)highScore,sizeof(ShighScore)*10);
			oFile.close();
		}

		fHighScore.read((unsigned char*)highScore,sizeof(ShighScore)*10);

		
		fHighScore.close();

			
		
		
		

	
}


void reshape(int w,int h)
{
	glViewport(0,0,(GLsizei)w,(GLsizei)h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(65.0,1.0,1.5,2000.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(0.0,0.0,-10.0);
	
	
}

void gameLoop()
{
	


	
	static int var=0;
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	//Let's see the gameLoop, First fire up the main menu....
	switch (currentState)
	{
	
	
	case mainMenu_NewGame:
		//Fun new game!! :D
		playBoard.selectGameMode(0);
		
	while(playBoard.live());
			currentState=mainMenu_Run;
			endGame();
			
		break;
	case mainMenu_HighScore:
		showHighScore();
		currentState=mainMenu_Run;
		break;
	case mainMenu_Credits:
		credits();
		currentState=mainMenu_Run;
		break;
	
	case mainMenu_Quit:
		exit(0);
		break;
	case mainMenu_Run:
		currentState= mainMenu.keyHandler();
		mainMenu.graphRep.renderIt();
		
		break;

	
	}
	

	
	var++;
	
glutSwapBuffers();
	while(fpsLocker.lockFps());
}

void showHighScore()
{
	while(!(KEYDOWN(VK_SPACE)))
	{
glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glDepthMask(GL_TRUE);
	BText.printText("HighScore",(40*5)-20,0);

	for (int i =0; i<10; i++)
	{
		OText.printNumber(i+1,0,(i+4)*12+10);
		OText.printText(highScore[i].name,25,(i+4)*12+10);
		OText.printNumber(highScore[i].point,xRes-100,(i+4)*12+10);
	}
	OText.printText("Press space to exit",0,yRes/2);

	glutSwapBuffers();
	}
	
}


void endGame()
{


	//fHighScore.open("data.dat",ios::binary|ios::out|ios::nocreate);
	
	
for(int i=0; i<10;i++)
{
	if(highScore[i].point<gPoints)
	{
		enterScore(i);
		return ;
	}
}

	while(!(KEYDOWN(VK_SPACE)))
	{
glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glDepthMask(GL_TRUE);
	OText.printText("GAME OVER",0,0);
	OText.printText("Your score",0,0+12);
	OText.printNumber(gPoints,12*13,0+12);
	OText.printText("Press Space",0,0+12*2);
	BText.printText("Better Luck next time",0,yRes/2);

	glutSwapBuffers();
	}
	

}

void enterScore(int i)
{
	static unsigned int lastTime = GetTickCount();
	static float a=0;
	static int b=0;
	static int x=0;
	char temp[16]="a              ";
	char temp2[2]="a";
	
		while(true)
		{
			glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glDepthMask(GL_TRUE);
	glColor3f(1,1,1);
	BText.printText("Congrats",(40*5)-20,0);
	BText.printText("You scored",0,60);
	BText.printNumber(gPoints,40*12,60);
	BText.printText("Write your name",0,(yRes/2)-24*5);
	BText.printText(temp,0,(yRes/2)-24);
	glColor3f(sin(a),tan(a),cos(a));
	BText.printText(temp2,x,(yRes/2)-24);
	glutSwapBuffers();
	a+=0.1;

	if(KEYDOWN(VK_RETURN))
		if(GetTickCount() - lastTime >= 133)
		{
			ofstream oFile;
			for(int c=9; c>=i;c--)
			{
				strcpy(highScore[c].name,highScore[c-1].name);
				highScore[c]=highScore[c-1];
			}

			strcpy(highScore[i].name,temp);
			highScore[i].point=gPoints;
			lastTime=GetTickCount();
			glColor3f(1,1,1);
			oFile.open("data.dat",ios::out|ios::binary);
			oFile.write((unsigned char*)highScore,sizeof(ShighScore)*10);
			oFile.close();
			Sleep(500);
			return;
		}
		if(KEYDOWN(VK_LEFT))
		if(GetTickCount() - lastTime >= 133)
		{
			if (b!=0||b>0)
			{
				b--;
				temp2[0]=temp[b];
				x-=30;
			}
			if((temp[b]<'a')||(temp[b]>'z'+1))
			{
				temp[b]='a';
			    temp2[0]=temp[b];
				//x-=30;
			}
			lastTime=GetTickCount();
		}
		
		if(KEYDOWN(VK_RIGHT))
		if(GetTickCount() - lastTime >= 133)
		{
			if (b!=14||b<14)
			{
				b++;
				temp2[0]=temp[b];
				x+=30;
			}
			if((temp[b]<'a')||(temp[b]>'z'+1))
			{
				temp[b]='a';
			temp2[0]=temp[b];
			//x+=30;
			}
			lastTime=GetTickCount();
		}
		
		if(KEYDOWN(VK_DOWN))
		if(GetTickCount()-lastTime>=133)
		{
			if(temp[b]<='a')
			{
				temp[b]='z'+1;
				temp2[0]='z'+1;
			}
			else
			{
				temp[b]--;
				temp2[0]--;
			}
			lastTime=GetTickCount();
		}
		if(KEYDOWN(VK_UP))
		if(GetTickCount()-lastTime>=133)
		{
			if(temp[b]>='z'+1)
			{
				temp[b]='a';
				temp2[0]='a';
			}
			else
			{
				temp[b]++;
				temp2[0]++;
			}
			lastTime=GetTickCount();
		}
			

		
		
		
	}
	
glColor3f(1,1,1);
}

void credits()
{
	while(!(KEYDOWN(VK_SPACE)))
	{
glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glLoadIdentity();
	glDisable(GL_LIGHTING);
	glDisable(GL_CULL_FACE);
	glDepthMask(GL_TRUE);
	BText.printText("CREDITSSS",(40*5)-20,0);

	OText.printText("Program     Licking Bricks",0,2*40);
	OText.printText("Made by The gin and tonic foundation",0,3*40);
	OText.printText("Rushed to acceptable function in    ",0,4*40);
	OText.printText("one night. totaly insane            ",0,5*40);
	OText.printText("Code by King Foo                    ",0,7*40);
	OText.printText("design and textures by McKack       ",0,8*40);
	OText.printText("real sounds will be manufacterd by  ",0,9*40);
	OText.printText("Intact and cherrox                  ",0,10*40);
	OText.printText("Take care, press space              ",0,11*40);

	


	
	glutSwapBuffers();
	}
}
