// -----------------------------------------------------------------------------
// SDK For Attax Game
//
// -----------------------------------------------------------------------------
// Originally created on 23/01/2004 by Mickey & Sceez / Melting Pot
//
// Header created with skelgen v1.2 by Paul Nettle (http://www.fluidstudios.com/)
// -----------------------------------------------------------------------------

#ifndef ATTAX_H
#define ATTAX_H

#ifdef WIN32
#include <windows.h>
#endif
// -----------------------------------------------------------------------------

#define SDK_VERSION 0.3
#define SDK_VERSION_STRING "0.3"

class Move
{
public:
	Move() {};
	virtual ~Move() {};
};

class AttacksMove : public Move
{
public:
	typedef enum { 
		A1, B1, C1, D1, E1, F1, G1,
		A2, B2, C2, D2, E2, F2, G2,
		A3, B3, C3, D3, E3, F3, G3,
		A4, B4, C4, D4, E4, F4, G4,
		A5, B5, C5, D5, E5, F5, G5,
		A6, B6, C6, D6, E6, F6, G6,
		A7, B7, C7, D7, E7, F7, G7
	} eMoveIndex;
	AttacksMove() : From( A1 ), To( A1 ) {}
	virtual ~AttacksMove() {}
	eMoveIndex From;
	eMoveIndex To;
};


class Displayer
{
public:
	Displayer(){}
	virtual ~Displayer(){}

	virtual void PrintVolatileInfo( const char *Msg, ... ) = 0;
	virtual void PrintStaticInfo( const char *Msg, ... ) = 0;
};

class Player
{
public:	

	typedef enum {
		WHITE,
		BLACK,	
	} ePlayerColor;

	// Construction/Destruction
	Player  ( ){}
	virtual ~Player ( ){}
	
	virtual bool InitGame() = 0;
	virtual const char *GetName() = 0;
	virtual const char *GetAuthor() = 0;
	virtual const char *GetVersion() = 0;
	virtual const char *GetDescription() = 0;
	virtual void SetDisplayer( Displayer *D ) = 0;
#ifdef WIN32	
	virtual const HWND GetDisplayerHandle() = 0;
#endif
	virtual void SetReflexionTime( int Time ) = 0; // Total reflexion time for the entire game (in ms)	
	virtual void SetElapsedTime( int Time ) = 0; // Elapsed time in ms

	virtual Move *GetMove( Move *LastPlayedMove ) = 0;

	virtual ePlayerColor GetColor( ) { return Color;}
	
	virtual void SetColor( ePlayerColor Color ) { this->Color = Color; }
protected:
	ePlayerColor Color;
};

#ifdef WIN32
#	define ATTAX_EXPORT extern __declspec(dllexport)
#else
#	define ATTAX_EXPORT extern
#endif

#ifndef PLATFORM
extern "C" /* C-style prototypes for a good export */
{
	ATTAX_EXPORT double GetSDKVersion( );
	ATTAX_EXPORT Player *GetPlayerInstance( );
	ATTAX_EXPORT void FreePlayerInstance( Player *P );	
}
#endif

#endif 

