[org 100h]
[segment .text]

%define pts 65534-0x300


Load_File:
  xor ax,ax
  mov dx, file
  mov ah, 0x3d
  int 21h

  mov bx, ax
  mov ax, 0x3f00
  mov cx, 200
  mov dx, pts
  int 21h

  push word 0xa000
  pop es

Gfx_On:  
  mov al,13h
  int 10h

Palette:
  mov dx, 03c8h
  xor al,al

  out dx, al
  inc dx
  out dx, al
  out dx, al
  out dx, al  

	dec al
  out dx, al
  out dx, al
  out dx, al

  out dx, al
	inc al
  out dx, al
  out dx, al

 ; clearscreen
  mov cx, 320*200/2
  xor di,di
  rep stosw

	mov al,2	; al -> 1
	xor si,si

Plot_Loop:
	movzx bx, byte [pts+si]
	inc si
	movzx di, byte [pts+si]
	imul  di, 320
	add   di, bx

	stosb
	inc si
	cmp si,200
	jl Plot_Loop

;jmp Wait_Esc


; teken van elk punt naar elk ander

	xor di,di
Plot_outer:
	xor si,si
Plot_inner:
	mov ax,[pts+si]
	mov [line_source],ax
	mov ax,[pts+di]
	mov [line_target],ax
	pushad

;
; MIJN mega heftige lijn routine
;
lijn:
	; [+0] -> x1
	; [+1] -> y1
	; [+2] -> x2
	; [+3] -> y2
	; for y = y1 to y2
	; plot (x1 + ((x2-x1)/(y2-y1))*y
	xor bx,bx
	xor ax,ax
	mov al,[line_source+1]
	mov bl,[line_target+1]
	sub bx,ax
	jz .nodraw
	jS .nodraw

	xor dx,dx
	xor ax,ax
	mov al,[line_target]
	mov dl,[line_source]
	sub ax,dx
	sal ax,7
	cwd
	idiv bx
	
	xor cx,cx
	mov cl, byte [line_source]
	shl cx,7
	movzx bp, byte [line_source+1]
.inner:

	mov bx,bp
	imul bx,320

	mov dx,cx
	shr dx,7
	add bx,dx
	
	add cx,ax
	cmp byte [es:bx],0
	jne .skip_pixel
	mov byte [es:bx],8
.skip_pixel:
	
	inc bp
	movzx bx,byte [line_target+1]
	cmp bp,bx
	jb .inner
.nodraw:

	popad 

	add si,2
	cmp si,200
	jl Plot_inner

	add di,2
	cmp di,200
	jl Plot_outer


mov ax,es
mov ds,ax

mov bp,-1
call doe_kanten
mov bp,1
call doe_kanten


; haal vieze dingen weg
	xor bx,bx
bah_vies:
	and byte [bx],255-8
	dec bx
	jnz bah_vies

Wait_Esc:
  in al, 60h
	cbw
	dec ax
	jnz Wait_Esc

Exit:
  mov al, 03h
  int 10h
  ret

;
; do l33t scan for sides, van rechts naar links
; DEEL 2!
; bp -> 1 of -1 voor welke kant je op wil
doe_kanten:
	xor bx,bx
	xor cx,bx
.vlnr_outer:
	mov di, bp
.vlnr_inner:
	cmp byte [di+bx],0
	jne .vlnr_loop_klaar
	;mov byte [di+bx],2

	add di,bp
	jnz .vlnr_inner
.vlnr_loop_klaar:
	cmp byte [di+bx],2
	jne .vlnr_geen_punt
	dec byte [di+bx]
.vlnr_geen_punt:
	mov cx,di
	add bx,320
	jnc .vlnr_outer
ret

file: db 'a', 0

line_source dw 0
line_target dw 0
