/*  xa-003 
 *  Copyright (C) Joakim Kolsjö 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "scene_intro.h"
#include <cmath>
#include <iostream>
#include <sstream>

#ifdef WIN32
#include "SDL/SDL.h"
#else
#include "SDL.h"
#endif

using namespace std;

// Scene end time
#define END 13000 //100000 //13000

namespace scene
{
	Intro::Intro(xio::Manager *i)
	{
		xio = i;
	
   		// Big flower cords
		int df = 0;
				
		bflowerlist[0].x = 586; bflowerlist[0].y = 399;
		bflowerlist[1].x = 41; bflowerlist[1].y = 409;
		bflowerlist[2].x = 31; bflowerlist[2].y = 36;
		bflowerlist[3].x = 601; bflowerlist[3].y = 34;
		bflowerlist[4].x = 577; bflowerlist[4].y = 259;
		bflowerlist[5].x = 570; bflowerlist[5].y = 144;
		bflowerlist[6].x = 423; bflowerlist[6].y = 31;
		bflowerlist[7].x = 285; bflowerlist[7].y = 37;
		bflowerlist[8].x = 152; bflowerlist[8].y = 40;
		bflowerlist[9].x = 29; bflowerlist[9].y = 167;
		bflowerlist[10].x = 35; bflowerlist[10].y = 281;
		bflowerlist[11].x = 156; bflowerlist[11].y = 446;
		bflowerlist[12].x = 277; bflowerlist[12].y = 431;
		bflowerlist[13].x = 398; bflowerlist[13].y = 426;
		bflowerlist[14].x = 483; bflowerlist[14].y = 424;
		bflowerlist[15].x = 449; bflowerlist[15].y = 269;
		bflowerlist[16].x = 406; bflowerlist[16].y = 150;
		bflowerlist[17].x = 227; bflowerlist[17].y = 169;
		bflowerlist[18].x = 120; bflowerlist[18].y = 197;
		bflowerlist[19].x = 178; bflowerlist[19].y = 306;
		bflowerlist[20].x = 308; bflowerlist[20].y = 281;
	
		for(int f = 0; f < (int)bflowerlist.size(); f++)
		{
			stringstream ss;
			if((f - df) > 8)
				df += 8;
			ss << (f - df);	
			string name = "flower" + ss.str();
			bflowerlist[f].texture = texture(name.c_str());
		}
		
		// Precache small flowers
		for(int f = 0; f <= 8; f++)
		{
			stringstream ss;
			ss << f;
			string name = "flower" + ss.str();
			smallflower[f] = xio->video->resizeSurface(texture(name.c_str()), 19, 19);
		}
		
		// Prerender texts
		gfx_font.init(i, texture("font"));		
		text_ppres = gfx_font.preDraw("Proudly Presents");
		text_xa003 = gfx_font.preDraw("xa-003:");
	}
	
	int Intro::draw(long time, float move)
	{
		// Clear screen
		EVENT(0, END)
			xio->video->fillScreenAll(0);
		
		// xAngle
		static float xangle_fadein = 1;
		EVENT(0, END)
		{
			EVENT(0, 3000) {
				xangle_fadein -= ((float)((float)1/3)/25)*move;
				if(xangle_fadein < 0)
					xangle_fadein = 0;
			}
			blit(texture("xangle3d"), 320-texture("xangle3d")->w/2, 150-50, 0, 0, xangle_fadein, false);
		}
		
		// "Proudly Presents"
		EVENT(1000, END)
		{
			static float ppres_fadein = 1;
			EVENT(1000, 4000) {
				ppres_fadein -= ((float)((float)1/3)/25)*move;
				if(ppres_fadein < 0)
					ppres_fadein = 0;
			}
			blit(text_ppres, 320-(19*16)/2, 230, 0, 0, ppres_fadein, false);
		}
		
		// "xa-003:"
		EVENT(3000, END)
		{
			static float xa003_fadein = 1;
			EVENT(3000, 6000) {
				xa003_fadein -= ((float)((float)1/3)/25)*move;
				if(xa003_fadein < 0)
					xa003_fadein = 0;
			}
			blit(text_xa003, 320-(19*7)/2, 280, 0, 0, xa003_fadein, false);
		}

		// "MIDSUMMER"
		static float ms_fadein = 1;
		EVENT(3800, END)
		{
			EVENT(3800, 6800) {
				ms_fadein -= ((float)((float)1/3)/25)*move;			
				if(ms_fadein < 0)
					ms_fadein = 0;
			}
			blit(texture("midsummer"), 320-texture("midsummer")->w/2, 360-50, 0, 0, ms_fadein, false);
		}
		
		// Grow flowers on "MIDSUMMER"
		static float flowersize = 1;
		EVENT(5800, END)
		{
			if(flowersize < 19) {
				flowersize += ((float)((float)8)/25)*move;	
			}
			else
				flowersize = 19;
			blit(smallflower[0], 152, 325, (int)flowersize, (int)flowersize, -1, true);
			blit(smallflower[1], 187, 341, (int)flowersize, (int)flowersize, -1, true);
			blit(smallflower[2], 228, 317, (int)flowersize, (int)flowersize, -1, true);
			blit(smallflower[3], 275, 346, (int)flowersize, (int)flowersize, -1, true);
			blit(smallflower[4], 325, 327, (int)flowersize, (int)flowersize, -1, true);
			blit(smallflower[5], 372, 345, (int)flowersize, (int)flowersize, -1, true);
			blit(smallflower[6], 405, 318, (int)flowersize, (int)flowersize, -1, true);
			blit(smallflower[7], 462, 346, (int)flowersize, (int)flowersize, -1, true);
			blit(smallflower[8], 488, 319, (int)flowersize, (int)flowersize, -1, true);	
		}
		
		// Fill the screen with big flowers
		static float bflowersize = 1;
		EVENT(9000, END)
		{		
			// Calculate flower size
			if(bflowersize < 114*6) {
				bflowersize += ((float)((float)(114*2)/2)/25)*move;	
				if(bflowersize >= 114*6)
					bflowersize = 114*6;
			}

			static int bc = (int)bflowerlist.size();
	
			// As the flowers grow, we stop drawing the first ones in the list
			int start = (int)((float)((float)bflowersize/(114*6))*bc);
			
			// Draw the flowers in the list
			for(int i = start+3; i < bc; i++) {
				// Make the flowers start to grow at diffrent times
				int bfs = (int)bflowersize - i*10;
				if(bfs <= 0)
					bfs = 1;
				
				blit(bflowerlist[i].texture,  bflowerlist[i].x, bflowerlist[i].y, bfs, bfs, -1, true);
			}
		}
		
		// If scenetime is out, end scene
		if(time >= END) {
			// Save screen when we arrive at the END, we use it in the next scene.
			xio::surface *introscreen = xio->video->createSurface(640, 480);
			xio->texture->add(introscreen, "introscreen");
			xio->video->blit(xio->video->getScreen(), texture("introscreen"), 0, 0, 0, 0, -1, false);
			return 1;
		}
		return 0;
	}
}
