/*  xa-003 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2004
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "scene_dance.h"
#include <cmath>
#include <iostream>
#include <sstream>
#include <vector>


#ifdef WIN32
#include "SDL/SDL.h"
#else
#include "SDL.h"
#endif

using namespace std;

// Scene end time
#define END 13000

namespace scene
{
	Dance::Dance(xio::Manager *i)
	{
		xio = i;
		
		gfx_sort.init(i);

		gfx_sort.addObject(texture("midsommarstang"));
		gfx_sort.changeObject(0,
				320 - texture("midsommarstang")->w/2,
				480 - texture("midsommarstang")->h - 20);
		gfx_sort.addObject(texture("boy1"));
		gfx_sort.addObject(texture("boy2"));
		gfx_sort.addObject(texture("girl1"));
		gfx_sort.addObject(texture("girl2"));
		
		// For use in fadeout of last screen
		for(int i = 0; i < 5; i++)
			for(int j = 0; j < 5; j++)
				spart[i][j] = true;
	}
		
	int Dance::draw(long time, float move)
	{
		static float xmove = 0, ymove = 0;
		EVENT(0, END)
		{		
			xmove -= ((float)((float)(1))/25)*move;
			ymove -= ((float)((float)(1/10))/25)*move;
				
			// Clear screen
			blit(texture("midsky"), 0, 0, 0, 0, -1, false);
			gfx_sort.changeObject(1, 
				320 - gfx_sort.getTextureWidth(1)/2 + (int)(sin(xmove)*200),
				480 - gfx_sort.getTextureHeight(1) - 20 + (int)(cos(xmove)*20));
			
			gfx_sort.changeObject(2, 
				320 - gfx_sort.getTextureWidth(2)/2 + (int)(sin(xmove+1)*200),
				480 - gfx_sort.getTextureHeight(2) - 20 + (int)(cos(xmove+1)*20));

			gfx_sort.changeObject(3, 
				320 - gfx_sort.getTextureWidth(3)/2 + (int)(sin(xmove+2)*200),
				480 - gfx_sort.getTextureHeight(3) - 20 + (int)(cos(xmove+2)*20));

			gfx_sort.changeObject(4, 
				320 - gfx_sort.getTextureWidth(4)/2 + (int)(sin(xmove+3)*200),
				480 - gfx_sort.getTextureHeight(4) - 20 + (int)(cos(xmove+3)*20));

			gfx_sort.blitObjects(xio->video->getScreen());
		}
		
		// Drop off last scene
		static int rx, ry;
		static long ttime = time;
		static int pcount = 0;
		EVENT(0, 1250)
		{
			if(time - ttime > 50 && pcount < 25)
			{
				ttime = time;
				
				// Get a new x and y
				for(;;)
				{
					rx = (int)(random.get()*5);
					ry = (int)(random.get()*5);
					
					// Check if part still exist
					if(spart[rx][ry]) {
						spart[rx][ry] = false;
						pcount++;
						break;
					}
				}

				// Delete x:y
#ifndef NO_STEX
			xio->video->fillSurface(texture("rcubescreen"), 0xff00ff, rx*128, ry*96, rx*128+128, ry*96+96);
#endif
			}
#ifndef NO_STEX
			blit(texture("rcubescreen"), 0, 0, 0, 0, -1, false);
#endif
		}

		// If scenetime is out, end scene
		if(time >= END) {
			// Save screen when we arrive at the END, we use it in the next scene.
			xio::surface *dancescreen = xio->video->createSurface(640, 480);
			xio->texture->add(dancescreen, "dancescreen");
			xio->video->blit(xio->video->getScreen(), texture("dancescreen"), 0, 0, 0, 0, -1, false);
			return 1;
		}
		return 0;
	}
}
