/*  xdm - Demo manager 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2003
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#ifndef XDM_H
#define XDM_H

#include <map>

#include "xio.h"

// Scene event
#define EVENT(Start, Stop) if(time > Start && time < Stop)

namespace xdm 
{
	// (Scene) Manager ---------------------------------------------------------
	class Scenebase {
	public:
		virtual int draw(long time, float move)=0;
	protected:
		xio::surface *texture(const char *name) { return xio->texture->get(name); };
		void blit(xio::surface *texture, int dx, int dy, int width, int height, float alpha, bool centralize)
		{ xio->video->blitToScreen(texture, dx, dy, width, height, alpha, centralize); };
		xio::Manager *xio;
	};
	
	class Manager 
	{
	public:
		Manager(xio::Manager *i);
		void add(Scenebase *sc);
		void run(int sc);
		void runall();
	
	private:
		void update();
	
		long scenestart, frametime, fpsupdate, demotime;
		float move;
		int frames;
#ifdef DEBUG
		int fpscount;
		int total_fps;
		bool skipscene, hoptime;
#endif
		// Scene pointers
		std::map <int, Scenebase *> scene;
		
		xio::Manager *xio;	
	};
}

#endif
