float4x4 mWVP;
texture MatTexture;
float4 EyeVec;

sampler Samp = sampler_state
{
	Texture = <MatTexture>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float4 Col		:	COLOR;
	float2 Tex		:	TEXCOORD0;
	float3 Nrm		:	TEXCOORD1;
	float3 Eye		:	TEXCOORD2;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float3 Nor		:	NORMAL,
	float2 Tex		:	TEXCOORD
){
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	Out.Tex = Tex;
	Out.Nrm = Nor;
	Out.Eye = EyeVec;
	return Out;
}

float4 PS( VS_OUTPUT In) : COLOR
{
	float4 amb = {0.7f,0.7f,0.7f,1.0f};
	float3 L = {-0.2f, -0.6f, -0.2f};
	return tex2D(Samp, In.Tex) * (max(dot(In.Nrm,L),0)+amb);
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_1 PS();
	}
}