#include "_types.hpp"
#include "_start.hpp"
#include "_ogg.hpp"
#include "demoutil.hpp"
#include "fg.hpp"
#include "th.h"

/****************************************************************************/

static sOGGDecoder *ogg = 0;
static sMaterialInfo TestInfo,FadeCredits;
static sInt GeoDouble;

static LandscapeTexture *tex = 0;
static GrowingUglyThing *thing = 0;
static TextWriter *writer = 0;

/****************************************************************************/

static void OggSoundHandler(sS16 *buffer,sInt samples,void *user)
{
  sOGGDecoder *decoder = (sOGGDecoder *) user;
  decoder->Render(buffer,samples);
}

/****************************************************************************/

static void FXQuad(sMaterialInfo *mtrl,sFRect *scr=0,sFRect *uv0=0,sFRect *uv1=0)
{
  sInt i,j;
  sMaterialEnv env;
  sF32 *vp;
  static sFRect full = { 0.0f, 0.0f, 1.0f, 1.0f };

  if(!scr) scr = &full;
  if(!uv0) uv0 = &full;
  if(!uv1) uv1 = &full;

  env.Init();
  env.Orthogonal = sMEO_NORMALISED;
  sSystem->MtrlSet(mtrl,&env);
  sSystem->GeoBegin(GeoDouble,4,0,&vp,0);
  for(i=0;i<4;i++)
  {
    j = i ^ (i >> 1);
    *vp++ = ((j & 1) ? scr->x1 : scr->x0) * 2.0f - 1.0f;
    *vp++ = ((j & 2) ? scr->y0 : scr->y1) * 2.0f - 1.0f;
    *vp++ = 1.0f;
    *vp++ = 0.0f;
    *vp++ = (j & 1) ? uv0->x1 : uv0->x0;
    *vp++ = (j & 2) ? uv0->y1 : uv0->y0;
    *vp++ = (j & 1) ? uv1->x1 : uv1->x0;
    *vp++ = (j & 2) ? uv1->y1 : uv1->y0;
  }
  sSystem->GeoEnd(GeoDouble);
  sSystem->GeoDraw(GeoDouble);
}

/****************************************************************************/

sBool sAppHandler(sInt code,sU32 value)
{
  sViewport vp;
  sFRect rect,rect2;
  static sF32 lasttime=0,firsttime=0;

  switch(code)
  {
  case sAPPCODE_CONFIG:
    sSetConfig(sSF_DIRECT3D|sSF_FULLSCREEN,800,600);
    break;

  case sAPPCODE_INIT:
    ogg = new sOGGDecoder;
    ogg->Init("data\\tune.ogg");

    tex = new LandscapeTexture;

    TestInfo.Init();
    TestInfo.ShaderLevel = sPS_13; 
    TestInfo.BaseFlags = smBF_ZOFF|smBF_BLENDOFF|smBF_NONORMAL|smBF_DOUBLESIDED;
    TestInfo.Color[0] = 0x003eff04;
    TestInfo.Color[2] = 0x000a200a;
    TestInfo.Combiner[sMCS_COLOR0] = sMCOA_SET;
    TestInfo.Combiner[sMCS_TEX0] = sMCOA_MUL;
    TestInfo.Combiner[sMCS_COLOR2] = sMCOA_ADD;
    TestInfo.Tex[0] = tex->Tex;
    TestInfo.TFlags[0] = smTF_CLAMP;
    TestInfo.Handle = sSystem->MtrlAdd(&TestInfo);
    sVERIFY(TestInfo.Handle != sINVALID);

    FadeCredits.Init();
    FadeCredits.ShaderLevel = sPS_13;
    FadeCredits.BaseFlags = smBF_ZOFF|smBF_BLENDALPHA|smBF_NONORMAL|smBF_DOUBLESIDED;
    FadeCredits.Color[0] = 0x00000000;
    FadeCredits.Combiner[sMCS_TEX0] = sMCOA_SET;
    FadeCredits.AlphaCombiner = sMCA_COL0;
    FadeCredits.Tex[0] = sLoadTexture("data\\credits.jpg");
    FadeCredits.TFlags[0] = smTF_FILTER|smTF_CLAMP;
    FadeCredits.Handle = sSystem->MtrlAdd(&FadeCredits);
    sVERIFY(FadeCredits.Handle != sINVALID);

    sBroker->Free();

    GeoDouble = sSystem->GeoAdd(sFVF_DOUBLE,sGEO_QUAD);
    thing = new GrowingUglyThing;
    writer = new TextWriter;

    sSystem->SetSoundHandler(OggSoundHandler,64,ogg);
    break;

  case sAPPCODE_EXIT:
    sSystem->GeoRem(GeoDouble);
    sSystem->SetSoundHandler(0);
    delete writer;
    delete thing;
    delete tex;
    delete ogg;
    break;

  case sAPPCODE_KEY:
    switch(value)
    {
    case sKEY_ESCAPE:
    case sKEY_CLOSE:
      sSystem->Exit();
      break;
    }
    break;

  case sAPPCODE_PAINT:
    {
      vp.Init(0);
      vp.ClearColor = 0;
      vp.ClearFlags = sVCF_ALL;
      sSystem->BeginViewport(vp);

  	  sF32 time=sSystem->GetTime()/1000.0f;
		  if (!lasttime) lasttime=time;
      if (!firsttime) firsttime=time;
		  sF32 tdelta=time-lasttime;
		  lasttime=time;

      thing->Calculate(tdelta);
      writer->Update(tdelta);

      tex->Camera.Init(0.0f,16.0f,time);
      tex->Angle = time / 16.0f;

      tex->Render();

      rect.Init(0,0,1,1);
      //rect.Init((800-512)/1600.0f,(600-512)/1200.0f,(800+512)/1600.0f,(600+512)/1200.0f);
      FXQuad(&TestInfo,&rect);

      writer->DrawBgLayer();
      thing->Draw();
      writer->DrawFgLayer();

      rect.Init(0,0,1,1);
      rect2.Init(0,-100.0f/512.0f,1.0f,612.0f/512.0f);
      FadeCredits.Color[0] = sRange<sInt>(255*(time - firsttime - 286) / 3.0f,255,0) << 24;
      FXQuad(&FadeCredits,&rect,&rect2);

      sSystem->EndViewport();
    }
    break;

  default:
    return sFALSE;
  }

  return sTRUE;
}

/****************************************************************************/


