# show demoscript definitions
import demoscript
print "testing module."
print dir(demoscript)
print "ok."
import random

from demoscript import *
import math
print "initing demo system"

# setup texture manager
tm = TextureManagerSingleton_instance()

# setup scheduler
sched = SchedulerSingleton_instance()

def initImg(img,x,y):
	img.setPos(x,y)
	img.setScaleX(0.2)
	img.setScaleY(0.2)
	img.opacity.setFixPointDamping(0.98)
	return img


class Controls(ImageSeq):

	def callback(self):
		for i in range(4):
			for j in range(6):
				if getEvent(EC_NOTE_ON,i,j):
					self.take(1,i*6+j,i*6+j+1)
	
controls=Controls()

cImgs=[]

map (controls.addImage,cImgs)


#########################
### Demo starts here. ###
#########################


class CustomGamma(MGGamma):
	def __init__(self):
		MGGamma.__init__(self)
		self.red=FixedSlider(1.2,1.2)
		self.green=FixedSlider(1.2,1.2)
		self.blue=FixedSlider(1.2,1.2)
		self.red.setDamping(0.978)
		self.green.setDamping(0.978)
		self.blue.setDamping(0.978)
		
		self.red.setFixPointDamping(0.975)
		self.green.setFixPointDamping(0.975)
		self.blue.setFixPointDamping(0.975)

		

	def callback(self):
		if getEvent(EC_NOTE_ON,1,0):			
			self.red.setTargetValue(4)
			self.green.setTargetValue(4)
			self.blue.setTargetValue(4)

		if getEvent(EC_NOTE_ON,1,1):			
			self.red.setTargetValue(0.02)
			self.green.setTargetValue(0.02)
			self.blue.setTargetValue(0.02)


mgg=CustomGamma()
rgbmap=RGBMap()

mgg.connectOutput(rgbmap,"map")




def randPos(img):
	img.setPos(0,frand(-0.6,0.6))
	return img

def imgSet(img):
	img.opacity.setFixPointDamping(0.978)
	return img

ds=[]
ds.append(imgSet(Image("d:\\gfx\\crap1.tga")))
ds.append(imgSet(Image("d:\\gfx\\crap2.tga")))
	#ds.append(randPos(Image("d:\\crap3.tga")))

class DirtSquares(ImageSeq):
	def callback(self):
		if getEvent(EC_NOTE_ON,0,5):
			self.next()
		
dirtSquares=DirtSquares();
map (dirtSquares.addImage,ds)

class CustomBlur(Blur):
	
	def __init__(self):
		Blur.__init__(self)
		self.mix=FixedSlider(1,0)
		self.mix.setDamping(0.9999)
	
	def callback(self):
		if getEvent(EC_NOTE_ON,0,6):
			self.mix.setTargetValue(1)
			self.mix.setDamping(0.98)
		

balScn=llScene("d:\\scenes\\ref.pck")
balScn.getObjects()[10].noiseFreq=FixedSlider(0,0)
balScn.getObjects()[10].noiseOffset=FixedSlider(0,10)
balScn.getObjects()[10].noiseOffset.setDamping(0.999999)

for i in balScn.getObjects():
	print i.getName()


class BalScene(Scene):
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			global balScn
			balScn.getObjects()[10].noiseAmplitude.setTargetValue(20)
			balScn.getObjects()[10].noiseFreq.setTargetValue(0.05)
			balScn.getObjects()[3].red.setTargetValue(0)
			balScn.getObjects()[3].green.setTargetValue(0)
			balScn.getObjects()[3].blue.setTargetValue(0)
			

		if getEvent(EC_NOTE_ON,2,1):			
			self.nextCamera()
			balScn.getObjects()[10].noiseOffset=FixedSlider(0,10)
			balScn.getObjects()[10].noiseOffset.setDamping(0.999999)
		if getEvent(EC_NOTE_ON,2,2):			
			self.reset()
		
balScene=BalScene()
balScene.setScene(balScn)
balScene.speed=FixedSlider(8000,8000)


noiseScn=llScene("d:\\scenes\\dist2.pck")
noiseScn.getObjects()[0].noiseFreq=FixedSlider(0,0)
noiseScn.getObjects()[0].noiseOffset=FixedSlider(0,10)
noiseScn.getObjects()[0].noiseOffset.setDamping(0.999999)
noiseScn.getObjects()[0].noiseAmplitude.setFixPointDamping(0.985)

class NoiseScene(Scene):
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			global noiseScn
			noiseScn.getObjects()[0].noiseAmplitude.setTargetValue(120)
			noiseScn.getObjects()[0].noiseFreq.setTargetValue(0.02)
		if getEvent(EC_NOTE_ON,0,1):			
			self.nextCamera()
			noiseScn.getObjects()[0].noiseOffset=FixedSlider(0,10)
			noiseScn.getObjects()[0].noiseOffset.setDamping(0.999999)
		if getEvent(EC_NOTE_ON,0,2):			
			self.reset()
		
noiseScene=NoiseScene()
noiseScene.setScene(noiseScn)
noiseScene.speed=FixedSlider(8000,8000)


noiseScn2=llScene("d:\\scenes\\dist6.pck")
noiseScn2.getObjects()[1].noiseFreq=FixedSlider(0.005,0.005)
noiseScn2.getObjects()[1].noiseOffset=FixedSlider(1,10)
noiseScn2.getObjects()[1].noiseOffset.setDamping(0.999999)
noiseScn2.getObjects()[1].noiseAmplitude=FixedSlider(1,1)
noiseScn2.getObjects()[1].noiseAmplitude.setFixPointDamping(0.985)

noiseScn2.getObjects()[1].noiseOffset=FixedSlider(0,1000)
noiseScn2.getObjects()[1].noiseOffset.setDamping(0.99999)
noiseScn2.getObjects()[1].noiseOffset.setFixPointDamping(0.99999)



class NoiseScene2(Scene):
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			global noiseScn2
			noiseScn2.getObjects()[1].noiseAmplitude.setTargetValue(40)
			noiseScn2.getObjects()[1].noiseFreq.setTargetValue(0.02)

		if getEvent(EC_NOTE_ON,0,1):			
			self.nextCamera()
#			noiseScn2.getObjects()[1].noiseOffset=FixedSlider(0,10)
#			noiseScn2.getObjects()[1].noiseOffset.setDamping(0.98)
#			noiseScn2.getObjects()[1].noiseOffset=FixedSlider(0,1000)
#			noiseScn2.getObjects()[1].noiseOffset.setDamping(0.99999)
#			noiseScn2.getObjects()[1].noiseOffset.setFixPointDamping(1)

		if getEvent(EC_NOTE_ON,0,2):			
			self.reset()
		
noiseScene2=NoiseScene2()
noiseScene2.setScene(noiseScn2)
noiseScene2.speed=FixedSlider(8000,8000)


###########
noiseScn3=llScene("d:\\scenes\\dist4.pck")
noiseScn3.getObjects()[0].noiseFreq=FixedSlider(0.005,0.005)
noiseScn3.getObjects()[0].noiseOffset=FixedSlider(1,10)
noiseScn3.getObjects()[0].noiseOffset.setDamping(0.999999)
noiseScn3.getObjects()[0].noiseAmplitude=FixedSlider(1,1)
noiseScn3.getObjects()[0].noiseAmplitude.setFixPointDamping(0.985)

noiseScn3.getObjects()[0].noiseOffset=FixedSlider(0,1000)
noiseScn3.getObjects()[0].noiseOffset.setDamping(0.99999)
noiseScn3.getObjects()[0].noiseOffset.setFixPointDamping(0.99999)


class NoiseScene3(Scene):
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			global noiseScn2
			noiseScn3.getObjects()[0].noiseAmplitude.setTargetValue(120)
			noiseScn3.getObjects()[0].noiseFreq.setTargetValue(0.02)

		if getEvent(EC_NOTE_ON,0,1):			
			self.nextCamera()
#			noiseScn2.getObjects()[0].noiseOffset=FixedSlider(0,10)
#			noiseScn2.getObjects()[0].noiseOffset.setDamping(0.98)
#			noiseScn2.getObjects()[0].noiseOffset=FixedSlider(0,1000)
#			noiseScn2.getObjects()[0].noiseOffset.setDamping(0.99999)
#			noiseScn2.getObjects()[0].noiseOffset.setFixPointDamping(1)

		if getEvent(EC_NOTE_ON,0,2):			
			self.reset()
		
noiseScene3=NoiseScene3()
noiseScene3.setScene(noiseScn3)
noiseScene3.speed=FixedSlider(8000,8000)


def hmpf(img,x,y):
	img.setPos(x,y)
	return img

crImgs=[]
crImgs.append(hmpf(Image("d:\\gfx\\cred1.tga"),0,-0.3))
crImgs.append(hmpf(Image("d:\\gfx\\cred2.tga"),0,0.3))

class CredSeq(ImageSeq):

	def callback(self):
		if getEvent(EC_NOTE_ON,0,4):
			self.next()

credSeq=CredSeq()
map (credSeq.addImage,crImgs)


class IntroScene(Scene):
	
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.offset.setTargetValue(1600)


scn0=llScene("d:\\scenes\\distort.pck")
scene0=IntroScene()
scene0.setScene(scn0)
scene0.speed=FixedSlider(4600,4600)

class PijlenScene(Scene):
	
	def callback(self):
		if getEvent(EC_NOTE_ON,0,0):
			self.offset.setTargetValue(3600)

scn1=llScene("d:\\scenes\\pijlen.pck")
scene1=PijlenScene()
scene1.setScene(scn1)
scene1.speed=FixedSlider(4600,4600)

class CustomDistort(Distort):
	
	def __init__(self):
		Distort.__init__(self)
		self.amount.setFixPointDamping(0.95)


	def callback(self):
		if getEvent(EC_NOTE_ON,0,3):
			self.amount.setTargetValue(43)
		if getEvent(EC_NOTE_ON,0,7):
			self.amount.setTargetValue(120)


visScn=llScene("d:\\scenes\\visje.pck")
visScene=Scene()
visScene.setScene(visScn)
visScene.speed=FixedSlider(12600,12600)




blur=CustomBlur()
#dirtSquares.connectOutput(blur,"in")
dist=CustomDistort()
#dist.amount=FixedSlider(0.5,0.5)
dist.connectOutput(rgbmap,"in")
xfade=XFade()
sched.schedule(0,10,visScene,SI_A,0)
sched.schedule(10,20,scene0,SI_A,0)
#sched.schedule(0,30,noiseScene2,SI_A,0)
sched.schedule(0,142,xfade,SI_MIX,0)
sched.schedule(28,30,scene1,SI_B,0)
sched.schedule(30+26,30,balScene,SI_A,0)

noiseScene.connectOutput(credSeq,"in")
sched.schedule(30+26+28,15,credSeq,SI_B,0)
#sched.schedule(30+26+28,15,noiseScene,SI_B,0)
sched.schedule(30+26+28+15,30,noiseScene2,SI_A,0)
sched.schedule(30+26+28+15+30,13,noiseScene3,SI_B,0)

rgbmap.connectOutput(blur,"in")
sched.schedule(0,142,blur,SI_POST,0)
#sched.schedule(0,142,rgbmap,SI_POST,0)

#sched.schedule(0,142,controls,SI_SUPER,0)





##############################
playSong("d:\\wma\\deun.wma")


