/* Copyright 2004 Jetro Lauha - http://iki.fi/jetro/
 *
 * $Id: testlevel.as,v 1.6 2004/08/02 19:44:28 tonic Exp $
 * $Revision: 1.6 $
 */

/* Note: playSound function is undocumented as it is currently
 *       only temporarily as it is.
 */

const int BONUS_OBJ_SCORE = 1500;
const int ROTO_SCORE = 500;
const int ELEVATOR_SCORE = 1000;
const int MAX_TIME = 120000;

uint mTime;
int screenWidth, screenHeight;
uint frame = 0;

int timeLeft, timeBonus = 0;
int score = 0;

GameApp *app;
UIFont *medFont, *smallFont;
uint medFontHeight, smallFontHeight;
PhysicsWorld *pw;

PhysicsObject *objHead;

PhysicsObject *objH1, *objH2, *objH3, *objH4, *objH5, *objH6;
uint objHColor;
PhysicsObject *collectedBonus = 0;

PhysicsObject *objRoto, *objButton;
float rotoInitAng, rotoAng = 0;
uint objButtonBlockColor;

PhysicsObject *objElevator, *objElevTrig;
int elevAct = 0, elevTimer = 0;
float elevPosX, elevPosY, elevPosZ;
float elevColR, elevColG, elevColB;

PhysicsObject *objFinish;

bool finished = false;
bool aborted = false;


// Called once on level initialization.
void onInit()
{
    app = getGameApp();
    screenWidth = app->getScreenWidth();
    screenHeight = app->getScreenHeight();
    medFont = app->getFont("medium");
    smallFont = app->getFont("small");
    medFontHeight = medFont->getFontHeight();
    smallFontHeight = smallFont->getFontHeight();

    pw = app->getPhysicsWorld();
    pw->setGravity(0, 0, -0.5);

    // Ragdoll head
    objHead = pw->findObject("Head");

    objH1 = pw->findObject("H1");
    objH2 = pw->findObject("H2");
    objH3 = pw->findObject("H3");
    objH4 = pw->findObject("H4");
    objH5 = pw->findObject("H5");
    objH6 = pw->findObject("H6");
    objHColor = objH1->getBlockColor();

    float y, p, r;
    objRoto = pw->findObject("Roto");
    objRoto->getInitialRotation(y, p, r);
    rotoInitAng = r;

    objButton = pw->findObject("Button");
    objButtonBlockColor = objButton->getBlockColor();

    objElevator = pw->findObject("Elevator");
    objElevator->getInitialPosition(elevPosX, elevPosY, elevPosZ);
    objElevator->getInitialColor(elevColR, elevColG, elevColB);

    objElevTrig = pw->findObject("ElevTrig");

    objFinish = pw->findObject("Finish");
}


// Called once for each game logic update before the physics update.
// Parameter 'time' is the simulation time in milliseconds.
void onUpdate(uint time)
{
    ++frame;
    mTime = time;

    if (!finished && !aborted)
    {
        timeLeft = int(MAX_TIME) - int(time);
        if (timeLeft < 0)
            timeLeft = 0;
    }

    float x, y, z = 0;
    objHead->getPosition(x, y, z);
    if (!aborted && z < -10)
    {
        aborted = true;
        setGameState(GAMESTATE_ABORTED);
    }

    if (rotoAng > 0 && (frame % 2) == 0)
    {
        // rotate object only every other frame so that
        // there's a bit more time for the collisions to resolve
        objRoto->setRotation(0, 0, rotoInitAng - rotoAng);
        rotoAng -= PI / 60;
    }

    if (elevAct != 0)
    {
        if (elevAct > 0)
        {
            elevPosZ += 0.06f;
            --elevAct;
        }
        else
        {
            elevPosZ -= 0.06f;
            ++elevAct;
        }
        if ((frame % 2) == 0)
            objElevator->setPosition(elevPosX, elevPosY, elevPosZ);
        objElevator->setColor(elevColR, elevColG, elevColB * 1.5f);
    }
    else
        objElevator->setColor(elevColR, elevColG, elevColB);
    if (elevTimer > 0)
    {
        --elevTimer;
        if (elevTimer == 0)
        {
            elevAct = -100;
            playSound(5); // elevator sound
        }
    }

    if (collectedBonus != 0)
    {
        collectedBonus->removeFromPhysicsWorld();
        collectedBonus = 0;
    }
}


// Called when there is a collision between the two given objects.
// Returns true to create contacts or false to ignore collision.
bool onCollision(PhysicsObject *o1, PhysicsObject *o2)
{
    uint o1bc = o1->getBlockColor(), o2bc = o2->getBlockColor();

    PhysicsObject *bonusObj = 0;
    if (o2bc == objHColor &&
        (o1 == objH1 || o1 == objH2 || o1 == objH3 ||
         o1 == objH4 || o1 == objH5 || o1 == objH6))
        bonusObj = o1;
    if (o1bc == objHColor &&
        (o2 == objH1 || o2 == objH2 || o2 == objH3 ||
         o2 == objH4 || o2 == objH5 || o2 == objH6))
        bonusObj = o2;
    if (bonusObj != 0)
    {
        score += BONUS_OBJ_SCORE;
        // object cannot be removed from physics world in onCollision callback
        collectedBonus = bonusObj;
        playSound(3); // bonus sound
    }

    // Trigger roto object if the same colored hand hits the button.
    if (((o1 == objButton && o2bc == objButtonBlockColor) ||
         (o2 == objButton && o1bc == objButtonBlockColor)) && rotoAng <= 0)
    {
        score += ROTO_SCORE;
        rotoAng = PI;
        playSound(4); // roto sound
    }

    // Check if some object hits the elevator trigger (no collisions).
    if ((o1 == objElevTrig || o2 == objElevTrig) && elevAct == 0 && elevTimer == 0)
    {
        // Move elevator after ragdoll hits the elevator trigger.
        if (o1->getType() == PHYSOBJ_RAGDOLL_BODY ||
            o2->getType() == PHYSOBJ_RAGDOLL_BODY)
        {
            elevAct = 100;
            elevTimer = 480;
            score += ELEVATOR_SCORE;
            playSound(5); // elevator sound
        }
        // no collision
        return false;
    }

    if ((o1 == objFinish || o2 == objFinish) && !finished)
    {
        finished = true;
        setGameState(GAMESTATE_FINISHED);
        timeBonus = timeLeft / 3;
        score += timeBonus;
    }

    // generate collision
    return true;
}


// Called when the game view is rendered.
// Might happen more or less frequently than update calls.
void onRender()
{
    const float gap = 70;

    if (mTime < 4000)
    {
        medFont->drawString(float(screenWidth / 2), gap,
                            UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_BOTTOM,
                            "Use mouse to move the ragdoll.");
    }
    else if (mTime >= 4000 && mTime < 7000 && objH1 != 0)
    {
        medFont->drawString(float(screenWidth / 2), gap,
                            UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_BOTTOM,
                            "Collect yellow boxes.");
    }
    else if (mTime >= 7000 && mTime < 10000 && objFinish != 0)
    {
        medFont->drawString(float(screenWidth / 2), gap,
                            UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_BOTTOM,
                            "Hit the green plate for victory.");
    }

    // draw score
    const float x = float(screenWidth) - gap;
    medFont->drawString(x, gap, UIFONT_ALIGN_RIGHT, bstrFormat(score));
    smallFont->drawString(x, gap + float(medFontHeight),
                          UIFONT_ALIGN_RIGHT, "Score");

    drawTime();

    if (aborted)
        drawFailure();
    if (finished)
        drawVictory();
}


void drawTime()
{
    const float x = 100, y = 70;
    int fracs = (timeLeft / 10) % 100;
    int seconds = timeLeft / 1000;
    bstr fracsStr = (fracs < 10 ? "0" : "") + bstrFormat(fracs);

    medFont->drawString(x, y, UIFONT_ALIGN_HORIZ_CENTER, ":");
    medFont->drawString(x - 4, y, UIFONT_ALIGN_RIGHT, bstrFormat(seconds));
    medFont->drawString(x + 4, y, UIFONT_ALIGN_DEFAULT, fracsStr);
    smallFont->drawString(x, y + float(medFontHeight),
                          UIFONT_ALIGN_HORIZ_CENTER, "Time Left");
}


void drawFailure()
{
    medFont->drawString(float(screenWidth / 2), float(screenHeight / 2),
                        UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER,
                        "You Failed!");
}


void drawVictory()
{
    medFont->drawString(float(screenWidth / 2), float(screenHeight / 2),
                        UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER,
                        "Victory!");
    medFont->drawString(float(screenWidth / 2),
                        float(screenHeight / 2 + int(medFontHeight) * 3),
                        UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER,
                        "Time bonus: " + bstrFormat(timeBonus));
    medFont->drawString(float(screenWidth / 2),
                        float(screenHeight / 2 + int(medFontHeight) * 5),
                        UIFONT_ALIGN_HORIZ_CENTER | UIFONT_ALIGN_VERT_CENTER,
                        "Total score: " + bstrFormat(score));
}
