/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef SCENE_MANAGER
#define SCENE_MANAGER

#include "scene.h"
#include "../basecode/video.h"
#include "../basecode/music.h"
#include "../basecode/timer.h"
#include "../basecode/global.h"
#include <map>

namespace demo
{
	namespace scene
	{
		class manager {
		public:
			manager(demo::video *v, demo::music *mus);
			void add(scenebase *sc);
			void run(int sc);
			void runall();
		private:
			void update();
			void update_events();
		
			long scenestart, second, frametime;
			int frames;
		
			demo::music *music;
		
			// Scene pointers
			std::map <int, scenebase *> scene;
		
			// Timer
			demo::timer timer;
			
			// Video
			demo::video *video;
		
		};
	}
}

#endif
