/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gfx_text.h"
#include "../basecode/image.h"
#include <cstring>
#include <iostream>

using namespace std;

demo::gfx::text::text(surface *surface)
{
	s = surface;
	width = surface->get_width();
	height = surface->get_height();
	

	font = load_png("../data/textures/fantasy-font.png");
}

void demo::gfx::text::draw(const char *str, int xg, int yg)
{
	pixel *p = s->lock_rectangle(0).pixels;
	bool odd_bigsize=0;
	int total_letters = strlen(str);
		
	for(int i = 0; i < total_letters; i++)
	{	
		for(int y = 0; y < 20; y++)
		{
			for(int x = 0; x < 28; x++)
			{				
				// Big letters
				if(str[i] >= 65 && str[i] < 65+28)
				{
					p[(int)(xg+x) + (int)(y+yg)*width] = font[(str[i]-65)*28+x + y*812];				
				}
				// Small letters
				else if(str[i] >= 97 && str[i] < 97+28)
				{
					p[(int)(xg+x/2) + (int)(y+yg)*width] = font[(str[i]-97)*14+x/2 + (20+y)*812];
				}
				// Special signs 33-47 !"#$%&'()*+,-./
				else if((str[i] >= 33 && str[i] <= 47))
				{
					p[(int)(xg+x/2) + (int)(y+yg)*width] = font[(str[i]-33)*14+x/2 + (60+y)*812];
				}
				// Special signs 58-64 :;<=>?@
				else if((str[i] >= 58 && str[i] <= 64))
				{
					p[(int)(xg+x/2) + (int)(y+yg)*width] = font[(str[i]-58)*14+x/2 + (60+y)*812];
				}
				// Special signs 91-96 [\]^_`
				else if((str[i] >= 91 && str[i] <= 96))
				{
					p[(int)(xg+x/2) + (int)(y+yg)*width] = font[(str[i]-91)*14+x/2 + (60+y)*812];
				}
				// Special signs 123-127 {|}
				else if(str[i] >= 123)
				{
					p[(int)(xg+x/2) + (int)(y+yg)*width] = font[(str[i]-123)*14+x/2 + (60+y)*812];
				}
				// Numbers
				else if(str[i] >= 48 && str[i] <= 57)
				{
					p[(int)(xg+x/2) + (int)(y+yg)*width] = font[(str[i]-48)*14+x/2 + (40+y)*812];
				}
				// Other letters
				else
				{
					if(str[i] == '') {
						p[(int)(xg+x) + (int)(y+yg)*width] = font[26*28+x + y*812];
						odd_bigsize = 1;
					}
					else if(str[i] == '') {
						p[(int)(xg+x) + (int)(y+yg)*width] = font[27*28+x + y*812];
						odd_bigsize = 1;
					}
					else if(str[i] == '') {
						p[(int)(xg+x) + (int)(y+yg)*width] = font[28*28+x + y*812];
						odd_bigsize = 1;
					}
					else if(str[i] == '') {
						p[(int)(xg+x/2) + (int)(y+yg)*width] = font[26*14+x/2 + (20+y)*812];
						odd_bigsize = 0;
					}
					else if(str[i] == '') {
						p[(int)(xg+x/2) + (int)(y+yg)*width] = font[27*14+x/2 + (20+y)*812];
						odd_bigsize = 0;
					}
					else if(str[i] == '') {
						p[(int)(xg+x/2) + (int)(y+yg)*width] = font[28*14+x/2 + (20+y)*812];
						odd_bigsize = 0;
					}
				}
			}
		}
		if((str[i] >= 65 && str[i] < 65+28) || odd_bigsize)
			xg += 28;
		else if((str[i] >= 97 && str[i] < 97+28)	
			|| (str[i] >= 48 && str[i] <= 57)		
			|| (str[i] >= 58 && str[i] <= 64)
			|| (str[i] >= 91 && str[i] <= 96)
			|| (str[i] >= 123)
			|| !odd_bigsize)
		{
			xg += 14;
		}
	}
	s->unlock_rectangle();
}
