/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "gfx_caracter.h"
#include "gfx_text.h"
#include "../basecode/image.h"
#include <cmath>
#include <iostream>
#include <sstream>

using namespace std;

demo::gfx::caracter::caracter(surface *surface)
{
	s = surface;
	width = surface->get_width();
	height = surface->get_height();
	
	// Load frames
	total_frames = 24;
	rp = new cha[total_frames];
	for(int i = 0; i < total_frames; i++)
	{
		string lo = "../data/textures/remedy-pingu-anim/remedy-pingu-";
		stringstream ss;
		ss << i;
		lo += ss.str();
		lo += ".png";
		rp[i].p = load_png(lo.c_str());
	}
}

void demo::gfx::caracter::draw(long time, pixel *p)
{
	static long ttime = time;
	static int cnt = 0;
		
	if(ttime + 250 < time)
	{
		ttime = time;
		if(cnt == total_frames-1)
			cnt=0;
		cnt++;
	}

	draw_frame(p, rp[cnt].p, 100, height-256);	
}


void demo::gfx::caracter::draw_frame(pixel *p, pixel *frame, int xp, int yp)
{
	for(int y = 0; y < 256; y++)
	{
		for(int x = 0; x < 256; x++)
		{
			p[(int)(xp+x) + (int)(yp+y)*width] = frame[x + y * 256];
		}
	}
}

void demo::gfx::caracter::draw_line(pixel *p, int x1, int y1, int x2, int y2)
{
	int dx  = x2 - x1,
		dy  = y2 - y1,
		y   = y1,
		eps = 0;
    
	int x;
	for(x = x1; x <= x2; x++)
	{
		p[(int)(x) + (int)(y)*width] = (int)(255<<16)+(int)(255<<8)+255;
        eps += dy;
		if((eps << 1) >= dx) {
			y++;
			eps -= dx;
		}
	}
	for(int i = 0; i < dy-dx; i++)
	{
		p[(int)(x) + (int)(y)*width] = (int)(255<<16)+(int)(255<<8)+255;
        eps += dy;
		if((eps << 1) >= dx) {
			y++;
			eps -= dx;
		}
	}
}
