/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "video.h"
#include "sdl.h"
#include <iostream>

using namespace std;

#define WINDOW_TITLE "xAngle - xa-002: Scratch"

class screen_abstraction : public demo::surface
{
public:
	screen_abstraction(int _w, int _h) : w(_w) , h(_h) , p(_w)
	{
		pixels = new demo::pixel[w*h];
	}
	virtual ~screen_abstraction()
	{
		delete [] pixels;
	}
	demo::locked_rectangle lock_rectangle(const demo::rectangle *rect)
	{
		demo::locked_rectangle lrect;
		if(rect == 0) {
			lrect.x = 0;
			lrect.y = 0;
			lrect.h = h;
			lrect.pitch = p;
			lrect.pixels = pixels;
			lrect.w = w;
		}
		else {
		lrect.h=((rect->y+rect->h)>rect->y+h)?(h-rect->y):(rect->h);
		lrect.w = ((rect->x + rect->w)>rect->x+w)?(w-rect->x):(rect->w);
		lrect.x = rect->x;
		lrect.y = rect->y;
		lrect.pitch = p;
		lrect.pixels = pixels+rect->x+(rect->y * w);
		}
		return lrect;
	}
	void unlock_rectangle(){}
	int get_width(){return w;}
	int get_height(){return h;}
private:
	int w,h,p;
	demo::pixel *pixels;

};

demo::video::video(int w,int h,int bpp,bool fullscreen)
{
	screen = new screen_abstraction(w,h);

	// Init SDL
	if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_TIMER) < 0) {
		cerr << "Unable to init SDL: " <<  SDL_GetError() << endl;
		exit(1);
	}
	
	// Fetch the video info
    const SDL_VideoInfo *video_info;
	if(!(video_info = SDL_GetVideoInfo())) {
		cerr << "Video query failed: " << SDL_GetError() << endl;
		exit(1);
	}
    	
	int flags = SDL_HWPALETTE;
    if(video_info->hw_available)
		flags |= SDL_HWSURFACE;
    else
		flags |= SDL_SWSURFACE;

	// Check if hardware blits can be done
   	if(video_info->blit_hw)
		flags |= SDL_HWACCEL;

	if(fullscreen) {
		flags |= SDL_FULLSCREEN;
		SDL_ShowCursor(0);
	}
		
	// Create the screen
	if(!(sdl_screen = SDL_SetVideoMode(w, h, bpp, flags))) {		
		cerr << "Video mode set failed: " <<  SDL_GetError() << endl;
		exit(1);
	}
	SDL_WM_SetCaption(WINDOW_TITLE, NULL);
}

void demo::video::update()
{
	// Copy
	SDL_LockSurface(sdl_screen);
	pixel *p = screen->lock_rectangle(0).pixels;
	int width = screen->get_width();
	int height = screen->get_height();
	for(int y = 0; y < height; y++)
		for(int x = 0; x < width; x++)
			((Uint32*)sdl_screen->pixels)
					[x + y * sdl_screen->pitch/sizeof(pixel)] =
					p
					[x + (y*width)];
	
	// memcpy gives about the same fps, but the music gets laggy
	//memcpy(sdl_screen->pixels, screen->lock_rectangle(0).pixels,
		//screen->get_width() * screen->get_height() * sizeof(pixel));
	SDL_UnlockSurface(sdl_screen);
	screen->unlock_rectangle();

	// Update
	static SDL_Rect dest;
	dest.w = screen->get_width();
	dest.h = screen->get_height();
	dest.x = 0;
	dest.y = 0;
	SDL_UpdateRect(sdl_screen, dest.x, dest.y, dest.w, dest.h);
}

demo::surface* demo::video::get_screen640()
{
	return screen;
}

demo::video::~video()
{
	delete screen;
}
