/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "image.h" 
#include <png.h>
#include "support.h"
#include <cstdio>
#include <iostream>

using namespace std;
using namespace demo;

pixel *demo::load_png(const char *file)
{
	int x, y;
	int width, height;
	int num_pass;
	png_byte bit_depth;
	png_byte color_type;
	png_structp png_ptr;
	png_infop info_ptr;
	png_bytep *row_pointers;
	png_byte header[8];
	
	// Open file and check that it is a png
	FILE *fp = fopen(file, "rb");
	if (!fp) {
		string err = (string) "[c_img_png::read] File " + file +
			"could not be opened for reading.";
		error(err.c_str());
	}
	fread(header, 1, 8, fp);
	
	if(png_sig_cmp(header, 0, 8)) {
		string err = (string) "[c_img_png::read] File " + file
			+ " is not recognized as a PNG file ";
		error(err.c_str());
	}

	// Initialize
	png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	
	if(!png_ptr)
		error("[c_img_png::read] png_create_read_struct failed.");

	info_ptr = png_create_info_struct(png_ptr);
	if (!info_ptr)
		error("[c_img_png::read] png_create_info_struct failed");

	if (setjmp(png_jmpbuf(png_ptr)))
		error("[c_img_png::read] Error during init_io");

	png_init_io(png_ptr, fp);
	png_set_sig_bytes(png_ptr, 8);

	png_read_info(png_ptr, info_ptr);

	width = info_ptr->width;
	height = info_ptr->height;
	color_type = info_ptr->color_type;
	bit_depth = info_ptr->bit_depth;

	num_pass = png_set_interlace_handling(png_ptr);
	png_read_update_info(png_ptr, info_ptr);


	// Read file
	if(setjmp(png_jmpbuf(png_ptr)))
		error("[c_img_png::read] Error during read_image");
	
	// Allocate temporary memory
	row_pointers = (png_bytep*) malloc(sizeof(png_bytep) * height);
	for (y=0; y<height; y++)
		row_pointers[y] = (png_byte*) malloc(info_ptr->rowbytes);

	// Read image
	png_read_image(png_ptr, row_pointers);

	// Get surface
	pixel *surface = new pixel[width * height];
	
	// Copy the color info into the surface 
	for (y=0; y<height; y++) {
		png_byte* row = row_pointers[y];
		for (x=0; x<width; x++) {
			png_byte* ptr = &(row[x*3]);
			surface[x+y*width] = (ptr[0]<<16) + (ptr[1]<<8) + (ptr[2]);
		}
	}
	
	// Free temporary memory
	delete [] row_pointers;
	return surface;
}
