/*  xAngle - xa-002: Scratch
 *  Copyright (C) Joakim Kolsj, Johan Larsson, Anders Asplund 2003
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef CONFIG
#define CONFIG

#include "global.h"

namespace demo
{
 	class config {
	public:
		config() { width = 640; height = 480; bpp = 32; 
					 vol = 128; samplerate = 44100; 
		#ifndef DEBUG
			sound = true;
			fullscreen = true;
		#endif
			
		#ifdef DEBUG
			sound = false;
			fullscreen = false;
			scene = -1; 
		#endif
		}

		int get_width() { return width;  };
		int get_height() { return height; };
		int get_bpp() { return bpp; };
		int get_fullscreen() { return fullscreen; };
		int get_sound() { return sound; };
		int get_vol() { return vol; };
		int get_samplerate() { return samplerate; };
#ifdef DEBUG
		int get_scenetotal() { return scenetotal; };
		int get_scene() { return scene; };
#endif	
		void set_width(int w) { width = w; };
		void set_height(int h) { height = h; };
		void set_bpp(int b) { bpp = b; };
		void set_fullscreen(int fs) { fullscreen = fs; };
		void set_sound(int s) { sound = s; };
		void set_vol(int v) { vol = v; };
		void set_samplerate(int sr) { samplerate = sr; };
#ifdef DEBUG
		void set_scenetotal(int st) { scenetotal = st; };
		void set_scene(int sc) { scene = sc; };
#endif
	private:
		int width, height, bpp, vol, samplerate;
#ifdef DEBUG
		int	scenetotal, scene;
#endif
		bool sound, fullscreen;
	};
}
#endif
