///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <shared/ThCore.h>
#include <shared/ThMemory.h>
#include <shared/ThTimer.h>
#include <shared/ThError.h>
#include <shared/ThServer.h>

#include <windows.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

void startSystemMessageLoop(unsigned int listenerID)
{
	MSG msg;

	bool stopped = false;

	while (!stopped)
	{
		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
				stopped = true;

			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

		Server->sendMessage(THMSG_SERVER_UPDATE, THID_SERVER, THID_SERVER);

		if (listenerID != THID_INVALID)
		{
			if (stopped)
				Server->sendMessage(THMSG_SERVER_STOP, listenerID, THID_SERVER);
			else
				Server->sendMessage(THMSG_SERVER_UPDATE, listenerID, THID_SERVER);
		}
	}
}

void stopSystemMessageLoop(void)
{
	PostQuitMessage(0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////
