///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <shared/ThCore.h>
#include <shared/ThTimer.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

// ThTimer constructors ---------------------------------------------------------------------------

ThTimer::ThTimer(void):
	m_paused(false),
	m_startTime(0.0)
{
}

ThTimer::~ThTimer(void)
{
}

// ThTimer methods --------------------------------------------------------------------------------

void ThTimer::start(void)
{
	stop();

	m_startTime = getCurrentTime();
}

void ThTimer::stop(void)
{
	m_paused    = false;
	m_startTime = 0.0;
}

void ThTimer::pause(void)
{
	THASSERT(m_startTime != 0.f, "Cannot pause a stopped timer.");

	// store expired seconds until resume
	m_startTime = getCurrentTime() - m_startTime;

	m_paused = true;
}

void ThTimer::resume(void)
{
	THASSERT(m_startTime != 0.f, "Cannot resume a stopped timer.");

	// restore base time after pause
	m_startTime = getCurrentTime() - m_startTime;

	m_paused = false;
}

// ThTimer attributes -----------------------------------------------------------------------------

bool ThTimer::isStarted(void) const
{
	return m_startTime != 0.0;
}

bool ThTimer::isPaused(void) const
{
	return m_paused;
}

float ThTimer::getTime(void) const
{
	if (m_startTime)
	{
		if (m_paused)
			return (float) m_startTime;
		else
			return (float) (getCurrentTime() - m_startTime);
	}
	else
		return 0.f;
}

void ThTimer::setTime(float time)
{
	if (m_startTime)
	{
		if (m_paused)
			m_startTime = time;
		else
			m_startTime += getTime() - time;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////
