///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THSTREAM_H
#define THERESA_THSTREAM_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThBlockStream : public IThStream, public IThDynamicBlock
{
public:
// constructors
																		ThBlockStream(unsigned int size);
																		~ThBlockStream(void);
// methods
	unsigned int											read(void* data, unsigned int size);
	unsigned int											write(const void* data, unsigned int size);
	void*															lock(void);
	void															unlock(void);
	void															allocate(unsigned int size);
	void															resize(unsigned int size);
	void															release(void);
// attributes
	bool															isEOF(void) const;
	bool															isReadable(void) const;
	bool															isWritable(void) const;
	unsigned int											getSize(void) const;
	unsigned int											getPosition(void) const;
	bool															setPosition(unsigned int position);
private:
// data
	ThByteBlock												m_data;
	unsigned int											m_size;
	unsigned int											m_locks;
	unsigned int											m_position;
};

//-------------------------------------------------------------------------------------------------

class ThAggregateStream : public IThStream
{
public:
// constructors
																		ThAggregateStream(IThStream* inner);
																		~ThAggregateStream(void);
// methods
	unsigned int											read(void* data, unsigned int size);
	unsigned int											write(const void* data, unsigned int size);
// attributes
	bool															isEOF(void) const;
	bool															isReadable(void) const;
	bool															isWritable(void) const;
	unsigned int											getSize(void) const;
	unsigned int											getPosition(void) const;
	bool															setPosition(unsigned int position);
private:
// data
	IThStream*												m_inner;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THSTREAM_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
