///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THSERVER_H
#define THERESA_THSERVER_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThMessage : public IThMessage, public ThListItem<ThMessage>
{
public:
// constructors
																		ThMessage(unsigned int message, unsigned int toID, unsigned int fromID);
																		ThMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data, unsigned int size);
// attributes
	unsigned int											getMessage(void) const;
	unsigned int											getToID(void) const;
	unsigned int											getFromID(void) const;
	const void*												getData(void) const;
	unsigned int											getSize(void) const;
private:
// data
	unsigned int											m_message;
	unsigned int											m_toID;
	unsigned int											m_fromID;
	ThByteBlock												m_data;
};

//-------------------------------------------------------------------------------------------------

class ThServer : public IThServer
{
public:
// constructors
																		ThServer(void);
																		~ThServer(void);
// methods
	bool															open(void);
	void															close(void);
// interface methods
	void															sendMessage(unsigned int message, unsigned int toID, unsigned int fromID);
	void															sendMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data, unsigned int size);
	void															postMessage(unsigned int message, unsigned int toID, unsigned int fromID);
	void															postMessage(unsigned int message, unsigned int toID, unsigned int fromID, const void* data, unsigned int size);
// interface object methods
	unsigned int											createObjectID(void);
	bool															registerObject(ThServerObject* object);
	ThServerObject*										findObject(unsigned int id);
private:
// methods
	void															sendMessage(const IThMessage* message);
	void															receive(const IThMessage* message);
// data
	unsigned int											m_nextID;
	ThList<ThMessage>									m_messages;
	ThList<ThServerObject>						m_objects;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THSERVER_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
