///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THMEMORY_H
#define THERESA_THMEMORY_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThStaticBlock : public IThStaticBlock
{
public:
// constructors
																		ThStaticBlock(void* data, unsigned int size);
	virtual														~ThStaticBlock(void);
// interface methods
	virtual void*											lock(void);
	virtual void											unlock(void);
// interface attributes
	virtual unsigned int							getSize(void) const;
private:
// data
	bool															m_attached;
	char*															m_data;
	unsigned int											m_size;
	unsigned int											m_locks;
};

//-------------------------------------------------------------------------------------------------

class ThDynamicBlock : public IThDynamicBlock
{
public:
// constructors
																		ThDynamicBlock(unsigned int size);
	virtual														~ThDynamicBlock(void);
// interface methods
	virtual void*											lock(void);
	virtual void											unlock(void);
	virtual void											allocate(unsigned int size);
	virtual void											resize(unsigned int size);
	virtual void											release(void);
// interface attributes
	virtual unsigned int							getSize(void) const;
private:
// data
	ThByteBlock												m_data;
	unsigned int											m_locks;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THMEMORY_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
