///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THEFFECT_H
#define THERESA_THEFFECT_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThEffect : public IThEffect, public ThServerObject
{
public:
// constructors
																		ThEffect(void);
																		~ThEffect(void);
// methods
	bool															open(IThDisplay* display);
	void															close(void);
// interface object methods
	bool															registerType(ThEffectType* type);
	ThEffectObject*										createObject(const char* objectName, const char* typeName, unsigned int layerID = THLAYER_INVALID);
// interface event methods
	void															registerCreateEvent(float time, const char* objectName, const char* typeName);
	void															registerCreateEvent(unsigned char sync, const char* objectName, const char* typeName);
	void															registerDeleteEvent(float time, const char* objectName);
	void															registerDeleteEvent(unsigned char sync, const char* objectName);
	void															registerNotifyEvent(float time, const char* objectName, const char* attributeName, const char* value);
	void															registerNotifyEvent(unsigned char sync, const char* objectName, const char* attributeName, const char* value);
	void															registerStopEvent(float time);
	void															registerStopEvent(unsigned char sync);
private:
// classes
	class Event;
// methods
	void															registerTimeEvent(Event* event);
	void															triggerEvent(Event* event);
	ThEffectType*											findType(const char* name);
	ThEffectObject*										findObject(const char* name);
// callbacks
	bool															receive(const IThMessage* message);
// data
	ThList<ThEffectType>							m_types;
	ThList<ThEffectObject>						m_objects;
	ThList<Event>											m_timeEvents;
	ThList<Event>											m_syncEvents;
	ThPtr<IThSymbolTable>							m_symbols;
	ThPtr<IThSyntax>									m_syntax;
	float															m_time;
	IThDisplay*												m_display;
};

//-------------------------------------------------------------------------------------------------

class ThEffect::Event : public ThListItem<Event>
{
public:
// constructors
																		Event(unsigned int type, float time);
																		Event(unsigned int type, unsigned char value);
// constants
	enum
	{
		CREATE,
		DELETE,
		NOTIFY,
		STOP,
	};
// data
	unsigned int											m_type;
	float															m_time;
	unsigned char											m_sync;
	ThString													m_objectName;
	ThString													m_typeName;
	ThString													m_attributeName;
	ThString													m_attributeValue;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THEFFECT_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
