///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_THDISPLAY_H
#define THERESA_THDISPLAY_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThSurface;
class ThTexture;
class ThDisplayList;
class ThCanvas;
class ThTextureCanvas;
class ThContextCanvas;
class ThDisplay;

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThSurface : public IThSurface, public ThListItem<ThSurface>
{
public:
// constructors
																		ThSurface(unsigned int width, unsigned int height, unsigned int type, unsigned int format, const char* name);
																		~ThSurface(void);
// interface methods
	void*															lock(void);
	void															unlock(void);
// interface attributes
	unsigned int											getWidth(void) const;
	unsigned int											getHeight(void) const;
	unsigned int											getType(void) const;
	unsigned int											getFormat(void) const;
	const char*												getName(void) const;
	unsigned int											getHash(void) const;
private:
// data
	ThPtr<IThStaticBlock>							m_data;
	unsigned int											m_width;
	unsigned int											m_height;
	unsigned int											m_type;
	unsigned int											m_format;
	ThString													m_name;
	unsigned int											m_hash;
};

//-------------------------------------------------------------------------------------------------

class ThTexture : public IThTexture, public ThListItem<ThTexture>
{
public:
// constructors
																		ThTexture(unsigned int texture, unsigned int width, unsigned int height, unsigned int format, const char* name);
																		~ThTexture(void);
// interface methods
	void															apply(void);
// interface attributes
	unsigned int											getWidth(void) const;
	unsigned int											getHeight(void) const;
	unsigned int											getFormat(void) const;
	const char*												getName(void) const;
	unsigned int											getHash(void) const;
private:
// data
	unsigned int											m_texture;
	unsigned int											m_width;
	unsigned int											m_height;
	unsigned int											m_format;
	ThString													m_name;
	unsigned int											m_hash;
};

//-------------------------------------------------------------------------------------------------

class ThDisplayList : public IThDisplayList, public ThListItem<ThDisplayList>
{
public:
// constructors
																		ThDisplayList(unsigned int list);
																		~ThDisplayList(void);
// methods
	void															begin(void);
	void															end(void);
	void															render(void);
private:
// data
	unsigned int											m_list;
};

//-------------------------------------------------------------------------------------------------

class ThCanvas : public ThListItem<ThCanvas>
{
};

//-------------------------------------------------------------------------------------------------

class ThTextureCanvas : public IThCanvas, public ThCanvas
{
public:
// constructors
																		ThTextureCanvas(IThTexture* texture);
																		~ThTextureCanvas(void);
// methods
	void															apply(void);
	void															update(void);
// attributes
	unsigned int											getWidth(void) const;
	unsigned int											getHeight(void) const;
private:
// data
	IThTexture*												m_texture;
};

//-------------------------------------------------------------------------------------------------

class ThVirtualCanvas : public IThCanvas, public ThCanvas
{
public:
// constructors
																		ThVirtualCanvas(unsigned int width, unsigned int height);
																		~ThVirtualCanvas(void);
// methods
	void															apply(void);
	void															update(void);
// attributes
	unsigned int											getWidth(void) const;
	unsigned int											getHeight(void) const;
private:
// data
	unsigned int											m_width;
	unsigned int											m_height;
};

//-------------------------------------------------------------------------------------------------

class ThContextCanvas : public IThCanvas, public ThCanvas
{
public:
// constructors
																		ThContextCanvas(void);
																		~ThContextCanvas(void);
// methods
	bool															open(IThContext* context);
	void															close(void);
// interface methods
	void															apply(void);
	void															update(void);
// interface attributes
	unsigned int											getWidth(void) const;
	unsigned int											getHeight(void) const;
private:
// data
	IThContext*												m_context;
};

//-------------------------------------------------------------------------------------------------

class ThDisplay : public IThDisplay, public ThServerObject
{
public:
// constructors
																		ThDisplay(void);
																		~ThDisplay(void);
// methods
	bool															open(const ThContextMode* mode);
	void															close(void);
// interface methods
	IThSurface*												createSurface(const char* fileName);
	IThSurface*												createSurface(unsigned int width, unsigned int height, unsigned int type, unsigned int format, const char* name = NULL);
	IThSurface*												createSurface(IThStream* stream, const char* name = NULL);
	IThSurface*												findSurface(const char* name);
	IThSurface*												findSurface(unsigned int hash);
	IThTexture*												createTexture(const char* fileName, unsigned int format, unsigned int flags = 0);
	IThTexture*												createTexture(IThStream* stream, unsigned int format, unsigned int flags = 0, const char* name = NULL);
	IThTexture*												createTexture(IThSurface* surface, unsigned int format, unsigned int flags = 0, const char* name = NULL);
	IThTexture*												findTexture(const char* name);
	IThTexture*												findTexture(unsigned int hash);
	IThDisplayList*										createDisplayList(void);
	IThTexture*												createCanvasTexture(unsigned int width, unsigned int height, const char* name = NULL);
	IThCanvas*												createTextureCanvas(IThTexture* texture);
	IThCanvas*												createVirtualCanvas(unsigned int width, unsigned int height);
// object interface methods
	bool															registerLayer(unsigned int id);
	bool															registerObject(ThDisplayObject* object, unsigned int layerID);
	void															renderObjects(IThCanvas* target = NULL, unsigned int layerID = THLAYER_INVALID);
	void															releaseObjects(void);
// interface attributes
	IThContext*												getContext(void);
	IThTexture*												getDefaultTexture(void);
	IThCanvas*												getDefaultCanvas(void);
private:
// classes
	class Layer;
// methods
	Layer*														findLayer(unsigned int id);
	void															renderLayer(Layer* layer, IThCanvas* target);
// callbacks
	bool															receive(const IThMessage* message);
// data
	bool															m_windowed;
	ThPtr<IThContext>									m_context;
	ThPtr<ThContextCanvas>						m_canvas;
	ThList<ThCanvas>									m_canvases;
	ThList<ThSurface>									m_surfaces;
	ThList<ThDisplayList>							m_displayLists;
	ThList<ThTexture>									m_textures;
	ThList<Layer>											m_layers;
};

//-------------------------------------------------------------------------------------------------

class ThDisplay::Layer : public ThListItem<Layer>
{
public:
// constructors
																		Layer(unsigned int id);
// data
	unsigned int											m_id;
	ThList<ThDisplayObject>						m_objects;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_THDISPLAY_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
