///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <shared/ThCore.h>

#if THERESA_WGL
	#include <theresa/WGL/ThCore.h>
#elif THERESA_AGL
	#include <theresa/AGL/ThCore.h>
#elif THERESA_GLX
	#include <theresa/GLX/ThCore.h>
#endif

#if HAVE_STDIO_H
	#include <stdio.h>
#endif

#if HAVE_STDLIB_H
	#include <stdlib.h>
#endif

#if HAVE_STRING_H
	#include <string.h>
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////

// ThException constructors -----------------------------------------------------------------------

ThException::ThException(const char* message, const char* fileName, unsigned int line):
	m_message(message),
	m_fileName(fileName),
	m_line(line)
{
}

// ThException attributes -------------------------------------------------------------------------

const char* ThException::getMessage(void) const
{
	return m_message;
}

const char* ThException::getFileName(void) const
{
	return m_fileName;
}

unsigned int ThException::getLine(void) const
{
	return m_line;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

// IThCriticalSection constructors ----------------------------------------------------------------

IThCriticalSection::~IThCriticalSection(void)
{
}

// IThCriticalSection static methods --------------------------------------------------------------

IThCriticalSection* IThCriticalSection::createInstance(void)
{
	ThCriticalSection* section = new ThCriticalSection();
	
	if (!section->open())
	{
		delete section;
		return NULL;
	}
		
	return section;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

// IThMutex constructors --------------------------------------------------------------------------

IThMutex::~IThMutex(void)
{
}

// IThMutex static methods ------------------------------------------------------------------------

IThMutex* IThMutex::createInstance(void)
{
	ThMutex* mutex = new ThMutex();

	if (!mutex->open())
	{
		delete mutex;
		return NULL;
	}

	return mutex;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
