///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////

#include <shared/ThCore.h>
#include <shared/ThMemory.h>
#include <shared/ThString.h>
#include <shared/ThError.h>
#include <shared/ThServer.h>
#include <shared/ThContext.h>

#include <GL/glx.h>

#include <Theresa/GLX/ThContext.h>

///////////////////////////////////////////////////////////////////////////////////////////////////

bool enumerateResolutions(ThList<ThResolution>& resolutions)
{
	// TODO: enumerate resolutions!

	return false;
}

bool requestContextMode(ThContextMode& contextMode)
{
	// TODO: request user selection!

	contextMode.set(ThResolution(THCONTEXT_DEFAULTWIDTH, THCONTEXT_DEFAULTHEIGHT, THCONTEXT_DEFAULTDEPTH, THCONTEXT_DEFAULTWINDOWED), THCONTEXT_DEFAULTDEPTH, 0, THCONTEXT_DEFAULTDEPTH);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////

// ThContext constructors -------------------------------------------------------------------------

ThContext::ThContext(void):
	ThServerObject(THID_CONTEXT)
{
	m_display = NULL;
	m_window  = NULL;
	m_context = NULL;

	m_mode.m_resolution.m_windowed = true;
}

ThContext::~ThContext(void)
{
	close();
}

// ThContext methods ------------------------------------------------------------------------------

bool ThContext::open(const ThContextMode& mode, unsigned int listenerID)
{
	close();

	int attributes[20];
	unsigned int index = 0;

	m_display = XOpenDisplay("");
	if (!m_display)
		return false;
	
	attributes[index++] = GLX_USE_GL;
	attributes[index++] = GLX_DEPTH_SIZE;
	attributes[index++] = 1;
	attributes[index++] = GLX_RGBA;
	attributes[index++] = GLX_RED_SIZE;
	attributes[index++] = 1;
	attributes[index++] = GLX_GREEN_SIZE;
	attributes[index++] = 1;
	attributes[index++] = GLX_BLUE_SIZE;
	attributes[index++] = 1;
	attributes[index++] = None;
	
	/*
	XVisualInfo *vinfo;
	XSetWindowAttributes swattr;
	
	vinfo = glXChooseVisual(m_display, DefaultScreen(display), attributes);
	if (vinfo == NULL)
	{
		Error->display("Context", "Cannot open X11 window.");
		return false;
	}
	
	swattr.colormap = XCreateColormap(display, RootWindow(display, vinfo->screen), vinfo->visual, AllocNone);
	swattr.background_pixel = BlackPixel(display, vinfo->screen);
	swattr.border_pixel = BlackPixel(display, vinfo->screen);
	
	wid = XCreateWindow(display, RootWindow(display, vinfo->screen), 30, 30, width, height, 0, vinfo->depth, CopyFromParent, vinfo->visual,CWBackPixel | CWBorderPixel | CWColormap, &swattr);
	
	context = glXCreateContext(display, vinfo, NULL, True);
	if (context == NULL)
	{
		Error->display("Context", "Cannot create OpenGL context.");
		return false;
	}
	
	if (!glXMakeCurrent(display, wid, context))
	{
		Error->display("Context", "Cannot activate OpenGL context.");
		return false;
	}
	*/

	// reset matrices
	{
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	}

	// list extensions
	{
		if (const char* extensions = (const char*) glGetString(GL_EXTENSIONS))
		{
			ThString extension;

			while (extensions = extension.copyToken(extensions))
				m_extensions.attachFirst(new ThStringItem(extension));
		}
	}

	m_mode       = mode;
	m_listenerID = listenerID;

	setTitle("");

	return true;
}

void ThContext::close(void)
{
	// TODO: release rendering context!
	// TODO: release window!

	m_mode.reset();
	m_mode.m_resolution.m_windowed = true;
}

// ThContext interface methods --------------------------------------------------------------------

void ThContext::apply(void)
{
	// TODO: apply rendering context!
}

void ThContext::update(void)
{
	glFinish();

	if (unsigned int error = glGetError())
	{
		if (!Error->request("Context", "OpenGL reported an error during update.%s%s", THERESA_NEWLINE, gluErrorString(error)))
			Server->postMessage(THMSG_REQUEST_EXIT, THID_ANNOUNCE, THID_CONTEXT);
	}

	// TODO: update rendering context!
}

// ThContext interface extension methods ----------------------------------------------------------

bool ThContext::findExtension(const char* name) const
{
	if (m_extensions.findNoCase(name))
		return true;

	return false;
}

ThEntryPoint ThContext::findEntryPoint(const char* name) const
{
	// TODO: retrieve extension entry point!

	return (ThEntryPoint) NULL;
}

// ThContext interface attributes -----------------------------------------------------------------

const char* ThContext::getTitle(void) const
{
	return m_title;
}

void ThContext::setTitle(const char* title)
{
	m_title = title;

	ThString caption;

	caption = title;
	if (!caption.isEmpty())
		caption.append(" - ");

	caption.append("Theresa");

	// TODO: set window title!
}

unsigned int ThContext::getWidth(void) const
{
	return m_mode.m_resolution.m_width;
}

unsigned int ThContext::getHeight(void) const
{
	return m_mode.m_resolution.m_height;
}

const ThContextMode& ThContext::getMode(void) const
{
	return m_mode;
}

// ThContext callbacks ----------------------------------------------------------------------------

bool ThContext::recieve(const IThMessage* message)
{
	return ThServerObject::recieve(message);
}

///////////////////////////////////////////////////////////////////////////////////////////////////
