///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef THERESA_GLX_THCONTEXT_H
#define THERESA_GLX_THCONTEXT_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThContext : public IThContext, public ThServerObject
{
public:
// constructors
																		ThContext(void);
																		~ThContext(void);
// methods
	bool															open(const ThContextMode& mode, unsigned int listenerID);
	void															close(void);
// interface methods
	void															apply(void);
	void															update(void);
// interface extension methods
	bool															findExtension(const char* name) const;
	ThEntryPoint											findEntryPoint(const char* name) const;
// interface attributes
	const char*												getTitle(void) const;
	void															setTitle(const char* title);
	unsigned int											getWidth(void) const;
	unsigned int											getHeight(void) const;
	const ThContextMode&							getMode(void) const;
private:
// callbacks
	bool															recieve(const IThMessage* message);
// data
	ThContextMode											m_mode;
	ThString													m_title;
	unsigned int											m_listenerID;
	ThStringList											m_extensions;
	Display*													m_display;
	Window														m_window;
	GLXContext												m_context;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* THERESA_GLX_THCONTEXT_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
