///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THSYSTEM_H
#define SHARED_THSYSTEM_H
///////////////////////////////////////////////////////////////////////////////////////////////////

/*! \fn bool initializeTheresa(int argc, char* argv[])
 *  Initializes the Theresa library and creates all singleton objects.
 *  \attention This must be called before \b any other system code.
 *  \return \c true if successful, or \c false if an error occurrs.
 */
bool initializeTheresa(int argc, char* argv[]);

/*! \fn void shutdownTheresa(void)
 *  Shuts down the Theresa library and releases all singleton objects.
 *  \attention This \b must be before exiting the application, if the library has been initialized.
 */
void shutdownTheresa(void);

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThApplication : public ThClient
{
public:
// constructors
																		ThApplication(void);
	virtual														~ThApplication(void);
// callbacks
	virtual bool											receive(const IThMessage* message);
	virtual bool											update(float deltaTime);
	virtual bool											render(IThCanvas* target);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class IThSystem
{
public:
// constructors
	virtual														~IThSystem(void);
// methods
	virtual bool											start(void) = 0;
	virtual void											stop(void) = 0;
	virtual void											pause(void) = 0;
	virtual void											resume(void) = 0;
// display methods
	virtual bool											openDisplay(const ThContextMode* mode = NULL) = 0;
	virtual void											closeDisplay(void) = 0;
// music methods
	virtual bool											openMusic(const char* fileName) = 0;
	virtual void											closeMusic(void) = 0;
// effect methods
	virtual bool											openEffect(void) = 0;
	virtual void											closeEffect(void) = 0;
// engine methods
	virtual bool											openEngine(void) = 0;
	virtual void											closeEngine(void) = 0;
// attributes
	virtual bool											isStarted(void) = 0;
	virtual bool											isPaused(void) = 0;
	virtual float											getTime(void) = 0;
	virtual void											setTime(float time) = 0;
	virtual IThDisplay*								getDisplay(void) = 0;
	virtual IThMusic*									getMusic(void) = 0;
	virtual IThEffect*								getEffect(void) = 0;
	virtual IThEngine*								getEngine(void) = 0;
// static methods
	static bool												create(void);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

extern ThSingleton<IThSystem> System;

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THSYSTEM_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
