///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THSTORAGE_H
#define SHARED_THSTORAGE_H
///////////////////////////////////////////////////////////////////////////////////////////////////

/*! \class IThStorage
 *	The storage interface. Represents a generic hierarchial file system.
 */
/*! \fn IThStorage::~IThStorage(void)
 *	Destructor.
 */
/*! \fn bool IThStorage::createFolder(const char* name)
 *	Creates a new folder in this storage.
 *	\param name [in] The name of the folder to create.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
/*! \fn bool IThStorage::destroyFolder(const char* name)
 *	Destroys an existing folder in this storage.
 *	\param name [in] The name of the folder to destroy.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
/*! \fn IThStream* IThStorage::createFile(const char* name)
 *	Creates a new file in this storage.
 *	\param name [in] The name of the file to create.
 *	\return A IThStream interface to the created file, or \c NULL if an error ocurrs.
 */
/*! \fn IThStream* IThStorage::openFile(const char* name)
 *	Opens an existing file in this storage.
 *	\param name [in] The name of the file to open.
 *	\return A IThStream interface to the opened file, or \c NULL if an error ocurrs.
 */
/*! \fn bool IThStorage::cacheFile(const char* name, ThByteBlock& data)
 *	Caches the specified file in memory.
 *	\param name The name of the file to chache.
 *	\param data The block to contain the cached data.
 *	\return \c true if the file was cached, or \c false if an error occurred.
 *	\remarks This is a helper method, and does not provide any unique functionality.
 */
/*!	\fn bool IThStorage::destroyFile(const char* name)
 *	Destroys an existing file in this storage.
 *	\param name [in] The name of the file to destroy.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
/*! \fn bool IThStorage::create(void)
 *	Creates the global storage singleton object.
 *	\return \c true if successful, or \c false if an error ocurrs.
 */
class IThStorage
{
public:
// constructors
	virtual														~IThStorage(void);
// folder methods
	virtual bool											createFolder(const char* name) = 0;
	virtual bool											destroyFolder(const char* name) = 0;
// file methods
	virtual IThStream*								createFile(const char* name) = 0;
	virtual IThStream*								openFile(const char* name) = 0;
	virtual bool											cacheFile(const char* name, ThByteBlock& data) = 0;
	virtual bool											destroyFile(const char* name) = 0;
// static methods
	static bool												create(const char* fileName = NULL, bool persistent = false);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

//! The global storage singleton object.
extern ThSingleton<IThStorage> Storage;

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THSTORAGE_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
