///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THPARTICLE_H
#define SHARED_THPARTICLE_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class ThParticle : public ThListItem<ThParticle>
{
public:
// data
	ThVector3													m_position;
	ThVector3													m_speed;
	ThVector4													m_color;
	ThVector2													m_size;
	float															m_lifeTime;
	float															m_timeLeft;
};

//-------------------------------------------------------------------------------------------------

class ThParticleEmitter
{
public:
// constructors
																		ThParticleEmitter(void);
// methods
	void															reset(void);
// data
	ThVector3													m_position;
	ThRange<float>										m_speed;
	ThVector3													m_vector;
	ThRange<float>										m_angle;
	ThVector3													m_accel;
	ThSpace<float, 4>									m_color;
	ThSpace<float, 2>									m_size;
	ThRange<float>										m_time;
	float															m_ratio;
};

//-------------------------------------------------------------------------------------------------

/*! \class ThParticleSystem
 *	Implements a base class for particle management and rendering.
 */
/*! \fn ThParticleSystem::ThParticleSystem(void)
 *	Default constructor.
 */
/*! \fn ThParticleSystem::~ThParticleSystem(void)
 *	Destructor.
 */
/*! \fn void ThParticleSystem::create(unsigned int count)
 *	Creates the specified number of new particles. The current emitter, and any currently existing particles are destroyed.
 *	\param count The number of particles to create.
 */
/*! \fn void ThParticleSystem::release(void)
 *	Destroys all existing particles.
 */
/*! \fn void ThParticleSystem::start(void)
 *	Starts the animation and rendering of the particles.
 */
/*! \fn void ThParticleSystem::stop(void)
 *	Stops the animation and rendering of the particles. All particles are reset and deactivated.
 */
/*! \fn void ThParticleSystem::pause(void)
 *	Pauses the animation and rendering of the particles.
 */
/*! \fn void ThParticleSystem::resume(void)
 *	Resumes the animation and rendering of the particles.
 */
/*! \fn bool ThParticleSystem::update(float deltaTime)
 */
/*! \fn bool ThParticleSystem::render(IThCanvas* target)
 */
class ThParticleSystem
{
public:
// constructors
																		ThParticleSystem(void);
	virtual														~ThParticleSystem(void);
// methods
	void															create(unsigned int count);
	void															release(void);
	void															start(void);
	void															stop(void);
	void															pause(void);
	void															resume(void);
	bool															update(float deltaTime);
	bool															render(IThCanvas* target);
// attributes
	bool															isStarted(void) const;
	bool															isPaused(void) const;
	bool															isBalanced(void) const;
	float															getTime(void) const;
	unsigned int											getParticleCount(void) const;
	ThParticle*												getFirstParticle(void);
	ThParticleEmitter*								getEmitter(void);
protected:
// callbacks
	virtual void											createParticle(ThParticle* particle);
	virtual bool											updateParticle(ThParticle* particle, float deltaTime);
	virtual void											renderParticle(ThParticle* particle);
private:
// data
	bool															m_started;
	bool															m_paused;
	float															m_counter;
	float															m_time;
	ThPtr<ThParticleEmitter>					m_emitter;
	ThBlock<ThParticle>								m_particles;
	ThList<ThParticle>								m_active;
	ThList<ThParticle>								m_passive;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THPARTICLE_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
