///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THMUSIC_H
#define SHARED_THMUSIC_H
///////////////////////////////////////////////////////////////////////////////////////////////////

class IThMusic
{
public:
// constructors
	virtual														~IThMusic(void);
// methods
	virtual void											start(void) = 0;
	virtual void											stop(void) = 0;
	virtual void											pause(void) = 0;
	virtual void											resume(void) = 0;
// attributes
	virtual bool											isStarted(void) const = 0;
	virtual bool											isPaused(void) const = 0;
	virtual float											getTime(void) const = 0;
	virtual bool											setTime(float time) = 0;
// static methods
	static IThMusic*									createInstance(IThStream* source);
};

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THMUSIC_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
