///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THEFFECT_HPP
#define SHARED_THEFFECT_HPP
///////////////////////////////////////////////////////////////////////////////////////////////////

// ThEffectTemplate constructors ------------------------------------------------------------------

template <typename T>
inline ThEffectTemplate<T>::ThEffectTemplate(const char* name):
	ThEffectType(name)
{
}

// ThEffectTemplate methods -----------------------------------------------------------------------

template <typename T>
inline ThEffectObject* ThEffectTemplate<T>::createObject(const char* name)
{
	ThPtr<T> object = new T(this, name);
	
	if (!object->open())
	{
		Error->display("Effect", "Effect '%s' of type '%s' failed to initialize.", name, getName());
		return NULL;
	}
	
	return object.detach();
}

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THEFFECT_HPP */
///////////////////////////////////////////////////////////////////////////////////////////////////
