///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Theresa core library
// Copyright (C) 2001 Camilla Drefvenborg <elmindreda@home.se>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef SHARED_THEFFECT_H
#define SHARED_THEFFECT_H
///////////////////////////////////////////////////////////////////////////////////////////////////

enum
{
	THATTR_INVALID,
	
	THATTR_CUSTOM_BASE = 1000,
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class ThEffectType : public ThListItem<ThEffectType>
{
public:
// constructors
																		ThEffectType(const char* name);
	virtual														~ThEffectType(void);
// methods
	virtual ThEffectObject*						createObject(const char* name) = 0;
// attribute methods
	bool															registerAttribute(const char* name, unsigned int id);
	unsigned int											translateAttribute(const char* name);
// attributes
	const char*												getName(void) const;
	unsigned int											getHash(void) const;
private:
// classes
	class Attribute;
// data
	ThString													m_name;
	unsigned int											m_hash;
	ThList<Attribute>									m_attributes;
};

//-------------------------------------------------------------------------------------------------

class ThEffectType::Attribute : public ThListItem<Attribute>
{
public:
// constructors
																		Attribute(const char* name, unsigned int id);
// data
	ThString													m_name;
	unsigned int											m_hash;
	unsigned int											m_id;
};

//-------------------------------------------------------------------------------------------------

template <typename T>
class ThEffectTemplate : public ThEffectType
{
public:
// constructors
	inline														ThEffectTemplate(const char* name);
// methods
	inline ThEffectObject*						createObject(const char* name);
};

//-------------------------------------------------------------------------------------------------

class ThEffectObject : public ThDisplayObject, public ThListItem<ThEffectObject>
{
public:
// constructors
																		ThEffectObject(ThEffectType* type, const char* name);
// callbacks
	virtual bool											update(float deltaTime);
	virtual bool											render(IThCanvas* target);
	virtual bool											notify(unsigned int attributeID, const char* value);
// attributes
	float															getLifeTime(void) const;
	void															setLifeTime(float lifeTime);
	float															getTimeLeft(void) const;
	float															getTimePast(void) const;
	const char* 											getName(void) const;
	unsigned int											getHash(void) const;
	ThEffectType*											getType(void) const;
private:
// data
	float															m_lifeTime;
	float															m_timeLeft;
	float															m_timePast;
	ThString													m_name;
	unsigned int											m_hash;
	ThEffectType*											m_type;
};

///////////////////////////////////////////////////////////////////////////////////////////////////

class IThEffect
{
public:
// constructors
	virtual														~IThEffect(void);
// object methods
	virtual bool											registerType(ThEffectType* type) = 0;
	virtual ThEffectObject*						createObject(const char* objectName, const char* typeName, unsigned int layerID = THLAYER_INVALID) = 0;
// event methods
	virtual void											registerCreateEvent(float time, const char* objectName, const char* typeName) = 0;
	virtual void											registerCreateEvent(unsigned char sync, const char* objectName, const char* typeName) = 0;
	virtual void											registerDeleteEvent(float time, const char* objectName) = 0;
	virtual void											registerDeleteEvent(unsigned char sync, const char* objectName) = 0;
	virtual void											registerNotifyEvent(float time, const char* objectName, const char* attributeName, const char* value) = 0;
	virtual void											registerNotifyEvent(unsigned char sync, const char* objectName, const char* attributeName, const char* value) = 0;
	virtual void											registerStopEvent(float time) = 0;
	virtual void											registerStopEvent(unsigned char sync) = 0;
// static methods
	static IThEffect*									createInstance(IThDisplay* display);
};

///////////////////////////////////////////////////////////////////////////////////////////////////

#include "ThEffect.hpp"

///////////////////////////////////////////////////////////////////////////////////////////////////
#endif /* SHARED_THEFFECT_H */
///////////////////////////////////////////////////////////////////////////////////////////////////
