
//
// Simple test shader
//

string RENDERPASS = "Solid";

// texture
texture Tex0 < string name="sala2.jpg"; >;
texture Tex1 < string name="sala2.jpg"; >;

float TheTime : TIME;

// transforms
float4x3 WorldView  : WORLDVIEW; 
float4x4 View  : VIEW; 
float4x4 Projection : PROJECTION;
float4x4 Env : SPHERICAL;

float3 LightDir = normalize(float3(0.0f, 0.0f, 1.0f));

// glow parameters
float4 GlowColor     = float4(0.5f, 0.2f, 0.2f, 1.0f);
float4 GlowAmbient   = float4(0.2f, 0.2f, 0.0f, 0.0f);
float  GlowThickness = 0.0515f;

float4 Linear(float2 Pos : POSITION) : COLOR
{
    return float4(Pos, Pos);
}

struct VSTEXTURE_OUTPUT
{
    float4 Position : POSITION;
    float4 Diffuse  : COLOR;
    float2 TexCoord : TEXCOORD0;
    float2 ReflCoord : TEXCOORD1;
};

// draws unskinned object with one texture and one directional light.
VSTEXTURE_OUTPUT VSTexture
    (
    float4 Position : POSITION, 
    float3 Normal   : NORMAL,
    float2 TexCoord : TEXCOORD0
    )
{
    VSTEXTURE_OUTPUT Out = (VSTEXTURE_OUTPUT)0;
  
    float3 L = -LightDir;                                   // light direction (view space)
    float3 P = mul(Position, WorldView);                    // position (view space)


    float3 N = normalize(mul(Normal, (float3x3)WorldView)); // normal (view space)

    P.x+=sin(P.y*1.3+TheTime)+cos(P.z*1.9+TheTime*1.2);

    Out.Position = mul(float4(P, 1), Projection);   // projected position
    Out.Diffuse  = max(0, dot(N, L));               // diffuse 
    Out.TexCoord = TexCoord;
    Out.ReflCoord=N*0.5+0.5;	
    
    return Out;    
}


technique Rubber
{

    pass PTexture
    {   
        VertexShader = compile vs_1_1 VSTexture();
        PixelShader  = NULL;
        
        Texture[0] = (Tex0);
        MinFilter[0] = LINEAR;
        MagFilter[0] = LINEAR;
        MipFilter[0] = POINT;
        ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = CURRENT;
        AlphaOp[0]   = DISABLE;
	TexCoordIndex[0] = 0;

        Texture[1] = (Tex1);
        MinFilter[1] = LINEAR;
        MagFilter[1] = LINEAR;
        MipFilter[1] = POINT;
        ColorOp[1]   = MODULATE;
        ColorArg1[1] = TEXTURE;
        ColorArg2[1] = CURRENT;
        AlphaOp[1]   = DISABLE;
	TexCoordIndex[1] = 1;

        ColorOp[2]   = DISABLE;
        AlphaOp[2]   = DISABLE;

	CullMode=CCW;

	ZWriteEnable=True;
	ZEnable=true;

	TextureTransform[0]=(Env);
	TexCoordIndex[0]=CameraSpaceNormal;
	TextureTransformFlags[0]=Count2;
        
    } 

   

}
