///////////////////////////////////////////////////////////////////////////////////
// A5 main wdl
////////////////////////////////////////////////////////////////////////////
// Files to over-ride:
// * logodark.bmp - the engine logo, include your game title
// * horizon.pcx - A horizon map displayed over the sky and cloud maps
////////////////////////////////////////////////////////////////////////////
// The PATH keyword gives directories where game files can be found,
// relative to the level directory
path "C:\\Archivos de programa\\GStudio\\template";	// Path to WDL templates subdirectory

////////////////////////////////////////////////////////////////////////////
// The INCLUDE keyword can be used to include further WDL files,
// like those in the TEMPLATE subdirectory, with prefabricated actions
include <movement.wdl>;
include <messages.wdl>;
include <menu.wdl>;		// must be inserted before doors and weapons
include <particle.wdl>; // remove when you need no particles
include <doors.wdl>;		// remove when you need no doors
include <actors.wdl>;   // remove when you need no actors
include <weapons.wdl>;  // remove when you need no weapons
include <war.wdl>;      // remove when you need no fighting
//include <venture.wdl>;	// include when doing an adventure
include <lflare.wdl>;   // remove when you need no lens flares

////////////////////////////////////////////////////////////////////////////
// The engine starts in the resolution given by the follwing vars.
var video_mode = 7;	 // screen size 640x480
var video_depth = 32; // 16 bit colour D3D mode

/////////////////////////////////////////////////////////////////
// Strings and filenames
// change this string to your own starting mission message.
string mission_str = "Fight your way through the level. Press [F1] for help";
string level_str = <terreno_alta.WMB>; // give file names in angular brackets

/////////////////////////////////////////////////////////////////
// define a splash screen with the required A4/A5 logo
bmap splashmap = <logodark.bmp>; // the default logo in templates
panel splashscreen {
	bmap = splashmap;
	flags = refresh,d3d;
}

//Definimos los bmp del estado del jugador

/*BMAP barraVida <barra_azul.BMP>;
BMAP contornoVida <contorno.BMP>;
BMAP zonaFija <fija.BMP>;
BMAP barraAmarilla <barra_amarilla.BMP>;*/
BMAP inicio <dibuinicio.bmp>;

BMAP fin <dibufin.bmp>;

sound sonidoFondo = <mutilBS.wav>;
BMAP barraAmarilla <barramarilla.bmp>;
BMAP barraVerde <barraverde.bmp>;
BMAP contorno <contorno.bmp>;
BMAP vida1 <vida1.bmp>;
BMAP vida2 <vida2.bmp>;
BMAP vida3 <vida3.bmp>;
BMAP vida75 <vida75%.bmp>;
BMAP bateria <bateria.bmp>;
BMAP vida25 <vida25%.bmp>;
BMAP vida50 <vida50%.bmp>;
BMAP vida100 <vida100%.bmp>;
BMAP barraRoja <barraroja.bmp>;

panel iniciar
{
	bmap=inicio;
	flags=refresh,d3d;
}

panel finalizar
{
	bmap=fin;
	flags=refresh,d3d;
}

panel hbar_mutil100
{
   hbar 126,20,124 barraAmarilla,1.24,100;	
   hbar 126,20,124 barraVerde,1.24,player._health;
   hbar 50,20,200 contorno,2,100;

	hbar 50,20,200 vida100,2,100;

   hbar 50,20,200 vida1,2,100;
  hbar 50,20,200 vida2,2,100;
     hbar 50,20,200 vida3,2,100;
 
   
 	
   pos_x=1;

	pos_y=480;
   layer = 2;
   FLAGS OVERLAY;
   FLAGS REFRESH;
}


panel hbar_mutil75
{
   hbar 126,20,124 barraAmarilla,1.24,100;	
   hbar 126,20,124 barraVerde,1.24,player._health;
   hbar 50,20,200 contorno,2,100;

	hbar 50,20,200 vida75,2,100;

   hbar 50,20,200 vida1,2,100;
  hbar 50,20,200 vida2,2,100;
     hbar 50,20,200 vida3,2,100;
 
   
 	
   pos_x=1;

	pos_y=480;
   layer = 2;
   FLAGS OVERLAY;
   FLAGS REFRESH;
}

panel hbar_mutil50
{
   hbar 126,20,124 barraAmarilla,1.24,100;	
   hbar 126,20,124 barraVerde,1.24,player._health;
   hbar 50,20,200 contorno,2,100;

	hbar 50,20,200 vida50,2,100;

   hbar 50,20,200 vida1,2,100;
  hbar 50,20,200 vida2,2,100;
     hbar 50,20,200 vida3,2,100;
 
   
 	
   pos_x=1;

	pos_y=480;
   layer = 2;
   FLAGS OVERLAY;
   FLAGS REFRESH;
}

panel hbar_mutil25
{
   hbar 126,20,124 barraAmarilla,1.24,100;	
   hbar 126,20,124 barraVerde,1.24,player._health;
   hbar 50,20,200 contorno,2,100;

	hbar 50,20,200 vida25,2,100;

   hbar 50,20,200 vida1,2,100;
  hbar 50,20,200 vida2,2,100;
     hbar 50,20,200 vida3,2,100;
 
   
 	
   pos_x=1;

	pos_y=480;
   layer = 2;
   FLAGS OVERLAY;
   FLAGS REFRESH;
}

font mi_font = <ackfont.pcx>,6,9;

panel bateriasTotal
{

	
	hbar 0,0,150 bateria,1.5,100;
	digits 0,10,3,mi_font,1,player.skill25;//cantidad de baterias

	pos_x=700;
	pos_y=10;
   FLAGS OVERLAY;
   FLAGS REFRESH;
}




function estado_jugador()
{

	if(finalizar.visible==on)
	{
	hbar_mutil100.visible = off;
	hbar_mutil75.visible = off;
	hbar_mutil50.visible = off;
	hbar_mutil25.visible = off;		
	}
	else
	{
	if(player._health>75)
	{
	hbar_mutil100.visible = ON;
	hbar_mutil75.visible = off;
	hbar_mutil50.visible = off;
	hbar_mutil25.visible = off;
	}
	if(player._health>50 && player._health<75)
	{
	hbar_mutil100.visible = off;
	hbar_mutil75.visible = on;
	hbar_mutil50.visible = off;
	hbar_mutil25.visible = off;
	}
	if(player._health>25 && player._health<50)
	{
	hbar_mutil100.visible = off;
	hbar_mutil75.visible = off;
	hbar_mutil50.visible = on;
	hbar_mutil25.visible = off;
	}
	if(player._health>=0 && player._health<25)
	{
	hbar_mutil100.visible = off;
	hbar_mutil75.visible = off;
	hbar_mutil50.visible = off;
	hbar_mutil25.visible = on;
	}
	}
}

////////////////////////////////////////////////////////////////////////////
// The following script controls the sky movement
bmap horizon_map = <horizon.pcx>;
// A backdrop texture's horizontal size must be a power of 2;
// the vertical size does not matter

function init_environment()
{
	scene_map = horizon_map;	// horizon backdrop overlay
	scene_nofilter = on;

	sky_speed.x = 1;
	sky_speed.y = 1.5;
	cloud_speed.x = 1.5;
	cloud_speed.y = 4.5;

	sky_scale = 1;
	sky_curve = 1;  			// 'steepness' of sky dome

	scene_field = 60;  		// repeat map 6 times
	scene_angle.tilt = -10; // lower edge of scene_map 10 units below horizon

	sky_clip = scene_angle.tilt;	// clip the sky at bottom of scene_map
}

//var angulo_viejo[3];
//Funcion  que mueve la camara
function mover_camara()
{

	if(player == null) { player = me; }	// this action needs the player pointer
	if(player == null) { return; }			// still no player -> can't work


	if ((_camera == 0) && (player != null))
	{

 		camera.DIAMETER = 300;		// make the camera passable
		camera_solidpass = 1;          //Hacemos que la camara pase de ser pasable
		camera.genius = player;
		camera.pan += 0.2 * ang(player.pan-camera.pan);

		// walking, swimming etc.
		camera.tilt +=(2*mouse_force.y);
//		camera.tilt=-11;

	  	if((person_3rd < 1) && (camera_dist.z == 0))	// switching to 3rd person
		{
			camera_dist.z = -(player.MAX_Z-player.MIN_Z)*eye_height_up;//- player.MAX_Z;
		}


		vec_set(temp,temp_cdist);      // temp = temp_cdist
		
		vec_rotate(temp,player.pan);
		
      camera.x += 0.3*(player.x - temp.x - camera.x);
      camera.y += 0.3*(player.y - temp.y - camera.y);
      camera.z += 0.3*(player.z - temp.z - camera.z);

 		
	//Controlamos el plano al jugador; si es 0 estariamos en los ojos
	
			temp_cdist.x += 0.2*(player.max_x + camera_dist.x - temp_cdist.x);
			temp_cdist.y += 0.2*(player.max_y + camera_dist.y - temp_cdist.y)-2.5;//corregimos el offset
										//y centramos el personaje
			temp_cdist.z += 0.2*(player.MAX_Z + camera_dist.z - temp_cdist.z)-5;

		

		person_3rd = 1; 	// fully 3rd person

	}

}

/////////////////////////////////////////////////////////////////
// The main() function is started at game start
function main()
{
// set some common flags and variables
//	warn_level = 2;	// announce bad texture sizes and bad wdl code
	tex_share = on;	// map entities share their textures

// center the splash screen for non-640x480 resolutions, and display it
	splashscreen.pos_x = (screen_size.x - bmap_width(splashmap))/2;
	splashscreen.pos_y = (screen_size.y - bmap_height(splashmap))/2;
	splashscreen.visible = on;
// wait 3 frames (for triple buffering) until it is flipped to the foreground
	wait(3);

// init the 'environment' (sky & sceen map)
	init_environment();
// now load the level
	level_load(level_str);
// freeze the game
	freeze_mode = 1;

// wait the required second, then switch the splashscreen off.
	waitt(16);
  	splashscreen.visible = off;
	bmap_purge(splashmap);	// remove splashscreen from video memory

// load some global variables, like sound volume
	load_status();

// display the initial message
	msg_show(mission_str,10);

// initialize lens flares when edition supports flares
ifdef CAPS_FLARE;
	lensflare_start();
endif;

// un-freeze the game
	freeze_mode = 0;

//	client_move();	// for a possible multiplayer game
// call further functions here...
turb_speed=0.1;


}


/////////////////////////////////////////////////////////////////
// The following definitions are for the pro edition window composer
// to define the start and exit window of the application.
WINDOW WINSTART
{
	TITLE			"3D GameStudio";
	SIZE			480,320;
	MODE			IMAGE;	//STANDARD;
	BG_COLOR		RGB(240,240,240);
	FRAME			FTYP1,0,0,480,320;
//	BUTTON		BUTTON_START,SYS_DEFAULT,"Start",400,288,72,24;
	BUTTON		BUTTON_QUIT,SYS_DEFAULT,"Abort",400,288,72,24;
	TEXT_STDOUT	"Arial",RGB(0,0,0),10,10,460,280;
}

/* no exit window at all..
WINDOW WINEND
{
	TITLE			"Finished";
	SIZE			540,320;
	MODE	 		STANDARD;
	BG_COLOR		RGB(0,0,0);
	TEXT_STDOUT	"",RGB(255,40,40),10,20,520,270;

	SET FONT		"",RGB(0,255,255);
	TEXT			"Any key to exit",10,270;
}*/


/////////////////////////////////////////////////////////////////
//INCLUDE <debug.wdl>;

sound salto = <ahh.wav>;
var handleSnd=0;

function sonidoSalto()
{

	if(handleSnd==0 && player._health>0)
	{handleSnd=ent_playsound(player,salto,100);//guardamos el manejador del sonido
	wait(1);
	return;
	}
	
	if(snd_playing(handleSnd)==0 && handleSnd!=0 && player._health>0)//comprobamos que el sonido no est ejecutandose
	{handleSnd=ent_playsound(player,salto,100);
	wait(1);
	return;
	}
}



var i, j;
var k;
var unaVez;//la necesitamos para adquirir el valor del frame una sola vez en la interpolacion de andar a parar
var DePararAndar;//Hacemos una interpolacion de estar parado a andar
var valorActual;
var Xsalto;//Valor de -1 a 1 de la parbola del salto

//entity* entidadCamara;
//entity* pos_intermedia;
var dist[3];
var force[3];
var dis_camara[3];
var distancia_inicial_player;
var distancia_actual_player;
var prueba[3];

define MIN_Z, skill1;


action gorka_move
{ 
      
      player=me;
	snd_loop(sonidoFondo,30,0);
//	entidadCamara=ptr_for_name("bloque_mdl");
//	pos_intermedia=ptr_for_name("intermedia");
	my.skill33=0;//Utilizamos para andar
      my.skill34=0;//Utilizamos para parar
      my.skill35=0;//Utilizamos para correr
	my.skill36=0;//Utilizamos para saltar
	my.skill37=0;//Utilizamos para patada y para morir
	my._health=100;
	i=0;
	k=0;
	unaVez=0;
	DePararAndar=0;
	my.flag1=0;//nos va a indicar si se ha andado
	my.flag2=1;
	my.flag3=0;//Es el flag que nos va a indicar si saltamos
	my.flag6=0;//lo utilizamos para la patada
	Xsalto=-1;
	my.skill25=0;//Inicializamos las baterias
	
	bateriasTotal.visible=on;

/*	vec_set(prueba.x, my.x);
	vec_sub(prueba.x, entidadCamara.x);
	distancia_inicial_player=vec_length(prueba);

	vec_set(pos_intermedia.x, my.x);*/
	drop_shadow();//hecha sombra

	iniciar.visible=on;
	

      while(1)
      {
if(iniciar.visible!=on){estado_jugador();}

      
  if(my._health<=0 && my.flag3==0)
{
	ent_cycle("muerte",my.skill37);
	my.skill37+=2;
	if(my.skill37>100)
	{
		my.skill37=0;
		ent_cycle("muerte",90);
		my.flag1=0;
		my.flag2=0;
		my.flag3=0;
		my.flag4=0;
		my.flag5=0;
		my.flag6=0;
		wait(32);

		my.x=-1046;
		my.y=-447;
		my.z=-2097;
		my.pan=194;
		my.flag1=0;
		my.flag2=0;
		my.flag3=0;
		my.flag4=0;
		my.flag5=0;
		my.flag6=0;
		my._health=100;
	}
		
}
else
{                    
            
		force.pan=-10*(key_force.x+mouse_force.x);//fuerza de rotacion
		if(KEY_SHIFT!=0){force.pan=force.pan/2;}

	   
            my.skill14=time*force.pan+ max(1-time*0.7,0)*my.skill14;//velocidad de rotacion
            my.pan+=time*my.skill14;//rota el jugador


  
            force.x=10*key_force.y;//calculo de la fuerza de translacion

		if(KEY_SHIFT!=0){force.x=force.x/1.5;}

//		if(my.flag3==1){force.x*=0.6;}

            my.skill11=time*force.x+max(1-time*0.95,0)*my.skill11;//calcula la velocidad
           dist.x=time*my.skill11;//distancia a cubrir
//	    dist.x=5*key_force.y;
            dist.y=0;
            
	if(my.flag5==1)
	{
		my.flag3=1;
	}	

	if(my.flag3==0)//Significa que no estamos saltando
	{
	if(my.flag6==0)//significa que no damos patada
	{
		my.skill36=0;
            if(key_force.y!=0)
            {
		i=0;
		unaVez=0;
		my.flag1=1;
		my.skill34=0;
		
//		entidadCamara.flag1=0;
		

		if(my.flag2==1)//Arrancamos
		{
			if(DePararAndar==0)
			{
				valorActual=int(my.frame);
				valorActual=my.frame-valorActual;
				j=(1-valorActual)/6;
				
				if(KEY_SHIFT != 0)
				{my.next_frame=46;}//el primer fotograma del ciclo de correr
				else
				{my.next_frame=1;}//El primer fotograma del ciclo de andar
				DePararAndar=1;
			}


			
				my.frame=my.frame+j;

				k+=1;

			if(k==5)
			{
				my.flag2=0;
			}
		}
		else//Ya hemos arrancado
		{


                	      if(KEY_SHIFT != 0)
				{
				      if(my.skill35<100 && my.skill35>0)
				      {
				            ent_cycle("correr",my.skill35);
                                    my.skill35+=(2*(key_force.y)/2);
                              }
                              else
                              {
                                    if(my.skill35>100)
				            {
        	                         	my.skill35=0;
	        	                        ent_cycle("correr",my.skill35);
	                	                  my.skill35+=(2*key_force.y/2);
	                	       
				            }
				            else
				            {
                                          my.skill35=100;
	                                   	ent_cycle("correr",my.skill35);
		                              my.skill35+=(2*key_force.y/2);
				            }
				       } 
                        
				}
				else
				{
				      if(my.skill33<100 && my.skill33>0)
				      {
				            ent_cycle("andar",my.skill33);
                        	      my.skill33+=(3*key_force.y);
                        		}
        	                  else
                	             {
				            if(my.skill33>100)
				            {
        	                 	            my.skill33=0;
	        	                        ent_cycle("andar",my.skill33);
	                	                  my.skill33+=(3*key_force.y);
				            }
				            else
				            {
                        		      my.skill33=100;
	                        	      ent_cycle("andar",my.skill33);
		                               my.skill33+=(3*key_force.y);
				            }
		
                	            }

				}//fin del if del shift
		 }//fin if de ya hemos arrancado
            
	     }
             else//Paramos
            {
		my.skill33=0;
		my.skill35=0;
		k=0;
		my.flag2=1;
//		entidadCamara.flag1=1;
		DePararAndar=0;
                  if(my.flag1==1)//Hacemos una interpolacion para que la parada sea suave
                  {
			if(unaVez==0)
			{
				valorActual=int(my.frame);
				valorActual=my.frame-valorActual;
				j=(1-valorActual)/6;
				my.next_frame=25;//El primer fotograma del ciclo de parar
				unaVez=1;
			}
	
						
				my.frame=my.frame+j;

				i+=1;

			if(i==5)
			{
				my.flag1=0;
				my.skill34=2*100/21;
				
			}
                        
                  }
		  else//ya hemos parado
		  {
                        if(my.skill34<100)
       	                {
               	              ent_cycle("parado",my.skill34);
                       	      my.skill34+=1;
                        }
       	                else
               	        {
                               my.skill34=0;
       	                     ent_cycle("parado",my.skill34);
               	              my.skill34+=1;
                       	}
              	  }
      	    }
		vec_set(temp,my.x);
		temp.Z = MY.Z -4000;
//            	temp.z-=4000;//calcula una posicion 4000 quants debajo del jugador
            
           	 //ajustamos el modo de trace para que solo detecte los mapas y superficies
 //          	 trace_mode=ignore_me+ignore_sprites+ignore_models+use_box;
          	 trace_mode= IGNORE_SPRITES + IGNORE_ME + IGNORE_PASSABLE + IGNORE_PASSENTS;
            	dist.z=-trace(my.x,temp);//saca la distancia al suelo

		dist.z+=MY.MIN_Z;
 		}//fin del iff del patada
	        else//significa que damos patada
	        {
		ent_cycle("patada",my.skill37);
		my.skill37+=3;
		if(my.skill37>100)
		{
			my.skill37=0;
			my.flag6=0;
		}
	     }//fin del if de patada 
	}//fin del if de salto y comienzo del else
	else//significa que estamos saltando
	{
		vec_set(temp,my.x);
            	temp.z= MY.Z-4000;//calcula una posicion 4000 quants debajo del jugador
            
           	 //ajustamos el modo de trace para que solo detecte los mapas y superficies
 //          	 trace_mode=ignore_me+ignore_sprites+ignore_models+use_box;
          	 trace_mode= IGNORE_SPRITES + IGNORE_ME + IGNORE_PASSABLE + IGNORE_PASSENTS;
            	dist.z=-trace(my.x,temp);//saca la distancia al suelo
		dist.z+=MY.MIN_Z;
		
		ent_cycle("salto",my.skill36);
		dist.z+=(-50*Xsalto*Xsalto)+50;//Ecuacion que nos da la parabola
		Xsalto+=0.05;
		my.skill36+=2.5;

		if(Xsalto>1)
		{
			Xsalto=-1;
			my.flag3=0;
			my.flag5=0;
			my.invisible=off;
			if(key_force.y!=0){my.flag2=1;}
			if(key_force.y==0){my.flag1=1;}
			my.skill33=0;
			my.skill35=0;
			my.skill34=0;
			i=0;
			k=0;
			unavez=0;
			DePararAndar=0;
		}

	}//fin del if del salto
	
	if(KEY_SPACE!=0){
	my.flag3=1;
	sonidoSalto();}//Si pulsamos el espacio saltamos
	
	if(KEY_ALT!=0)
	{
		if(my.flag3==0){my.flag6=1;}
	}
            
           
/*		vec_set(pos_intermedia.x,my.x);
		move(pos_intermedia,dist,nullvector );

		vec_set(prueba.x, pos_intermedia.x);
		vec_sub(prueba.x,entidadCamara.x);
		distancia_actual_player=vec_length(prueba);
   		
		if(distancia_actual_player>0.5*distancia_inicial_player)
		{move(my,dist,nullvector);}*/
	if(my.flag5==1)//Estamos sobre el topo
	{
		dist.x=-3;
		if(my.invisible==off){my.invisible=on;}
		else{my.invisible=off;}
	}

	move_mode = ignore_you + ignore_passable + ignore_push + activate_trigger + glide;
	if(my.flag6==0){move(my,dist,nullvector);}//Si pegamos no nos movemos

           mover_camara();
           
}//fin del else muerte
	wait(1);
	if(KEY_ENTER!=0){iniciar.visible=off;
	finalizar.visible=off;}
        }//fin while 1
 }

action zatorra
{
	//my.skill1=0;
	my.skill2=0;

while(1)
{
	if(player!=0)
	{
	


	vec_set(temp.x, my.x);
	vec_sub(temp.x, player.x);
	my.skill3=vec_length(temp);	
		if(my.skill3<35 && my.skill1<75 && my.skill1>10)//si estamos sobre el topo
		{
			player.flag5=1;
			player._health-=10;
			sonidoSalto();
		}
		ent_cycle("ciclo",my.skill1);
		my.skill2=(100*time)/(4.2*16);
		my.skill1+=my.skill2;

		if(my.skill1>100)
		{
			my.skill1=0;
		}
		
	}
		wait(1);
}//fin while
}


action tranpas
{
	//my.skill1=0;
	my.skill2=0;

while(1)
{
	if(player!=0)
	{
	


	vec_set(temp.x, my.x);
	vec_sub(temp.x, player.x);
	my.skill3=vec_length(temp);	
		if(my.skill3<35 && my.skill1>10)//si estamos sobre la trampa
		{
			player.flag5=1;
			player._health-=10;
			sonidoSalto();
		}
		ent_cycle("ciclo",my.skill1);
		my.skill2=(100*time)/(4.2*16);
		my.skill1+=my.skill2;

		if(my.skill1>100)
		{
			my.skill1=0;
		}
		
	}
		wait(1);
}//fin while
}








var pos_relativa[3];
sound cargaEnergia = <BEAMER.wav>;

action botellaVida
{
my.skill2=0;
my.skill3=my.z;
my.skill4=0;//grados para el movimiento oscilante;

while(1)
{
	if(player!=0)
	{
	
		my.z=my.skill3+(3*sin(my.skill4));
		vec_set(pos_relativa.x,my.x);
		vec_sub(pos_relativa.x,player.x);

	
		
		ent_cycle("vida",my.skill2);

		my.skill1=vec_length(pos_relativa);
		
		if(my.skill1<20 && player._health<100 && my.invisible==off)
		{
			my.invisible=on;
			my.flag1=1;
			ent_playsound(player,cargaEnergia,50);
		}
		
		my.skill2+=(100*time)/(0.8*16);
		my.skill4+=6;

		if(my.flag1==1)
		{
			player._health+=1;

			if(player._health>100)
			{player._health=100;
				my.flag1=0;
			}
		}


	}
		wait(1);
}//fin del while
}





action botellaMuerte
{
my.skill2=0;
my.skill3=my.z;
my.skill4=0;//grados para el movimiento oscilante;

while(1)
{
	if(player!=0)
	{
	
		my.z=my.skill3+(3*sin(my.skill4));
		vec_set(pos_relativa.x,my.x);
		vec_sub(pos_relativa.x,player.x);

	
		
		ent_cycle("vida",my.skill2);

		my.skill1=vec_length(pos_relativa);
		
		if(my.skill1<20 && my.invisible==off)
		{
			my.invisible=on;
			my.flag1=1;
			ent_playsound(player,cargaEnergia,50);
		}
		
		my.skill2+=(100*time)/(0.8*16);
		my.skill4+=6;

		if(my.flag1==1)
		{
			player._health-=20;
			my.flag1=0;
			player.flag5=1;

			sonidoSalto();

		}


	}
		wait(1);
}//fin del while
}

var posMoneda[3];
sound cogeMoneda = <sack.wav>;

action monedas
{
my.skill3=my.z;
my.skill4=0;//grados para el movimiento oscilante;

while(1)
{
	if(player!=0)
	{
	
		
		my.z=my.skill3+(3*sin(my.skill4));
		vec_set(posMoneda.x,my.x);
		vec_sub(posMoneda.x,player.x);

		my.pan+=6;
		
		my.skill1=vec_length(posMoneda);
		
		if(my.skill1<25 && my.invisible==off)
		{
			my.invisible=on;

			player.skill25+=10;
			ent_playsound(player,cogeMoneda,50);
		}
		
		my.skill4+=6;


	}
		wait(1);
}//fin while

}

var pos_player4[3];
var distanciaTrampa;

action trampa
{
	my.skill1=30;
	my.skill2=0;

while(1)
{	

	if(player!=0)
	{
	vec_set(pos_player4.x, my.x);
	vec_sub(pos_player4.x, player.x);
	distanciaTrampa=vec_length(pos_player4);	

	
		if(distanciaTrampa<50 && my.skill1<75 && my.skill1>10)//si estamos sobre el topo
		{
			player.flag5=1;
			player._health-=1;
			sonidoSalto();
		}
		ent_cycle("ciclo",my.skill1);
		my.skill2=(100*time)/(4.2*16);
		my.skill1+=my.skill2;

		if(my.skill1>100)
		{
			my.skill1=0;
		}
			
	}//fin del if
	wait(1);
}//fin del while
}

/*DEFINE _speed, skill1;
DEFINE _turnspeed, skill2;
DEFINE _crit_dist, skill3;

DEFINE _turnto1, flag1;

var to_angle[3];
var pan_diff;
var tilt_diff;

function turn_towards_point()
{
      vec_set(temp, my.skill21);
      vec_sub (temp, my.x);
      vec_to_angle (to_angle, temp);
      my.pan = ang(my.pan);
      my.tilt = ang(my.tilt);
      to_angle.pan = ang(to_angle.pan);
      to_angle.tilt = ang(to_angle.tilt);
      pan_diff = abs(my.pan - to_angle.pan);
      if (pan_diff > 180) { pan_diff = 360 - pan_diff; }
      tilt_diff = abs(my.tilt - to_angle.tilt);
      if (tilt_diff > 180) { tilt_diff = 360 - tilt_diff; }
if (pan_diff > 6 * time * my._turnspeed) { my.skill48 = time * my._turnspeed; }
else {my.skill48 = pan_diff / 6; }
if (((my.pan > to_angle.pan) && (abs(my.pan - to_angle.pan) < 180)) || ((my.pan < to_angle.pan) && (abs(my.pan - to_angle.pan) >= 180)))
{ my.pan -= my.skill48; }
else { my.pan += my.skill48; }
if (tilt_diff > 6 * time * my._turnspeed) { my.skill48 = time * my._turnspeed; }
else {my.skill48 = tilt_diff / 6; }
if (((my.tilt > to_angle.tilt) && (abs(my.tilt - to_angle.tilt) < 180)) || ((my.tilt < to_angle.tilt) && (abs(my.tilt - to_angle.tilt) >= 180)))
{ my.tilt -= my.skill48; }
else { my.tilt += my.skill48; }
}*/



action moverPorPath
{
	//accion que mueve de una manera fluida a una entidad por una path mirando al player
actor_init();
drop_shadow();//hecha sombra



	// attach next path

	my._health=20;

	temp.pan = 360;

	temp.tilt = 180;

	temp.z = 10000;

	result = scan_path(my.x,temp);

	if (result == 0) { my._MOVEMODE = 0; }	// no path found

my.skill40=0;//

	// find first waypoint

	ent_waypoint(my._TARGET_X,1);



	while (my._MOVEMODE > 0)

	{

		// find direction

		temp.x = MY._TARGET_X - MY.X;

		temp.y = MY._TARGET_Y - MY.Y;

		temp.z = 0;

		result = vec_to_angle(my_angle,temp);



		force = MY._FORCE;



		// near target? Find next waypoint

		// compare radius must exceed the turning cycle!

		if (result < 25) { ent_nextpoint(my._TARGET_X); }



		// turn and walk towards target

		actor_turnto(my_angle.PAN);

		actor_move();
		



		// Wait one tick, then repeat
		//Parte en la que se ejecutan los ciclos


		ent_cycle("andar",my.skill40);
		my.skill40+=2;
		if(my.skill40>100){my.skill40=0;}

		wait(1);

	}


}


action monedaFinal
{
my.skill3=my.z;
my.skill4=0;//grados para el movimiento oscilante;

while(1)
{
	if(player!=0)
	{
	
		
		my.z=my.skill3+(3*sin(my.skill4));
		vec_set(posMoneda.x,my.x);
		vec_sub(posMoneda.x,player.x);

		my.pan+=15;
		
		my.skill1=vec_length(posMoneda);
		
		if(my.skill1<25 && my.invisible==off)
		{
			my.invisible=on;

			finalizar.visible=on;

			player.flag1=0;
			player.flag2=0;
			player.flag3=0;
			player.flag4=0;
			player.flag5=0;
			player.flag6=0;
			wait(32);
	
			player.x=-1046;
			player.y=-447;
			player.z=-2097;
			player.pan=194;
			player.flag1=0;
			player.flag2=0;
			player.flag3=0;
			player.flag4=0;
			player.flag5=0;
			player.flag6=0;
			player._health=100;
			my.invisible=off;			
			
		}
		
		my.skill4+=6;


	}
		wait(1);
}//fin while

}

