//
// Fur effect using shells and fins
//
// Note: This effect file does not work with EffectEdit.
//
#define C_ZERO              0 
#define C_ONE               1 
#define C_HALF              2 
#define C_MATTOTAL          4 
#define C_MATWORLD          8 
#define C_LIGHT_DIRECTION   20
#define C_LIGHT_AMBIENT     21
#define C_LIGHT_DIFFUSE     22
#define C_LIGHT_SPECULAR    23
#define C_MATERIAL_SPECULAR 26
#define C_EYE_POSITION      27
#define C_DISPLACEMENTS     30
#define C_TICKS             31
#define C_TICKS2             34
#define C_SINE_RADIUS       32
#define C_DIVERSITY       33

#define C_SIN_CONST0       70
#define C_SIN_CONST1       71
#define C_SIN_CONST2       72
#define C_SIN_CONST3       73
#define C_SIN_CONST4       74



//DEF c0,
float4 SIN_CONST0 = float4(0.0f, 0.5f, 1.0f, 0.0f    );

//DEF c1, 0.25f, -9.0f, 0.75f, 1.0f/(2.0f*PI)
float4 SIN_CONST1 = float4( 0.25f, -9.0f, 0.75f, 1.0f/(2.0f*3.1415926535) );

//DEF c2, 24.9808039603f, -24.9808039603f, -60.1458091736f, 60.1458091736
float4 SIN_CONST2 = float4( 0.25f, -9.0f, 0.75f, 1.0f/(2.0f*3.1415926535 ) );

// DEF c3, 85.4537887573f, -85.4537887573f, -64.9393539429f, 64.9393539429
float4 SIN_CONST3 = float4( 85.4537887573f, -85.4537887573f, -64.9393539429f, 64.9393539429  );

//  DEF c4, 19.7392082214f, -19.7392082214f, - 1.0f, 1.0f
float4 SIN_CONST4 = float4( 19.7392082214f, -19.7392082214f, - 1.0f, 1.0f   );



float TweenFact;

// material specular
float4 k_s = float4(1.0f, 1.0f, 1.0f, 1.0f);
// transformations
float4x4 World      : WORLD;
float4x4 View       : VIEW;
float4x4 Projection : PROJECTION;

// eye position
float3 Eye;

float4 Ticks=float4(1.0f, 1.0f, 1.0f, 1.0f);
float3 Ticks2=float3(1.0f, 1.0f, 1.0f);
float3 Diversity=float3(11.0f, 1.0f, 1.0f );
float3 SineRadius=float3(1.0f, 1.0f, 1.0f);

// textures
texture FinTex;

// shell properties
float ShellThickness = 0.4f;
float ShellScalingFactor;

static const float4 vOne = float4(1, 1, 1, 1);

// vertex shaders
VertexShader ShellVS = asm
{
	;------------------------------------------------------------------------------
	; Constants specified by the app
	;    c0      = ( 0, 0, 0, 0 )
	;    c1      = ( 1, 1, 1, 1 )
	;    c4-c7   = matWorldViewProjection
	;    c8-c10  = matWorld
	;    c20     = light direction (in model space)
	;    c21     = light ambient
	;    c22     = light diffuse
	;    c23     = light specular
	;    c26     = material specular
	;    c27     = eye position (world space)
	;    c30.x   = normal displacement total
	;    c30.y   = normal displacement as a 0 to 1 pct of total
	;    c30.z   = self-shadowing factor
	;
	; Vertex components (as specified in the vertex DECL)
	;    v0    = Position
	;    v3    = Normal
	;    v4    = diffuse
	;    v6    = Texcoords
	;------------------------------------------------------------------------------
	vs.1.1

	dcl_position v0
	dcl_normal   v3
	dcl_color0   v4
	dcl_texcoord v6


        // set up first axis ...
        mul r1,c31.x,c31.y
        mov r0,r1
        mov r2,r1

         //mov r4,v0
         mov r4,v0
         add r4.x,r4.x,r4.y
         add r4.x,r4.x,r4.z

         add r4.x,r4.x,v6.x
        mov r4,v6
        mul r4.x,r4.x,v6.y

         // First Sine
          mul r4.y,r4.x,c33.x
        add r1.x,r1.x,r4.y

     //    add r1.x,r1.x,v6.x
         /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
          // Sinus Function
          // Src = r1.x
          // Dest = r0.x
          // temp = r2
     /////////////////////
     /////////////////////
     /////////////////////


 mad    r1.x, c71.w, r1.x,  -c71.x


 expp    r1.y, r1.x
 slt    r2.x, r1.y, c71
 sge      r2.yz, r1.y, c71
 dp3      r2.y, r2, c74.zwzw
  add    r0.xyz, -r1.y, c70
 mul    r0, r0, r0
   mad       r1, c72.xyxy, r0, c72.zwzw
    mad    r1, r1, r0, c73.xyxy
    mad    r1, r1, r0, c73.zwzw
    mad    r1, r1, r0, c74.xyxy
     mad   r1, r1, r0, c74.zwzw
     dp3   r0.x, r1, -r2
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////// Sinus
          
     // Save Sinus 1
     mov r6 ,r0

     // First Sine End
     ////////////////////////////////////////////////////////////////////////////////////////>
     // Start Second Sine




     //////// END OF FIRST AXIS !!!!!!!!
    ///////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////
    //////////////////
     // set up SECOND axis ...
        mul r1,c31.x,c31.z
        mov r0,r1
        mov r2,r1

                      
           mul r4.y,r4.x,c33.y
        add r1.x,r1.x,r4.y

       //  add r1.x,r1.x,v6.y
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
          // Sinus Function
          // Src = r1.x
          // Dest = r0.x
          // temp = r2
     /////////////////////
     /////////////////////
     /////////////////////


 mad    r1.x, c71.w, r1.x,  -c71.x


 expp    r1.y, r1.x
 slt    r2.x, r1.y, c71
 sge      r2.yz, r1.y, c71
 dp3      r2.y, r2, c74.zwzw
  add    r0.xyz, -r1.y, c70
 mul    r0, r0, r0
   mad       r1, c72.xyxy, r0, c72.zwzw
    mad    r1, r1, r0, c73.xyxy
    mad    r1, r1, r0, c73.zwzw
    mad    r1, r1, r0, c74.xyxy
     mad   r1, r1, r0, c74.zwzw
     dp3   r0.x, r1, -r2
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////// Sinus
                 
     mov r6.y,r0.x
     //////// END OF SECOND AXIS !!!!!!!!
     
     // set up THIRD axis ...
        mul r1,c31.x,c31.w
        mov r0,r1
        mov r2,r1
        
        
       
          mul r4.y,r4.x,c33.z
        add r1.x,r1.x,r4.y
       //  add r1.x,r1.x,v6.z

     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
          // Sinus Function
          // Src = r1.x
          // Dest = r0.x
          // temp = r2
     /////////////////////
     /////////////////////
     /////////////////////


 mad    r1.x, c71.w, r1.x,  -c71.x


 expp    r1.y, r1.x
 slt    r2.x, r1.y, c71
 sge      r2.yz, r1.y, c71
 dp3      r2.y, r2, c74.zwzw
  add    r0.xyz, -r1.y, c70
 mul    r0, r0, r0
   mad       r1, c72.xyxy, r0, c72.zwzw
    mad    r1, r1, r0, c73.xyxy
    mad    r1, r1, r0, c73.zwzw
    mad    r1, r1, r0, c74.xyxy
     mad   r1, r1, r0, c74.zwzw
     dp3   r0.x, r1, -r2
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////////////
     /////////////// Sinus
                 
     mov r6.z,r0.x
     //////// END OF THIRD AXIS !!!!!!!!
    //////////////////
     // Save Sinus 1
     mul r6,r6,c32



	mov r5,v0
	add r5.xyz,r5.xyz,r6.xyz


	// transform vertex position by total matrix and output it
	dp4 oPos.x, r5, c4
	dp4 oPos.y, r5, c5
	dp4 oPos.z, r5, c6
	dp4 oPos.w, r5, c7


	// output the texture coordinates
	mov oT0, v6
};


// sampler
sampler ClampedLinear = 
sampler_state
{
    Texture   = NULL;
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// techniques
technique Init
{
    pass P0
    {
        // render states
        CullMode = NONE;

        AmbientMaterialSource = COLOR1;
        DiffuseMaterialSource = COLOR1;

        BlendOp   = ADD;
        SrcBlend  = SRCALPHA;
        DestBlend = INVSRCALPHA;

        AlphaTestEnable = FALSE;
        AlphaFunc       = GREATER;
        AlphaRef        = 0;

        AlphaBlendEnable = TRUE;

        // texture stage states
        AlphaOp[0]   = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = CURRENT;

        // sampler
        Sampler[0]  = (ClampedLinear);


        Lighting = FALSE;

        // vertex shader constants
        VertexShaderConstantF[C_ZERO]              = (0.0f * vOne);
        VertexShaderConstantF[C_ONE]               = (1.0f * vOne);
        VertexShaderConstantF[C_HALF]              = (0.5f * vOne);
        VertexShaderConstantF[C_MATERIAL_SPECULAR] = (k_s);

        // transforms
        ViewTransform       = (View);
        ProjectionTransform = (Projection);
    }
}

            
struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float3 Diff : COLOR0;
    float3 Tex0 : TEXCOORD0 ;
};
    

VS_OUTPUT VS(
    float3 Pos  : POSITION,
    float3 Norm : NORMAL,
    float3 Diff : COLOR0 ,

    float3 Tex : TEXCOORD0
  )
    {
    VS_OUTPUT Out = (VS_OUTPUT)0;

  //  float3 P = mul(float4(Pos, 1), (float4x3)World);    // position (view space)

     float vertex_offset=(Pos.x*Diversity.x)+(Pos.y*Diversity.y)+(Pos.z*Diversity.z);

  
      float factor=  ((sin(Ticks.x*Ticks.z+(vertex_offset))

      +
              (cos(Ticks.x*Ticks2.z+(vertex_offset)))

      ) *      SineRadius.y);


      float4 P = mul(float4(Pos, 1),  (mul(mul(World, View), Projection)));             // position (projected)

    Out.Pos=P;
     Out.Tex0 =Tex;
     Out.Diff=float3(1,1,1);
    return Out;
}

technique Shells
{
    pass P0
    {
        // render states
        AlphaTestEnable  = TRUE;

        // texture

        // vertex shader
        VertexShader = (ShellVS);

     //VertexShader = compile vs_1_1 VS();

        VertexShaderConstantF[C_DISPLACEMENTS] = float4(0.5f * ShellThickness, ShellScalingFactor, 0.5f * (1 + ShellScalingFactor), 0.0f) ;
        VertexShaderConstantF[C_EYE_POSITION]  = (Eye);
        VertexShaderConstantF[C_MATTOTAL]      = (mul(mul(World, View), Projection));
        VertexShaderConstantF[C_MATWORLD]      = (World);
     

        VertexShaderConstantF[C_TICKS]      = (Ticks);
        VertexShaderConstantF[C_TICKS2]      = (Ticks2);

        VertexShaderConstantF[C_SIN_CONST0]      = (SIN_CONST0);
        VertexShaderConstantF[C_SIN_CONST1]      = (SIN_CONST1);
        VertexShaderConstantF[C_SIN_CONST2]      = (SIN_CONST2);
        VertexShaderConstantF[C_SIN_CONST3]      = (SIN_CONST3);
        VertexShaderConstantF[C_SIN_CONST4]      = (SIN_CONST4);
    VertexShaderConstantF[C_SINE_RADIUS]      = (SineRadius);
    VertexShaderConstantF[C_DIVERSITY]      = (Diversity);


    }
}

