//
// Fur effect using shells and fins
//
// Note: This effect file does not work with EffectEdit.
//
#define C_ZERO              0 
#define C_ONE               1 
#define C_HALF              2 
#define C_MATTOTAL          4 
#define C_MATWORLD          8 
#define C_LIGHT_DIRECTION   20
#define C_LIGHT_AMBIENT     21
#define C_LIGHT_DIFFUSE     22
#define C_LIGHT_SPECULAR    23
#define C_MATERIAL_SPECULAR 26
#define C_EYE_POSITION      27
#define C_DISPLACEMENTS     30
#define C_TICKS             31
#define C_TICKS2             34
#define C_SINE_RADIUS       32
#define C_DIVERSITY       33




float1 Ticks=111.0f;
float1  Tape_Factor=1.1f;
float1  Tape_Shift=1.0f;


// transformations
float4x4 World      : WORLD;
float4x4 View       : VIEW;
float4x4 Projection : PROJECTION;

// eye position
float3 Eye;
float4x4 Mat_Total;

float3 Ticks2=float3(1.0f, 1.0f, 1.0f);



static const float4 vOne = float4(1, 1, 1, 1);

// vertex shaders

// sampler
sampler ClampedLinear = 
sampler_state
{
    Texture   = NULL;
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

// techniques
technique Init
{
    pass P0
    {
        // render states
        CullMode = NONE;

        
        Sampler[0]  = (ClampedLinear);


        Lighting = FALSE;

        // vertex shader constants
        VertexShaderConstantF[C_ZERO]              = (0.0f * vOne);
        VertexShaderConstantF[C_ONE]               = (1.0f * vOne);
        VertexShaderConstantF[C_HALF]              = (0.5f * vOne);

        // transforms
        ViewTransform       = (View);
        ProjectionTransform = (Projection);
    }
}


struct VS_OUTPUT
{
    float4 Pos  : POSITION;
    float3 Diff : COLOR0;
    float3 Tex0 : TEXCOORD0 ;
};


VS_OUTPUT Tape_X(
    float3 Pos  : POSITION,
    float3 Norm : NORMAL,
    float3 Diff : COLOR0 ,

    float3 Tex : TEXCOORD0
  )
    {
    VS_OUTPUT Out = (VS_OUTPUT)0;

     float3 P=(Pos);

     P=normalize(P);
    float1 radius=Tape_Factor*(P.z+Tape_Shift);
    P.z=Pos.z;
    P.x=radius*Pos.x;
    P.y=radius*Pos.y;

   // float4 P2  = mul(float4(P, 1),  (mul(mul(World, View), Projection)) );             // position (projected)
     float4 P2  = mul(  float4(P, 1),Mat_Total );             // position (projected)
    Out.Pos=P2;
     Out.Tex0 =Tex;
     Out.Diff=float3(1,1,1);
    return Out;
}

VS_OUTPUT Twist_X(
    float3 Pos  : POSITION,
    float3 Norm : NORMAL,
    float3 Diff : COLOR0 ,

    float3 Tex : TEXCOORD0
  )
    {
    VS_OUTPUT Out = (VS_OUTPUT)0;

     float3 P=(Pos);

   P=normalize(P);
    float1 radius=(Tape_Shift*P.z)+Tape_Factor;

    float1 cos_a=cos(radius);
    float1 sin_a=sin(radius);

    P.z=Pos.z;
    P.x=Pos.x*cos_a-Pos.y*sin_a;
    P.y=Pos.x*sin_a+Pos.y*cos_a;

  //  float4 P2  = mul(float4(P, 1),  (mul(mul(World, View), Projection)) );             // position (projected)
    float4 P2  = mul(  float4(P, 1),Mat_Total );             // position (projected)
     Out.Pos=P2;
     Out.Tex0 =Tex;
     Out.Diff=float3(1,1,1);
    return Out;
}



VS_OUTPUT Melt_X(
    float3 _Pos  : POSITION,
    float3 Norm : NORMAL,
    float3 Diff : COLOR0 ,

    float3 Tex : TEXCOORD0
  )
    {
    VS_OUTPUT Out = (VS_OUTPUT)0;
  


	//Calculate y
	float3 pos;
	pos.y=_Pos.y ;
	pos.z=pos.y*pos.y*pos.y+Ticks*0.3334f;
	//Y position
	float1 ypos=_Pos.y+pow(_Pos.z , 0.3334f)+2.05f;

	//Calculate xz
	pos.x=_Pos.x;
	pos.z=_Pos.z;
	pos.y=pos.x*pos.x+pos.z*pos.z;
	float l=sqrt(pos.y);
	//Normalize xz direction
	pos.x=pos.x/l;
	pos.z=pos.z/l;

	pos.y=min(l-Ticks-2.0f,0.0f);
	pos.y=sqrt(-pos.y);

	float dx=l+1.4-pos.y;
	float dz=l+1.4-pos.y;

	pos.x=pos.x*dx;
	pos.y=ypos+Ticks;
	pos.z=pos.z*dz;
        pos.x=_Pos.x;
        pos.y=pos.y;
      //  pos.y=+Tape_Shift;
        pos.z=_Pos.z;
  //  float4 P2  = mul(float4(pos, 1),  (mul(mul(World, View), Projection)) );             // position (projected)
    float4 P2  = mul(  float4(pos, 1),Mat_Total );             // position (projected)
     Out.Pos=P2;
      Out.Tex0 =Tex;
    // Out.Diff=float3(1,1,1);
    return Out;
}



technique Tape
{
    pass P0
    {
        // render states
        AlphaTestEnable  = TRUE;

        // texture

        // vertex shader
       // VertexShader = (ShellVS);

      VertexShader = compile vs_1_1 Tape_X();

          VertexShaderConstantF[C_EYE_POSITION]  = (Eye);

          VertexShaderConstantF[C_MATTOTAL]      = (mul(mul(World, View), Projection));
        VertexShaderConstantF[C_MATWORLD]      = (World);


        VertexShaderConstantF[C_TICKS]      = (Ticks);
        VertexShaderConstantF[C_TICKS2]      = (Ticks2);
 


    }
}

technique Twist
{
    pass P0
    {                 

        // render states
        AlphaTestEnable  = TRUE;

        // texture

        // vertex shader
       // VertexShader = (ShellVS);

    VertexShader = compile vs_1_1 Twist_X();
 // VertexShader = compile vs_1_1 Spherical_X();

           VertexShaderConstantF[C_EYE_POSITION]  = (Eye);
          VertexShaderConstantF[C_MATTOTAL]      = (mul(mul(World, View), Projection));
        VertexShaderConstantF[C_MATWORLD]      = (World);


        VertexShaderConstantF[C_TICKS]      = (Ticks);
        VertexShaderConstantF[C_TICKS2]      = (Ticks2);



    }
}
