	SECTION "distade kvadrater", HOME

distbox	START_MUSIC_INT

	call	clearsprites

	ROMBANK	mathb
	ld	hl, font
	ld	de, _VRAM+$20*16
	ld	bc, 64*16
	call	vmemcopy

	ld	a, 1
	ldio	[rVBK], a
	ld	hl, _SCRN0
	ld	bc, 1024
	xor	a
	call	vmemset
	ldio	[rVBK], a
	ld	hl, _SCRN0
	ld	bc, 1024
	call	vmemset

	ROMBANK	data2
	
	; set palettes
	ld	b, 2*8
	ld	hl, distbox_bgpal
	call	setbgpal
	ld	b, 1*8
	call	setobpal

	ld	hl, _SCRN0+34
	call	makedistmap

	ld	hl, distbox_oamdata
	ld	de, oambuf
	ld	b, 160
	call	memcpsh

	call	initline_xor

	xor	a
	ldio	[rSCX], a
	ldio	[rSCY], a

	di
	ld	de, retint
	call	setlcdcirq
	xor	a
	ldio	[rSTAT], a	
	ei

	ld	a, %10000011
	ldio	[rLCDC], a

distbox_main
	waitVBL

	ld	a, $d0
	ldio	[rHDMA1], a
	ld	a, $90
	ldio	[rHDMA3], a
	xor	a
	ldio	[rHDMA2], a
	ldio	[rHDMA4], a
	ld	a, $7f
	ldio	[rHDMA5], a	
	ld	a, oambuf>>8
	call	oamdma

	MusicUpdate musicb
	ROMBANK	mathb

	ld	hl, counter
	inc	[hl]

	ld	hl, $d000
	call	qcls

	ld	h, sintab>>8
	ldh	a, [counter]
	add	a, a
	add	a, 20
	ld	l, a
	ld	a, [hl]
	sra	a
	sra	a
	sra	a
	add	a, 32
	ld	c, a
	ldh	a, [counter]
	add	a, a
	add	a, 20+64
	ld	l, a
	ld	a, [hl]
	sra	a
	sra	a
	sra	a
	cpl
	add	a, 33
	ld	h, a
	ld	l, c
	ld	a, 1
	ldh	[delta], a
	ldh	a, [counter]
	cpl
	ld	b, a
	ldh	a, [counter]
	call	dobox

	ld	h, sintab>>8
	ldh	a, [counter]
	ld	l, a
	add	a, l
	add	a, l
	ld	l, a
	ld	a, [hl]
	neg
	sra	a
	sra	a
	sra	a
	add	a, 32
	ld	c, a
	ldh	a, [counter]
	add	a, 64
	ld	l, a
	ld	a, [hl]
	neg
	sra	a
	sra	a
	sra	a
	add	a, 32
	ld	h, a
	ld	l, c
	xor	a
	ldh	[delta], a
	ldh	a, [counter]
	ld	b, a
	add	a, 40
	call	dobox

	ld	hl, $d000
	call	qxorfil
	ld	hl, $d001
	call	qxorfil

	ldh	a, [counth]
	cp	time+2
	jp	nz, distbox_main
	
	ret
	
dobox	push	hl
	ld	h, sintab>>8
	ld	l, a
	ld	a, [hl]
	sra	a
	sra	a
	add	a, 48-16
	ldh	[alpha], a
	ld	a, b
	and	63
	ld	l, a
	ld	e, [hl]
	set	6, l
	ld	d, [hl]
	ld	a, d
	ldh	[beta], a
	ld	a, e
	ldh	[gamma], a
	ldh	a, [alpha]
	ld	d, a
	ldh	a, [beta]
	call	fastmul
	add	hl, hl
	push	hl
	ldh	a, [gamma]
	call	fastmul
	add	hl, hl
	ld	d, h
	pop	hl
	ld	e, h
	pop	bc
	ld	h, d
	ld	l, e
	rept	3
	push	de
	ld	a, d
	ld	d, e
	neg
	ld	e, a
	endr
	push	de
	push	hl
	rept	4
	pop	hl
	add	hl, bc
	ld	d, h
	ld	e, l
	pop	hl
	push	hl
	add	hl, bc
	push	bc
	ldh	a, [delta]
	rra
	call	line
	pop	bc
	endr
	pop	hl
	ret

	SECTION	"distbox data", DATA, BANK[data2]

distbox_oamdata
y	set	44
x	set	70
p	set	1
	rept	4
	db	y,x,STRSUB("CODE",p,1),0
x	set	x+8
p	set	p+1
	endr
x	set	x+8
p	set	1
	rept	6
	db	y,x,STRSUB("DALTON",p,1),0
x	set	x+8
p	set	p+1
	endr
	DS	(40-10)*4


distbox_bgpal
	DW_RGB	$00, $00, $07
	DW_RGB	$0f, $0a, $0a
	DW_RGB	$0a, $0a, $0f
	DW_RGB	$17, $17, $1f
	
	DW_RGB	$00, $00, $00
	DW_RGB	$0a, $07, $07
	DW_RGB	$07, $07, $0a
	DW_RGB	$17, $17, $1f

distbox_obpal
	DW_RGB	$00, $00, $07
	DW_RGB	$00, $00, $00
	DW_RGB	$07, $07, $07
	DW_RGB	$1f, $1f, $1f
	
time	set 	time+2